/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.seq.spring.boot.autoconfigure;

import com.power4j.kit.seq.core.SeqFormatter;
import com.power4j.kit.seq.core.Sequence;
import com.power4j.kit.seq.ext.InMemorySequenceRegistry;
import com.power4j.kit.seq.ext.SequenceRegistry;
import com.power4j.kit.seq.persistent.Partitions;
import com.power4j.kit.seq.persistent.SeqHolder;
import com.power4j.kit.seq.persistent.SeqSynchronizer;
import com.power4j.kit.seq.spring.boot.autoconfigure.JdbcSynchronizerConfigure;
import com.power4j.kit.seq.spring.boot.autoconfigure.RedisSynchronizerConfigure;
import com.power4j.kit.seq.spring.boot.autoconfigure.SequenceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={SequenceProperties.class})
@Import(value={JdbcSynchronizerConfigure.class, RedisSynchronizerConfigure.class})
public class SequenceAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(SequenceAutoConfigure.class);

    @Bean
    @ConditionalOnMissingBean(value={Long.class}, parameterizedContainer={Sequence.class})
    @ConditionalOnProperty(prefix="power4j.sequence", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public Sequence<Long> sequence(SequenceProperties sequenceProperties, SeqSynchronizer seqSynchronizer) {
        log.info("Sequence create,Using {}", (Object)seqSynchronizer.getClass().getSimpleName());
        return SeqHolder.builder().name(sequenceProperties.getName()).synchronizer(seqSynchronizer).partitionFunc(Partitions.MONTHLY).initValue(sequenceProperties.getStartValue()).poolSize(sequenceProperties.getFetchSize()).seqFormatter(SeqFormatter.DEFAULT_FORMAT).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={SequenceRegistry.class})
    @ConditionalOnProperty(prefix="power4j.sequence", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public SequenceRegistry<Long, Sequence<Long>> sequenceRegistry() {
        return new InMemorySequenceRegistry();
    }
}

