/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.seq.spring.boot.autoconfigure;

import com.power4j.kit.seq.persistent.SeqSynchronizer;
import com.power4j.kit.seq.persistent.provider.LettuceClusterSynchronizer;
import com.power4j.kit.seq.persistent.provider.SimpleLettuceSynchronizer;
import com.power4j.kit.seq.spring.boot.autoconfigure.SequenceProperties;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RedisClient.class, RedisClusterClient.class})
public class RedisSynchronizerConfigure {
    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="power4j.sequence", name={"backend"}, havingValue="redis")
    public RedisClient redisClient(SequenceProperties sequenceProperties) {
        RedisURI redisUri = RedisURI.create((String)sequenceProperties.getLettuceUri());
        return RedisClient.create((RedisURI)redisUri);
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="power4j.sequence", name={"backend"}, havingValue="redis-cluster")
    public RedisClusterClient redisClusterClient(SequenceProperties sequenceProperties) {
        RedisURI redisUri = RedisURI.create((String)sequenceProperties.getLettuceUri());
        return RedisClusterClient.create((RedisURI)redisUri);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisClient.class})
    public SeqSynchronizer redisSynchronizer(SequenceProperties sequenceProperties, RedisClient redisClient) {
        SimpleLettuceSynchronizer synchronizer = new SimpleLettuceSynchronizer(sequenceProperties.getTableName(), redisClient);
        if (!sequenceProperties.isLazyInit()) {
            synchronizer.init();
        }
        return synchronizer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedisClusterClient.class})
    public SeqSynchronizer redisClusterSynchronizer(SequenceProperties sequenceProperties, RedisClusterClient redisClusterClient) {
        LettuceClusterSynchronizer synchronizer = new LettuceClusterSynchronizer(sequenceProperties.getTableName(), redisClusterClient);
        if (!sequenceProperties.isLazyInit()) {
            synchronizer.init();
        }
        return synchronizer;
    }
}

