/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.seq.spring.boot.autoconfigure;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.power4j.kit.seq.persistent.SeqSynchronizer;
import com.power4j.kit.seq.persistent.provider.SimpleMongoSynchronizer;
import com.power4j.kit.seq.spring.boot.autoconfigure.SequenceProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MongoClient.class})
public class MongoSynchronizerConfigure {
    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="power4j.sequence", name={"backend"}, havingValue="mongo")
    public MongoClient mongoClient(SequenceProperties sequenceProperties) {
        return MongoClients.create((String)sequenceProperties.getMongoUri());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MongoClient.class})
    public SeqSynchronizer mongoSynchronizer(SequenceProperties sequenceProperties, MongoClient mongoClient) {
        SimpleMongoSynchronizer synchronizer = new SimpleMongoSynchronizer("sequence", sequenceProperties.getTableName(), mongoClient);
        if (!sequenceProperties.isLazyInit()) {
            synchronizer.init();
        }
        return synchronizer;
    }
}

