/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.seq.spring.boot.autoconfigure;

import com.power4j.kit.seq.persistent.SeqSynchronizer;
import com.power4j.kit.seq.persistent.provider.MySqlSynchronizer;
import com.power4j.kit.seq.persistent.provider.PostgreSqlSynchronizer;
import com.power4j.kit.seq.spring.boot.autoconfigure.SequenceProperties;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JdbcSynchronizerConfigure {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnProperty(prefix="power4j.sequence", name={"backend"}, havingValue="mysql")
    public SeqSynchronizer mysqlSynchronizer(SequenceProperties sequenceProperties, DataSource dataSource) {
        MySqlSynchronizer synchronizer = new MySqlSynchronizer(sequenceProperties.getTableName(), dataSource);
        if (!sequenceProperties.isLazyInit()) {
            synchronizer.init();
        }
        return synchronizer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnProperty(prefix="power4j.sequence", name={"backend"}, havingValue="postgresql")
    public SeqSynchronizer postgreSqlSynchronizer(SequenceProperties sequenceProperties, DataSource dataSource) {
        PostgreSqlSynchronizer synchronizer = new PostgreSqlSynchronizer(sequenceProperties.getTableName(), dataSource);
        if (!sequenceProperties.isLazyInit()) {
            synchronizer.init();
        }
        return synchronizer;
    }
}

