/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.xa;

import com.oscar.jdbc.OscarXid;
import com.oscar.jdbc.StringUtils;
import com.oscar.jdbcx.Jdbc3PooledConnection;
import com.oscar.util.XAOSQLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class Jdbc3XAConnection
extends Jdbc3PooledConnection
implements XAConnection,
XAResource {
    private final Connection conn;
    private Xid currentXid;
    private int state;
    private static final int STATE_IDLE = 0;
    private static final int STATE_ACTIVE = 1;
    private static final int STATE_ENDED = 2;

    public Jdbc3XAConnection(Connection con) {
        super(con, true, true);
        this.conn = con;
        this.state = 0;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        StringBuilder commandBuf = new StringBuilder();
        commandBuf.append("XA COMMIT ");
        Jdbc3XAConnection.appendXid(commandBuf, xid);
        if (onePhase) {
            commandBuf.append(" ONE PHASE");
        }
        if (!this.currentXid.equals(xid)) {
            throw new XAOSQLException("prepare must be issued using the same connection that started the transaction");
        }
        if (this.state != 2) {
            throw new XAOSQLException("commit called before end");
        }
        try {
            this.executeXA(commandBuf.toString());
        }
        catch (SQLException ex) {
            throw new XAOSQLException(ex.getMessage());
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAOSQLException("xid must not be null");
        }
        StringBuilder commandBuf = new StringBuilder();
        commandBuf.append("XA END ");
        Jdbc3XAConnection.appendXid(commandBuf, xid);
        switch (flags) {
            case 0x2000000: {
                commandBuf.append(" SUSPEND");
                break;
            }
        }
        if (this.state != 1 || !this.currentXid.equals(xid)) {
            throw new XAOSQLException("tried to call end without corresponding start call");
        }
        try {
            this.executeXA(commandBuf.toString());
        }
        catch (SQLException e) {
            throw new XAOSQLException(e.getMessage());
        }
        this.state = 2;
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return xares == this;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (!this.currentXid.equals(xid)) {
            throw new XAOSQLException("prepare must be issued using the same connection that started the transaction");
        }
        if (this.state != 2) {
            throw new XAOSQLException("Prepare called before end");
        }
        try {
            StringBuilder commandBuf = new StringBuilder();
            commandBuf.append("XA PREPARE ");
            Jdbc3XAConnection.appendXid(commandBuf, xid);
            this.executeXA(commandBuf.toString());
            return 0;
        }
        catch (SQLException ex) {
            throw new XAOSQLException(ex.getMessage());
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (flag != 0x1000000 && flag != 0x800000 && flag != 0 && flag != 0x1800000) {
            throw new XAOSQLException(-5, "xa transaction recover not supported");
        }
        ResultSet rs = null;
        Statement stmt = null;
        ArrayList<OscarXid> recoveredXidList = new ArrayList<OscarXid>();
        try {
            stmt = this.conn.createStatement();
            stmt.execute("XA RECOVER");
            rs = stmt.getResultSet();
            while (rs.next()) {
                int formatId = rs.getInt(1);
                int gtridLength = rs.getInt(2);
                int bqualLength = rs.getInt(3);
                byte[] gtridAndBqual = rs.getBytes(4);
                byte[] gtrid = new byte[gtridLength];
                byte[] bqual = new byte[bqualLength];
                if (gtridAndBqual.length != gtridLength + bqualLength) {
                    throw new XAOSQLException("Error while recovering XIDs from RM. GTRID and BQUAL are wrong ");
                }
                System.arraycopy(gtridAndBqual, 0, gtrid, 0, gtridLength);
                System.arraycopy(gtridAndBqual, gtridLength, bqual, 0, bqualLength);
                recoveredXidList.add(new OscarXid(gtrid, bqual, formatId));
            }
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
            throw new XAOSQLException(sqlEx.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        int numXids = recoveredXidList.size();
        Xid[] asXids = new Xid[numXids];
        Object[] asObjects = recoveredXidList.toArray();
        for (int i = 0; i < numXids; ++i) {
            asXids[i] = (Xid)asObjects[i];
        }
        return asXids;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        StringBuilder commandBuf = new StringBuilder();
        commandBuf.append("XA ROLLBACK ");
        Jdbc3XAConnection.appendXid(commandBuf, xid);
        try {
            this.executeXA(commandBuf.toString());
        }
        catch (SQLException ex) {
            throw new XAOSQLException(ex.getMessage());
        }
    }

    @Override
    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAOSQLException("xid must not be null");
        }
        StringBuilder commandBuf = new StringBuilder();
        commandBuf.append("XA START ");
        Jdbc3XAConnection.appendXid(commandBuf, xid);
        switch (flags) {
            case 0x8000000: {
                commandBuf.append(" RESUME");
                break;
            }
            case 0x200000: {
                commandBuf.append(" JOIN");
                break;
            }
        }
        if (this.state == 1) {
            throw new XAOSQLException("Connection is busy with another transaction");
        }
        try {
            this.executeXA(commandBuf.toString());
        }
        catch (SQLException ex) {
            throw new XAOSQLException(ex.getMessage());
        }
        this.state = 1;
        this.currentXid = xid;
    }

    private static void appendXid(StringBuilder builder, Xid xid) {
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] btrid = xid.getBranchQualifier();
        if (gtrid != null) {
            StringUtils.appendAsHex(builder, gtrid);
        }
        builder.append(',');
        if (btrid != null) {
            StringUtils.appendAsHex(builder, btrid);
        }
        builder.append(',');
        StringUtils.appendAsHex(builder, xid.getFormatId());
    }

    public void executeXA(String sql) throws SQLException {
        try (Statement st = null;){
            st = this.conn.createStatement();
            st.execute(sql);
        }
    }
}

