/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class TrackLog {
    public static final int NONLOG_LEVEL = 0;
    public static final int SQL_LEVEL = 1;
    public static final int INTERFACE_LEVEL = 2;
    public static final int PROTOCOL_LEVEL = 3;
    public static final int PROTOCOLDETAIL_LEVEL = 4;
    private static TrackLog trackLog;
    private PrintStream ps = null;
    private FileInputStream inputStream = null;
    private int logLevel = 0;
    private int maxFileSize = 0x6400000;
    private String logPath;
    private final String defaultConfigFilePath = System.getProperty("user.dir");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssSSS");

    private TrackLog(int logLevel, String logPath, Object maxFileSize) {
        this.logLevel = logLevel;
        this.initLogPath(logPath);
        if (maxFileSize != null) {
            this.maxFileSize = Integer.parseInt(maxFileSize.toString()) * 1024 * 1024;
        }
    }

    public static synchronized TrackLog getInstance(int logLevel, String logPath, Object maxFileSize) {
        if (trackLog == null) {
            trackLog = new TrackLog(logLevel, logPath, maxFileSize);
        }
        return trackLog;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public String getDefaultConfigFilePath() {
        return this.defaultConfigFilePath;
    }

    public synchronized void initLogPath(String filePath) {
        try {
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.logLevel > 0 || this.logLevel == -1) {
            this.logPath = filePath == null ? this.getDefaultConfigFilePath() : filePath;
            try {
                File folder = new File(this.logPath);
                if (!folder.exists() || !folder.isDirectory()) {
                    folder.mkdirs();
                }
                String logFile = null;
                if (folder.isDirectory()) {
                    StringBuffer logFilePathSb = new StringBuffer(50);
                    logFilePathSb.append(folder.getAbsolutePath()).append(File.separatorChar).append("OscarJDBC").append(this.dateFormat.format(new Date())).append(".log");
                    logFile = logFilePathSb.toString();
                } else {
                    logFile = folder.getAbsolutePath() + this.dateFormat.format(new Date()) + ".log";
                }
                FileOutputStream fos = new FileOutputStream(logFile, false);
                this.inputStream = new FileInputStream(logFile);
                this.ps = new PrintStream(fos);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void initLogPath() {
        this.initLogPath(null);
    }

    public static void main(String[] args) {
    }

    public StackTraceElement getFrame() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        return stack[1];
    }

    public synchronized void writeLog(String msg) {
        if (this.getFileSize() >= this.maxFileSize) {
            if (this.logPath == null) {
                this.initLogPath();
            } else {
                this.initLogPath(this.logPath);
            }
        }
        if ((this.logLevel > 0 || this.logLevel == -1) && this.ps != null) {
            StringBuilder logLine = new StringBuilder(200);
            this.appendDateString(logLine);
            logLine.append(", TN: ").append(Thread.currentThread().getName()).append(", ").append(msg);
            this.ps.println(logLine);
        }
    }

    private int getFileSize() {
        if (this.inputStream != null) {
            try {
                int fileSize = this.inputStream.available();
                return fileSize;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    private void appendDateString(StringBuilder logLine) {
        GregorianCalendar calendar = new GregorianCalendar();
        logLine.append(calendar.get(1)).append("-").append(calendar.get(2) + 1).append("-").append(calendar.get(5)).append(" ").append(calendar.get(11)).append(":").append(calendar.get(12)).append(":").append(calendar.get(13)).append(".").append(calendar.get(14));
    }
}

