/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.protocol.OSCARProtocol;
import com.oscar.protocol.packets.QueryPacket;
import com.oscar.protocol.stream.OStream;
import com.oscar.util.ImportBufferManager;
import com.oscar.util.ImportStream;
import java.sql.SQLException;

public class ShareImportStream1
extends ImportStream {
    private byte[] buffer;
    private byte[] cache;
    private int bufferOffset = 1;
    private int batchRowCounts = 0;
    private int batchRowsOffset = 1;
    private int batchRowsEnd = 0;
    private ImportDataThread thread;
    private boolean cacheDataFilled = false;
    private boolean ended = false;
    private boolean bulkflow = false;
    private boolean inited = false;

    public ShareImportStream1(OscarImportHandler handler) {
        this.handler = handler;
        this.defaultBufferSize = handler.getBufferSize();
        if (handler.getBulkKind() == 0) {
            this.bulkflow = true;
        }
        this.reInit();
    }

    @Override
    public void reInit() {
        this.cacheSize = 0;
        this.position = 0;
        this.rowPosition = 0;
        this.cacheDataFilled = false;
        this.ended = false;
        this.finished = false;
        this.exFinished = false;
        this.inited = false;
        this.thread = new ImportDataThread();
        this.thread.start();
    }

    @Override
    public void write(byte[] b, int off, int len) throws SQLException {
        if (off < 0 || len > b.length) {
            throw new NullPointerException();
        }
        if (len + off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position + len < this.defaultBufferSize) {
            System.arraycopy(b, off, this.getBuffer(), this.position, len);
            this.position += len;
        } else {
            this.flush();
            if (this.position + len > this.defaultBufferSize) {
                this.flush();
                if (this.position + len > this.defaultBufferSize) {
                    throw new SQLException("The buffer does not have enough space, so increase the buffer");
                }
            }
            System.arraycopy(b, off, this.getBuffer(), this.position, len);
            this.position += len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(byte[] data) throws SQLException {
        QueryPacket qp = null;
        if (!this.bulkflow || !this.inited) {
            this.currentSql = this.handler.getInsertBulkStr().toString();
            if (this.handler.getHintParam() != null) {
                this.currentSql = this.currentSql + " WITH " + this.handler.getHintParam();
            }
            qp = new QueryPacket(this.handler.getConnection().getEncoding().encode(this.currentSql), 0);
        }
        OStream oStream = this.handler.getConnection().getProtocol().oStream;
        synchronized (oStream) {
            OSCARProtocol protocol = this.handler.getConnection().getProtocol();
            protocol.setImportHandler(this.handler);
            if (!this.bulkflow || !this.inited) {
                protocol.importBegin(qp);
            }
            if (this.handler.getImportBlockParam() == 1) {
                byte[] dataLen = new byte[]{(byte)(data.length >> 24 & 0xFF), (byte)(data.length >> 16 & 0xFF), (byte)(data.length >> 8 & 0xFF), (byte)(data.length & 0xFF)};
                protocol.importData(dataLen);
            }
            protocol.importData(data);
            if (!this.bulkflow) {
                protocol.importEnd();
                this.updateCount += this.handler.getUpdateCount();
                this.handler.setUpdateCount(this.updateCount);
            }
        }
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importEnd() throws SQLException {
        if (!this.bulkflow) {
            return;
        }
        OStream oStream = this.handler.getConnection().getProtocol().oStream;
        synchronized (oStream) {
            OSCARProtocol protocol = this.handler.getConnection().getProtocol();
            protocol.setImportHandler(this.handler);
            protocol.importEnd();
            this.updateCount += this.handler.getUpdateCount();
            this.handler.setUpdateCount(this.updateCount);
        }
        this.inited = false;
    }

    public synchronized byte[] getMessage() {
        byte[] data = null;
        while (true) {
            if (this.cacheDataFilled) {
                data = new byte[this.cacheSize];
                System.arraycopy(this.getCache(), 0, data, 0, this.cacheSize);
                this.releaseCache();
                this.cacheDataFilled = false;
                this.notify();
                break;
            }
            if (this.finished) break;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return data;
    }

    public synchronized void setMessage() {
        while (!this.ended) {
            if (!this.cacheDataFilled) {
                if (this.rowPosition == 0) {
                    System.arraycopy(this.getBuffer(), 0, this.getCache(), 0, this.position);
                    this.cacheSize = this.position;
                    this.position = 0;
                    this.releaseBuffer();
                } else {
                    System.arraycopy(this.getBuffer(), 0, this.getCache(), 0, this.rowPosition);
                    this.cacheSize = this.rowPosition;
                    if (this.position > this.rowPosition) {
                        this.moveData(this.getBuffer(), 0, this.rowPosition);
                    }
                    this.position -= this.rowPosition;
                    this.rowPosition = 0;
                }
                this.cacheDataFilled = true;
                this.batchRowsOffset = this.bufferOffset;
                this.batchRowsEnd = this.batchRowCounts;
                this.bufferOffset = this.batchRowCounts + 1;
                this.notify();
                break;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished() {
        this.finished = true;
        this.releaseBuffer();
        while (!this.ended && !this.exFinished) {
            ShareImportStream1 shareImportStream1 = this;
            synchronized (shareImportStream1) {
                this.notify();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void flush() {
        this.setMessage();
    }

    public void moveData(byte[] bytes, int offset, int length) {
        System.arraycopy(this.getBuffer(), length, this.getBuffer(), 0, this.position - length);
    }

    public void moveData(byte[] bytes) throws SQLException {
        this.moveData(bytes, 0, bytes.length);
    }

    @Override
    public void setRowPosition() {
        this.rowPosition = this.position;
    }

    @Override
    public ImportHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setDefaultBufferSize(int size) {
        this.defaultBufferSize = size;
    }

    @Override
    public void close() {
        this.releaseBuffer();
        this.releaseCache();
        this.thread = null;
    }

    @Override
    public void batchRowsIncrease() {
        ++this.batchRowCounts;
    }

    @Override
    public int getBatchRowsOffset() {
        return this.batchRowsOffset;
    }

    @Override
    public int getBatchRowsEnd() {
        return this.batchRowsEnd;
    }

    public byte[] getBuffer() {
        if (this.buffer == null) {
            try {
                this.buffer = ImportBufferManager.getBuffer(this.defaultBufferSize);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.buffer;
    }

    public byte[] getCache() {
        if (this.cache == null) {
            this.cache = ImportBufferManager.getBufferAllways(this.defaultBufferSize);
        }
        return this.cache;
    }

    public void releaseBuffer() {
        ImportBufferManager.releaseBuffer(this.buffer);
        this.buffer = null;
    }

    public void releaseCache() {
        ImportBufferManager.releaseCache(this.cache);
        this.cache = null;
    }

    class ImportDataThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block31: {
                block24: while (true) {
                    while (true) {
                        byte[] data = null;
                        if (ShareImportStream1.this.finished && !ShareImportStream1.this.cacheDataFilled) {
                            break block31;
                        }
                        if (ShareImportStream1.this.exFinished) {
                            ShareImportStream1 shareImportStream1 = ShareImportStream1.this;
                            synchronized (shareImportStream1) {
                                ShareImportStream1.this.notify();
                                break block31;
                            }
                        }
                        try {
                            data = ShareImportStream1.this.getMessage();
                            if (data == null) {
                                break block31;
                            }
                            ShareImportStream1.this.sendMessage(data);
                            continue block24;
                        }
                        catch (SQLException ex) {
                            ShareImportStream1.this.threadException = ex;
                            ShareImportStream1.this.exFinished = true;
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            ShareImportStream1.this.threadException = ex;
                            ShareImportStream1.this.exFinished = true;
                            continue;
                        }
                        catch (Throwable ex) {
                            ShareImportStream1.this.threadException = ex;
                            ShareImportStream1.this.exFinished = true;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (!ShareImportStream1.this.exFinished) {
                        try {
                            ShareImportStream1.this.importEnd();
                            ShareImportStream1.this.ended = true;
                        }
                        catch (SQLException ex) {
                            ShareImportStream1.this.threadException = ex;
                            ShareImportStream1.this.exFinished = true;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            ShareImportStream1.this.threadException = ex;
                            ShareImportStream1.this.exFinished = true;
                        }
                        catch (Throwable ex) {
                            ShareImportStream1.this.threadException = ex;
                            ShareImportStream1.this.exFinished = true;
                        }
                    }
                    if (ShareImportStream1.this.exFinished) {
                        ShareImportStream1.this.ended = true;
                        ShareImportStream1 shareImportStream1 = ShareImportStream1.this;
                        synchronized (shareImportStream1) {
                            ShareImportStream1.this.notify();
                        }
                    }
                }
            }
        }
    }
}

