/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.sql;

public class Time
extends java.sql.Time {
    private static final long serialVersionUID = 2761880807538277795L;
    private int nanos;
    private int zone = 15;
    private String nanosString = "";
    private StringBuilder zoneString = new StringBuilder(10);

    public Time(long time) {
        super(time);
        this.computeZoneString();
    }

    public Time(int hour, int minute, int second) {
        super(hour, minute, second);
        this.computeZoneString();
    }

    public static Time valueOf(String s) {
        return new Time(java.sql.Time.valueOf(s).getTime());
    }

    public void setNanos(int n) {
        if (n > 999999999 || n < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = n;
        this.computeNanosString();
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer(super.toString());
        if (!"".equals(this.nanosString)) {
            ret.append(".").append(this.nanosString);
        }
        ret.append((CharSequence)this.zoneString);
        return ret.toString();
    }

    public void setZone(int zone) {
        this.zone = zone;
        this.computeZoneString();
    }

    private void computeNanosString() {
        if (this.nanos != 0) {
            String zeros = "000000000";
            this.nanosString = Integer.toString(this.nanos);
            this.nanosString = zeros.substring(0, 9 - this.nanosString.length()) + this.nanosString;
            char[] nanosChar = new char[this.nanosString.length()];
            this.nanosString.getChars(0, this.nanosString.length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            this.nanosString = new String(nanosChar, 0, truncIndex + 1);
        }
    }

    private void computeZoneString() {
        if (this.zone != 15 && this.zone != 0) {
            int zoneHour = this.zone / 3600;
            if (-10 < zoneHour && zoneHour < 0) {
                this.zoneString.append("-0").append(-zoneHour);
            } else if (zoneHour >= 0 && zoneHour < 10) {
                this.zoneString.append("+0").append(zoneHour);
            } else if (zoneHour >= 10) {
                this.zoneString.append("+").append(zoneHour);
            } else if (zoneHour <= -10) {
                this.zoneString.append(zoneHour);
            }
            this.zoneString.append(":");
            int zoneMin = this.zone % 3600 / 60;
            if (zoneMin < 0) {
                zoneMin = -zoneMin;
            }
            if (0 <= zoneMin && zoneMin < 10) {
                this.zoneString.append("0");
            }
            this.zoneString.append(zoneMin);
        } else if (this.zone == 0) {
            this.zoneString.append(" +00:00");
        }
    }

    public int getZone() {
        return this.zone;
    }

    public String getZoneString() {
        return this.zoneString.toString();
    }

    public int getNanos() {
        return this.nanos;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

