/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.protocol.packets;

import com.ongres.scram.client.ScramClient;
import com.ongres.scram.client.ScramSession;
import com.ongres.scram.common.exception.ScramException;
import com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.exception.ScramServerErrorException;
import com.oscar.protocol.packets.BasePacket;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarStringPreparation;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;

public class ScramSupport {
    public static final int AUTH_REQ_SASL = 10;
    public static final int AUTH_REQ_SASL_CONT = 11;
    public static final int AUTH_REQ_SASL_FIN = 12;
    private ScramSession scramSession;
    private ScramClient scramClient;
    private ScramSession.ServerFirstProcessor serverFirstProcessor;
    private ScramSession.ClientFinalProcessor clientFinalProcessor;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private String password;

    public void setPassword(String password) {
        this.password = password;
    }

    public void sendTo(BufferedOutputStream stream, int authenPolicy) throws IOException, SQLException {
        if (authenPolicy == 10) {
            this.sendScramClientFirstMessage(stream);
        } else if (authenPolicy == 11) {
            this.sendScramClientFinalMessage(stream);
        }
    }

    public void receiveFrom(InputStream stream, int authenPolicy) throws IOException, SQLException {
        int len = BasePacket.ReceiveIntegerR(stream, 4);
        byte[] data = BasePacket.Receive(stream, len);
        switch (authenPolicy) {
            case 10: {
                this.processServerMechanismsAndInit(data);
                break;
            }
            case 11: {
                this.processServerFirstMessage(data);
                break;
            }
            case 12: {
                this.verifyServerSignature(data);
                break;
            }
        }
    }

    public static boolean isScramPolicy(int authenPolicy) {
        return authenPolicy == 10 || authenPolicy == 11 || authenPolicy == 12;
    }

    public void processServerMechanismsAndInit(byte[] data) throws SQLException {
        String dataStr = new String(data);
        ArrayList<String> mechanisms = new ArrayList<String>();
        mechanisms.add(dataStr.trim());
        try {
            this.scramClient = ScramClient.channelBinding(ScramClient.ChannelBinding.NO).stringPreparation(OscarStringPreparation.NO_PREPARATION).selectMechanismBasedOnServerAdvertised(mechanisms.toArray(new String[0])).setup();
        }
        catch (IllegalArgumentException e) {
            throw new OSQLException("Invalid or unsupported by client SCRAM mechanisms", "08004", 106, e);
        }
        this.scramSession = this.scramClient.scramSession("*");
    }

    public void processServerFirstMessage(byte[] data) throws IOException, SQLException {
        String serverFirstMessage = new String(data);
        try {
            this.serverFirstProcessor = this.scramSession.receiveServerFirstMessage(serverFirstMessage);
        }
        catch (ScramException e) {
            throw new OSQLException("Invalid server-first-message", "08004", 106, e.getMessage(), e);
        }
    }

    public void verifyServerSignature(byte[] data) throws IOException, SQLException {
        String serverFinalMessage = new String(data);
        try {
            this.clientFinalProcessor.receiveServerFinalMessage(serverFinalMessage);
        }
        catch (ScramParseException e) {
            throw new OSQLException("Invalid server-final-message", "08004", 106, e.getMessage(), e);
        }
        catch (ScramServerErrorException e) {
            throw new OSQLException("SCRAM authentication failed, server returned error", "08004", 106, e.getMessage(), e);
        }
        catch (ScramInvalidServerSignatureException e) {
            throw new OSQLException("Invalid server SCRAM signature", "08004", 106, e);
        }
    }

    private void sendAuthenticationMessage(BufferedOutputStream stream, int bodyLength, BodySender bodySender) throws IOException {
        BasePacket.SendChar(stream, 112);
        BasePacket.SendInteger(stream, 4 + bodyLength, 4);
        bodySender.sendBody(stream);
        stream.flush();
    }

    public void sendScramClientFirstMessage(BufferedOutputStream stream) throws IOException {
        String clientFirstMessage = this.scramSession.clientFirstMessage();
        String scramMechanismName = this.scramClient.getScramMechanism().getName();
        final byte[] scramMechanismNameBytes = scramMechanismName.getBytes(UTF_8);
        final byte[] clientFirstMessageBytes = clientFirstMessage.getBytes(UTF_8);
        this.sendAuthenticationMessage(stream, scramMechanismNameBytes.length + 1 + 4 + clientFirstMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(BufferedOutputStream stream) throws IOException {
                BasePacket.Send(stream, scramMechanismNameBytes);
                BasePacket.SendInteger(stream, 0, 1);
                BasePacket.SendInteger(stream, clientFirstMessageBytes.length, 4);
                BasePacket.Send(stream, clientFirstMessageBytes);
            }
        });
    }

    public void sendScramClientFinalMessage(BufferedOutputStream stream) throws IOException {
        this.clientFinalProcessor = this.serverFirstProcessor.clientFinalProcessor(this.password);
        String clientFinalMessage = this.clientFinalProcessor.clientFinalMessage();
        final byte[] clientFinalMessageBytes = clientFinalMessage.getBytes(UTF_8);
        this.sendAuthenticationMessage(stream, clientFinalMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(BufferedOutputStream stream) throws IOException {
                BasePacket.Send(stream, clientFinalMessageBytes);
            }
        });
    }

    private static interface BodySender {
        public void sendBody(BufferedOutputStream var1) throws IOException;
    }
}

