/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.protocol;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.ExportBinlogHandler;
import com.oscar.core.Field;
import com.oscar.core.ImportBinlogHandler;
import com.oscar.jdbc.BlogResultSet;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.protocol.Packet;
import com.oscar.protocol.packets.AsciiRowPacket;
import com.oscar.protocol.packets.BLogErrorResponsePacket;
import com.oscar.protocol.packets.BackupMetaDataPacket;
import com.oscar.protocol.packets.BackupPhysicalDataPacket;
import com.oscar.protocol.packets.BackupPhysicalRowEndPacket;
import com.oscar.protocol.packets.BasePacket;
import com.oscar.protocol.packets.BatchProcessPacket;
import com.oscar.protocol.packets.BinlogErrorPacket;
import com.oscar.protocol.packets.BlogDataPacket;
import com.oscar.protocol.packets.CancelRequestPacket;
import com.oscar.protocol.packets.CompleteResponsePacket;
import com.oscar.protocol.packets.CursorResponsePacket;
import com.oscar.protocol.packets.EmptyQueryResponsePacket;
import com.oscar.protocol.packets.ErrorResponsePacket;
import com.oscar.protocol.packets.ExportBinlogSuccessPacket;
import com.oscar.protocol.packets.FunctionCallPacket;
import com.oscar.protocol.packets.FunctionResponsePacket;
import com.oscar.protocol.packets.HashDataPacket;
import com.oscar.protocol.packets.ImportExportResponsePacket;
import com.oscar.protocol.packets.ImportPacket;
import com.oscar.protocol.packets.NewImportPacket;
import com.oscar.protocol.packets.NoticeResponsePacket;
import com.oscar.protocol.packets.ParamInforPacket;
import com.oscar.protocol.packets.QueryPacket;
import com.oscar.protocol.packets.QueryPacketHash;
import com.oscar.protocol.packets.ReadyForMetaData;
import com.oscar.protocol.packets.ReadyForPhysicalDataPacket;
import com.oscar.protocol.packets.ReadyForQueryPacket;
import com.oscar.protocol.packets.RowDescriptionPacket;
import com.oscar.protocol.packets.SetQueryLsnPacket;
import com.oscar.protocol.packets.TerminatePacket;
import com.oscar.protocol.stream.OSocket;
import com.oscar.protocol.stream.OStream;
import com.oscar.util.OSQLException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class OSCARProtocol {
    public OStream oStream;
    protected BaseConnection connection;
    protected String host;
    protected int port;
    protected String database;
    protected String db_user;
    protected String db_passwd;
    protected BaseStatement statement;
    protected volatile OscarImportHandler handler;
    protected ImportBinlogHandler importBinlogHandler;
    protected ExportBinlogHandler exportBinlogHandler;
    protected BaseResultSet resultset;
    protected long update_count = -2L;
    protected int pid;
    protected int ckey;
    protected Properties info;
    protected static final int ProtocolMajorVersion = 2;
    protected static final int ProtocolMinorVersion = 0;
    protected int listenerVersion = 0;
    public static final int PROTOCOL_OK = 1;
    public static final int PROTOCOL_WAIT = 0;
    public static final int PROTOCOL_FAIL = -1;
    protected int status = 0;
    protected byte[] cmd = null;
    protected BasePacket bk = null;
    protected Packet pk = new Packet();
    protected int errorRetryTimes;
    protected boolean logFlag = Driver.getLogLevel() >= 3;

    public OSCARProtocol(BaseConnection con, String _host, int _port, String _database, String user, Properties _info, int requestTimeOut) throws ConnectException, IOException {
        this.connection = con;
        this.host = _host;
        this.port = _port;
        if (Boolean.valueOf(_info.getProperty("NAMESENSITIVE")).booleanValue()) {
            this.database = _database;
            this.db_user = user;
        } else {
            this.database = OSCARProtocol.convertString(_database);
            this.db_user = OSCARProtocol.convertString(user);
        }
        this.db_passwd = _info.getProperty("PASSWORD") == null ? "" : _info.getProperty("PASSWORD");
        this.info = _info;
        this.errorRetryTimes = Integer.parseInt(_info.getProperty("ERRORRETRYTIMES", "10"));
        this.oStream = new OSocket(_host, _port, requestTimeOut, _info);
        this.oStream.open();
    }

    public OSCARProtocol(BaseConnection con, String _host, int _port, String _database, String user, String _password, Properties _info, OStream oStream) {
        this.connection = con;
        this.host = _host;
        this.port = _port;
        this.database = _database;
        this.db_user = user;
        this.db_passwd = _password;
        this.info = _info;
        this.errorRetryTimes = Integer.parseInt(_info.getProperty("ERRORRETRYTIMES", "10"));
        this.oStream = oStream;
    }

    public int getProtocolMajorVersion() {
        return 2;
    }

    public int getProtocolMinorVersion() {
        return 0;
    }

    public int getProtocolStatus() {
        return this.status;
    }

    public int getPID() {
        return this.pid;
    }

    public int getCKEY() {
        return this.ckey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(int pid, int ckey) throws IOException, SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", cancelRequest, paras: ").append("\n");
            sb.append(" pid: ").append(pid).append(", ");
            sb.append(" ckey: ").append(ckey);
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        try (Closeable cancelStream = null;){
            cancelStream = new OSocket(this.host, this.port, this.info);
            cancelStream.open();
            CancelRequestPacket crp = new CancelRequestPacket(pid, ckey);
            crp.setConnection(this.connection);
            this.sendMessage(cancelStream.getBufferedOutputStream(), crp);
        }
    }

    public BaseResultSet query(String queryStr, int maxRows, BaseStatement stmt) throws SQLException {
        return this.query(queryStr, maxRows, stmt, (BaseResultSet)stmt.getRealResultSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BaseResultSet query(String queryStr, int maxRows, BaseStatement stmt, BaseResultSet res) throws SQLException {
        print = false;
        if (stmt.isPrint()) {
            print = true;
        }
        if (this.logFlag) {
            sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", query, paras: ");
            sb.append(" sql: ").append(queryStr).append(", ");
            sb.append(" maxRows: ").append(maxRows);
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        if (stmt.getHashColIds() != null && stmt.getHashColIds().length > 0 && queryStr.trim().toUpperCase().startsWith("FETCH ")) {
            return this.queryHashResultSet(queryStr, maxRows, stmt, stmt.getHashColIds(), stmt.getBuckets());
        }
        var6_6 = this;
        synchronized (var6_6) {
            exception = null;
            this.statement = stmt;
            this.status = 0;
            encodingFlag = this.connection.getEncoding() == null;
            this.resultset = res;
            if (this.resultset != null && !this.resultset.isCursorUsed()) {
                this.resultset = null;
            }
            try {
                marked = 0;
                if (this.statement.isDDLSql()) {
                    marked = 3;
                    this.statement.resetDDLSql(false);
                } else if (this.statement.isPrepareAndNotRealPrepare()) {
                    marked = 4;
                } else if (this.statement.getAutoGeneratedInfo() != -1) {
                    marked = 2;
                    if (queryStr != null && !(sql = this.statement.generatedKeySqlTransform(queryStr)).equals(queryStr)) {
                        queryStr = sql;
                        marked = 0;
                    }
                } else if (this.statement.useTid()) {
                    marked = 1;
                }
                qp = null;
                qp = encodingFlag != false ? new QueryPacket(this.connection.getClientEncoding().encode(queryStr), marked) : new QueryPacket(this.connection.getEncoding().encode(queryStr), marked);
                qp.setConnection(this.connection);
                tuples = new ArrayList<byte[][]>();
                resultTid = false;
                tidList = null;
                fields = null;
                update_count = -2L;
                insert_tid = 0L;
                tidField = null;
                columnCount = 0;
                this.sendMessage(this.oStream.getBufferedOutputStream(), qp);
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (!(this.bk instanceof RowDescriptionPacket)) ** GOTO lbl75
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    tempFields = ((RowDescriptionPacket)this.bk).getFields();
                    columnCount = tempFields.length;
                    if (columnCount <= 0) ** GOTO lbl73
                    if ((this.statement.useTid() || this.statement.getAutoGeneratedInfo() != -1) && tempFields[0].getAliasName().equalsIgnoreCase("ROWID")) {
                        resultTid = true;
                        tidField = tempFields[0];
                        tidList = new ArrayList<byte[]>();
                        if (columnCount == 1) continue;
                        fields = new Field[columnCount - 1];
                        for (i = 0; i < columnCount - 1; ++i) {
                            fields[i] = tempFields[i + 1];
                        }
                    } else {
                        fields = tempFields;
                        continue;
lbl73:
                        // 1 sources

                        fields = new Field[]{};
                        continue;
lbl75:
                        // 1 sources

                        if (this.bk instanceof AsciiRowPacket) {
                            if (print) {
                                Driver.writeLog("session" + this.pid + "-------D-------" + stmt.getSQL());
                            }
                            ((AsciiRowPacket)this.bk).initTuple(columnCount);
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            tempTuple = ((AsciiRowPacket)this.bk).getTuple();
                            tuple /* !! */  = null;
                            if (columnCount <= 0 || maxRows != 0 && tuples.size() >= maxRows) continue;
                            if (resultTid && tempTuple.length > 0) {
                                tidList.add(tempTuple[0]);
                                tuple /* !! */  = new byte[tempTuple.length - 1][];
                                for (i = 0; i < tempTuple.length - 1; ++i) {
                                    tuple /* !! */ [i] = tempTuple[i + 1];
                                }
                            } else {
                                tuple /* !! */  = tempTuple;
                            }
                            tuples.add(tuple /* !! */ );
                            continue;
                        }
                        if (this.bk instanceof CompleteResponsePacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            command = null;
                            command = encodingFlag != false ? this.connection.getClientEncoding().decode(((CompleteResponsePacket)this.bk).getCommand()) : this.connection.getEncoding().decode(((CompleteResponsePacket)this.bk).getCommand());
                            if (command.length() < 2) continue;
                            tag1 = command.charAt(0);
                            tag2 = command.charAt(1);
                            if (tag1 == '5' && tag2 == '0') {
                                tag3 = command.charAt(3);
                                if (tag3 == '0') {
                                    this.statement.setResultSetCanUpdateable(false);
                                } else if (tag3 == '1') {
                                    this.statement.setResultSetCanUpdateable(true);
                                }
                            } else if (tag1 == '3') {
                                if (tag2 == '0') {
                                    this.connection.setInTranscation(true);
                                } else if (tag2 == '1' || tag2 == '2' || tag2 == '3') {
                                    this.connection.setInTranscation(false);
                                }
                            } else if (tag1 == '0' && tag2 != '6' && tag2 <= 'S' || tag1 == '1' && (tag2 == '0' || tag2 == '1') || tag1 == '2' && tag2 != '2' || tag1 == '5' && tag2 == '5' || tag1 == '4' && tag2 == '0' || tag1 == '4' && tag2 == '5' || tag1 == '4' && tag2 == '8' || tag1 == '5' && tag2 == '6' || tag1 == '5' && tag2 == 'D') {
                                if (tag1 == '0' && tag2 != '6' && tag2 <= 'S') {
                                    update_count = 0L;
                                }
                                if (tag1 == '4' && tag2 == '0') {
                                    update_count = 0L;
                                }
                                if (tag1 == '2' && (tag2 == '0' || tag2 == '5')) {
                                    update_count = Long.parseLong(command.substring(1 + command.indexOf(32)));
                                }
                                if (tag1 == '2' && tag2 == '1') {
                                    update_count = Long.parseLong(command.substring(command.indexOf(32) + 1, command.lastIndexOf(32)));
                                    insert_tid = Long.parseLong(command.substring(1 + command.lastIndexOf(32)));
                                }
                                if (this.resultset == null) {
                                    this.resultset = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                        this.resultset.setCursorUsed(true);
                                    }
                                    if (this.statement.getResultSetHoldability() == 2) {
                                        this.connection.addCursor(this.resultset.getCursorName());
                                    }
                                } else if (this.resultset.isCursorUsed()) {
                                    moveSize = 0;
                                    moveSize = Integer.parseInt(command.substring(1 + command.indexOf(32)));
                                    if (tag1 == '1' && tag2 == '0') {
                                        this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                        if (resultTid) {
                                            this.resultset.setTidValues(tidField, tidList);
                                        }
                                        this.resultset.setCursorMoveSize(moveSize);
                                    } else if (tag1 == '1' && tag2 == '1') {
                                        this.resultset.setCursorMoveSize(moveSize);
                                    }
                                } else {
                                    rs = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    this.resultset.append(rs);
                                    if (this.statement.getResultSetHoldability() == 2) {
                                        this.connection.addCursor(this.resultset.getCursorName());
                                    }
                                }
                            }
                            if (this.resultset == null) {
                                this.resultset = this.statement.createResultSet(new Field[0], new ArrayList<byte[][]>(), null, 0L, 0L);
                            }
                            tuples = new ArrayList<E>();
                            resultTid = false;
                            tidList = null;
                            fields = null;
                            update_count = -2L;
                            insert_tid = 0L;
                            continue;
                        }
                        if (this.bk instanceof ParamInforPacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            this.statement.setParamInfor(((ParamInforPacket)this.bk).getParamInfo());
                            continue;
                        }
                        if (this.bk instanceof EmptyQueryResponsePacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            continue;
                        }
                        if (this.bk instanceof CursorResponsePacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            continue;
                        }
                        if (this.bk instanceof ErrorResponsePacket) {
                            this.status = -1;
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            errorPacket = (ErrorResponsePacket)this.bk;
                            if (encodingFlag) {
                                if (exception == null) {
                                    exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                    continue;
                                }
                                exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                                continue;
                            }
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (this.bk instanceof NoticeResponsePacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            if (encodingFlag) {
                                this.statement.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                                continue;
                            }
                            this.statement.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        if (this.bk instanceof ImportPacket) {
                            if (encodingFlag) {
                                ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getClientEncoding());
                            } else {
                                ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getEncoding());
                            }
                            ((ImportPacket)this.bk).setImportValues(this.statement.getImportValues());
                            this.sendMessage(this.oStream.getBufferedOutputStream(), this.bk);
                            this.statement.importValues(null);
                            continue;
                        }
                        if (this.bk instanceof ImportExportResponsePacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            this.statement.setTransferRowCount(((ImportExportResponsePacket)this.bk).getAmount());
                            continue;
                        }
                        if (this.bk instanceof ReadyForQueryPacket) {
                            this.status = 1;
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            continue;
                        }
                        if (this.bk instanceof NewImportPacket) {
                            this.status = -1;
                            throw new OSQLException("OSCAR-00436", "88888", 436);
                        }
                        this.status = -1;
                        throw new OSQLException("OSCAR-00109", "08003", 109);
                    }
                } while (!(this.bk instanceof ReadyForQueryPacket));
                if (exception != null) {
                    throw exception;
                }
            }
            catch (SocketTimeoutException e) {
                this.status = -1;
                throw new SQLRecoverableException("IO \u9519\u8bef: " + e.getMessage(), e);
            }
            catch (IOException e) {
                this.status = -1;
                if (this.isSocketConnectionError(e)) {
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            return this.resultset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] functionCall(int funcOID, int paraCount, int[] paraLenth, Object[] paraValue) throws SQLException {
        if (this.logFlag) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", functionCall, paras: ");
            sb.append(" funcOID: ").append(funcOID).append(", ");
            sb.append(" paraCount: ").append(paraCount);
            sb.append(" funcOID: ").append(funcOID);
            if (paraLenth != null) {
                sb.append("paraLenth: ");
                for (i = 0; i < paraLenth.length; ++i) {
                    sb.append(paraLenth[i]).append(" ");
                }
            }
            if (paraLenth != null) {
                sb.append("paraValue: ");
                for (i = 0; i < paraValue.length; ++i) {
                    if (paraValue[i] instanceof byte[]) {
                        sb.append(Arrays.toString((byte[])paraValue[i]));
                        continue;
                    }
                    sb.append(paraValue[i]).append(" ");
                }
            }
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        FunctionCallPacket fcp = new FunctionCallPacket(funcOID, paraCount, paraLenth, paraValue);
        fcp.setConnection(this.connection);
        Object[] result = new Object[3];
        boolean encodingFlag = this.connection.getEncoding() == null;
        OSCARProtocol oSCARProtocol = this;
        synchronized (oSCARProtocol) {
            OSQLException exception = null;
            this.status = 0;
            try {
                this.sendMessage(this.oStream.getBufferedOutputStream(), fcp);
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00108", "88888", 108, e.getMessage(), e);
            }
            try {
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (encodingFlag) {
                            this.connection.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.connection.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    if (this.bk instanceof FunctionResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        result[0] = ((FunctionResponsePacket)this.bk).isNull();
                        result[1] = ((FunctionResponsePacket)this.bk).getResultSize();
                        result[2] = ((FunctionResponsePacket)this.bk).getResult();
                        continue;
                    }
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    this.status = -1;
                    throw new OSQLException("OSCAR-00109", "08003", 109);
                } while (!(this.bk instanceof ReadyForQueryPacket));
            }
            catch (SocketTimeoutException e) {
                this.status = -1;
                throw new OSQLException("OSCAR-00901", "08003", 901, e);
            }
            catch (IOException e) {
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            if (exception != null) {
                throw exception;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchProcess(BatchProcessPacket batchPacket, BaseStatement stmt, long[] updateCounts) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", batchProcess");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OSCARProtocol oSCARProtocol = this;
        synchronized (oSCARProtocol) {
            this.statement = stmt;
            int size = batchPacket.size();
            int position = 0;
            int columnCount = 0;
            Field tidField = null;
            try {
                int j = 0;
                for (j = 0; j < size; ++j) {
                    batchPacket.writeRow();
                    if (!batchPacket.checkBuffer()) continue;
                    batchPacket.sendBatch(this.oStream.getBufferedOutputStream());
                    this.receiveBatchResult(position, updateCounts, columnCount, tidField);
                    batchPacket.reInit();
                    position = j + 1;
                    this.statement.setUpdateBatchSize(position);
                }
                if (position != j) {
                    batchPacket.sendBatch(this.oStream.getBufferedOutputStream());
                    this.receiveBatchResult(position, updateCounts, columnCount, tidField);
                    this.statement.setUpdateBatchSize(j);
                }
            }
            catch (IOException ex) {
                throw new OSQLException("OSCAR-00109", "08003", 109, ex);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void receiveBatchResult(int position, long[] updateCounts, int columnCount, Field tidField) throws IOException, SQLException {
        p = position;
        exception = null;
        encodingFlag = this.connection.getEncoding() == null;
        this.resultset = (BaseResultSet)this.statement.getRealResultSet();
        tuples = new ArrayList<byte[][]>();
        resultTid = false;
        tidList = null;
        fields = null;
        update_count = -2L;
        insert_tid = 0L;
        do {
            this.bk = this.getMessage(this.oStream.getInputStream());
            if (!(this.bk instanceof RowDescriptionPacket)) ** GOTO lbl32
            this.getMessage(this.oStream.getInputStream(), this.bk);
            tempFields = ((RowDescriptionPacket)this.bk).getFields();
            columnCount = tempFields.length;
            if (columnCount <= 0) ** GOTO lbl30
            if ((this.statement.useTid() || this.statement.getAutoGeneratedInfo() != -1) && tempFields[0].getAliasName().equalsIgnoreCase("ROWID")) {
                resultTid = true;
                tidField = tempFields[0];
                tidList = new ArrayList<byte[]>();
                if (columnCount == 1) continue;
                fields = new Field[columnCount - 1];
                for (i = 0; i < columnCount - 1; ++i) {
                    fields[i] = tempFields[i + 1];
                }
            } else {
                fields = tempFields;
                continue;
lbl30:
                // 1 sources

                fields = new Field[]{};
                continue;
lbl32:
                // 1 sources

                if (this.bk instanceof AsciiRowPacket) {
                    ((AsciiRowPacket)this.bk).initTuple(columnCount);
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    tempTuple = ((AsciiRowPacket)this.bk).getTuple();
                    tuple /* !! */  = null;
                    if (columnCount <= 0) continue;
                    if (resultTid && tempTuple.length > 0) {
                        tidList.add(tempTuple[0]);
                        tuple /* !! */  = new byte[tempTuple.length - 1][];
                        for (i = 0; i < tempTuple.length - 1; ++i) {
                            tuple /* !! */ [i] = tempTuple[i + 1];
                        }
                    } else {
                        tuple /* !! */  = tempTuple;
                    }
                    tuples.add(tuple /* !! */ );
                    continue;
                }
                if (this.bk instanceof CompleteResponsePacket) {
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    command = this.connection.getEncoding().decode(((CompleteResponsePacket)this.bk).getCommand());
                    if (command.length() < 2) continue;
                    tag1 = command.charAt(0);
                    tag2 = command.charAt(1);
                    if (tag1 == '5' && tag2 == '0') {
                        tag3 = command.charAt(3);
                        if (tag3 == '0') {
                            this.statement.setResultSetCanUpdateable(false);
                        } else if (tag3 == '1') {
                            this.statement.setResultSetCanUpdateable(true);
                        }
                    } else if (tag1 == '3') {
                        if (tag2 == '0') {
                            this.connection.setInTranscation(true);
                        } else if (tag2 == '1' || tag2 == '2' || tag2 == '3') {
                            this.connection.setInTranscation(false);
                        }
                    } else if (tag1 == '0' && tag2 != '6' && tag2 <= 'S' || tag1 == '1' && (tag2 == '0' || tag2 == '1') || tag1 == '2' && tag2 != '2' || tag1 == '5' && tag2 == '5' || tag1 == '4' && tag2 == '0' || tag1 == '4' && tag2 == '5' || tag1 == '4' && tag2 == '8' || tag1 == '5' && tag2 == '6' || tag1 == '5' && tag2 == 'D') {
                        if (tag1 == '0' && tag2 != '6' && tag2 <= 'S') {
                            update_count = 0L;
                        }
                        if (tag1 == '4' && tag2 == '0') {
                            update_count = 0L;
                        }
                        if (tag1 == '2' && (tag2 == '0' || tag2 == '5')) {
                            update_count = Long.parseLong(command.substring(1 + command.indexOf(32)));
                        }
                        if (tag1 == '2' && tag2 == '1') {
                            update_count = Long.parseLong(command.substring(command.indexOf(32) + 1, command.lastIndexOf(32)));
                            insert_tid = Long.parseLong(command.substring(1 + command.lastIndexOf(32)));
                        }
                        if (this.resultset == null) {
                            this.resultset = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                            updateCounts[p++] = update_count;
                            if (resultTid) {
                                this.resultset.setTidValues(tidField, tidList);
                            }
                            if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                this.resultset.setCursorUsed(true);
                            }
                            if (this.statement.getResultSetHoldability() == 2) {
                                this.connection.addCursor(this.resultset.getCursorName());
                            }
                            this.statement.setResultSet(this.resultset);
                        } else if (this.resultset.isCursorUsed()) {
                            moveSize = 0;
                            commands = command.split(" ");
                            moveSize = Integer.parseInt(commands[1]);
                            if (tag1 == '1' && tag2 == '0') {
                                this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                if (resultTid) {
                                    this.resultset.setTidValues(tidField, tidList);
                                }
                                this.resultset.setCursorMoveSize(moveSize);
                            } else if (tag1 == '1' && tag2 == '1') {
                                this.resultset.setCursorMoveSize(moveSize);
                            }
                        } else {
                            updateCounts[p++] = update_count;
                        }
                    }
                    tuples = new ArrayList<E>();
                    resultTid = false;
                    tidList = null;
                    fields = null;
                    update_count = -2L;
                    insert_tid = 0L;
                    continue;
                }
                if (this.bk instanceof ParamInforPacket) {
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    this.statement.setParamInfor(((ParamInforPacket)this.bk).getParamInfo());
                    continue;
                }
                if (this.bk instanceof EmptyQueryResponsePacket) {
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    continue;
                }
                if (this.bk instanceof CursorResponsePacket) {
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    command = this.connection.getEncoding().decode(((CursorResponsePacket)this.bk).getCursorName());
                    continue;
                }
                if (this.bk instanceof ErrorResponsePacket) {
                    this.status = -1;
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    errorPacket = (ErrorResponsePacket)this.bk;
                    if (encodingFlag) {
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (exception == null) {
                        exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                        continue;
                    }
                    exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                    continue;
                }
                if (this.bk instanceof NoticeResponsePacket) {
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    this.statement.addWarning(new String(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                    continue;
                }
                if (this.bk instanceof ImportPacket) {
                    ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getEncoding());
                    ((ImportPacket)this.bk).setImportValues(this.statement.getImportValues());
                    this.sendMessage(this.oStream.getBufferedOutputStream(), this.bk);
                    this.statement.importValues(null);
                    continue;
                }
                if (this.bk instanceof ImportExportResponsePacket) {
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    this.statement.setTransferRowCount(((ImportExportResponsePacket)this.bk).getAmount());
                    continue;
                }
                if (this.bk instanceof ReadyForQueryPacket) {
                    this.status = 1;
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    continue;
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109);
            }
        } while (!(this.bk instanceof ReadyForQueryPacket));
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, SQLException {
        TerminatePacket tp = new TerminatePacket();
        tp.setConnection(this.connection);
        if (this.oStream != null) {
            OSCARProtocol oSCARProtocol = this;
            synchronized (oSCARProtocol) {
                try {
                    this.sendMessage(this.oStream.getBufferedOutputStream(), tp);
                    int flag = 1;
                    this.oStream.setSocketTimeOut(1000);
                    while (flag != -1) {
                        try {
                            flag = this.oStream.getInputStream().read();
                        }
                        catch (Exception e) {
                            // empty catch block
                            break;
                        }
                    }
                }
                catch (IOException ioex) {
                    throw ioex;
                }
                catch (SQLException sqlEx) {
                    throw sqlEx;
                }
                finally {
                    this.oStream.close();
                }
            }
        }
        tp = null;
        this.oStream = null;
        this.connection = null;
        this.host = "ErrorIP";
        this.database = null;
        this.db_user = null;
        this.db_passwd = null;
        this.statement = null;
        this.resultset = null;
        this.bk = null;
        this.pk = new Packet();
    }

    protected void sendMessage(BufferedOutputStream stream, BasePacket packet) throws IOException, SQLException {
        packet.sendTo(stream);
    }

    protected BasePacket getMessage(InputStream stream) throws IOException {
        byte[] tagTemp = new byte[1];
        stream.read(tagTemp, 0, 1);
        char tag = (char)tagTemp[0];
        if (this.logFlag) {
            if ('\uffa1' == tag) {
                Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), OSCARProtocol.class + ", getMessage(InputStream stream)), return tag: 0xA1");
            } else {
                Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), OSCARProtocol.class + ", getMessage(InputStream stream)), return tag: " + tag);
            }
        }
        return this.pk.getInstance(tag, this.connection);
    }

    protected void getMessage(InputStream stream, BasePacket packet) throws IOException, SQLException {
        packet.receiveFrom(stream);
    }

    protected byte[] getMessage(InputStream stream, int len) throws IOException, SQLException {
        byte[] tagTemp = new byte[len];
        stream.read(tagTemp, 0, len);
        return tagTemp;
    }

    public static String convertString(String commonString) {
        if (commonString.length() > 0 && commonString.charAt(0) == '\"' && commonString.charAt(commonString.length() - 1) == '\"') {
            return commonString.substring(1, commonString.length() - 1);
        }
        return commonString.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBegin(QueryPacket qp) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", importBegin(QueryPacket qp)");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OStream oStream = this.oStream;
        synchronized (oStream) {
            try {
                this.sendMessage(this.oStream.getBufferedOutputStream(), qp);
                BasePacket readyBk = null;
                boolean encodingFlag = this.connection.getEncoding() == null;
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof NewImportPacket || this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        readyBk = this.getMessage(this.oStream.getInputStream());
                        while (!(readyBk instanceof ReadyForQueryPacket) && !(this.bk instanceof NewImportPacket)) {
                            readyBk = this.getMessage(this.oStream.getInputStream());
                        }
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            throw new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                        }
                        throw new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                    }
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (encodingFlag) {
                            this.connection.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.connection.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    this.status = -1;
                    throw new OSQLException("OSCAR-00109", "08003", 109);
                } while (!(this.bk instanceof ReadyForQueryPacket) && !(this.bk instanceof NewImportPacket));
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00804", "88888", 804, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(byte[] b) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", importData(byte[] b), data:");
            sb.append("[");
            for (byte c : b) {
                sb.append(c).append(" ");
            }
            sb.append("]");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OStream oStream = this.oStream;
        synchronized (oStream) {
            try {
                if (b.length != 0) {
                    this.oStream.getBufferedOutputStream().write(b);
                }
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00804", "88888", 804, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(byte[] b, int off, int len) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", importData(byte[] b, int off, int len) off= " + off + " len= " + len).append(", data:");
            sb.append("[");
            for (byte c : b) {
                sb.append(c).append(" ");
            }
            sb.append("]");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OStream oStream = this.oStream;
        synchronized (oStream) {
            try {
                if (b.length != 0) {
                    this.oStream.getBufferedOutputStream().write(b, off, len);
                }
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00804", "88888", 804, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importEnd() throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", importEnd()");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OStream oStream = this.oStream;
        synchronized (oStream) {
            try {
                BasePacket.SendChar(this.oStream.getBufferedOutputStream(), 67);
                this.oStream.getBufferedOutputStream().flush();
                OSQLException exception = null;
                boolean encodingFlag = this.connection.getEncoding() == null;
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (encodingFlag) {
                            this.connection.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.connection.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        this.cmd = ((CompleteResponsePacket)this.bk).getCommand();
                        this.update_count = Long.parseLong(this.connection.getEncoding().decode(this.cmd, 3, this.cmd.length - 3));
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    this.status = -1;
                    throw new OSQLException("OSCAR-00109", "08003", 109);
                } while (!(this.bk instanceof ReadyForQueryPacket));
                this.handler.setUpdateCount(this.update_count);
                this.handler.setCurrentUpdateCount(this.update_count);
                if (exception != null) {
                    throw exception;
                }
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00804", "88888", 804, e.getMessage(), e);
            }
        }
    }

    public void setImportHandler(OscarImportHandler handler) {
        this.handler = handler;
    }

    public void setImportBlogHandler(ImportBinlogHandler handler) {
        this.importBinlogHandler = handler;
    }

    public void setExportBlogHandler(ExportBinlogHandler handler) {
        this.exportBinlogHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(OStream ostream) {
        boolean flag = true;
        Socket socket = null;
        try {
            socket = ostream.getSocket();
            socket.setOOBInline(false);
            socket.sendUrgentData(255);
        }
        catch (Throwable e) {
            flag = false;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] backUpKstore(String queryStr) throws SQLException {
        QueryPacket qp = new QueryPacket(this.connection.getEncoding().encode(queryStr), 0);
        qp.setConnection(this.connection);
        byte[] result = null;
        boolean encodingFlag = this.connection.getEncoding() == null;
        OStream oStream = this.oStream;
        synchronized (oStream) {
            OSQLException exception = null;
            this.status = 0;
            try {
                this.sendMessage(this.oStream.getBufferedOutputStream(), qp);
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00108", "88888", 108, e.getMessage(), e);
            }
            try {
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof BackupMetaDataPacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        result = ((BackupMetaDataPacket)this.bk).getMetaData();
                        break;
                    }
                    if (this.bk instanceof BackupPhysicalDataPacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof BackupPhysicalRowEndPacket) continue;
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    this.status = -1;
                    throw new OSQLException("OSCAR-00109", "08003", 109);
                } while (!(this.bk instanceof ReadyForQueryPacket));
            }
            catch (SocketTimeoutException e) {
                this.status = -1;
                throw new OSQLException("OSCAR-00901", "08003", 901, e);
            }
            catch (IOException e) {
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            if (exception != null) {
                throw exception;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNextPhysicalDataRow() throws SQLException {
        boolean encodingFlag;
        byte[] result = null;
        boolean bl = encodingFlag = this.connection.getEncoding() == null;
        if (this.oStream != null) {
            OStream oStream = this.oStream;
            synchronized (oStream) {
                OSQLException exception = null;
                try {
                    do {
                        this.bk = this.getMessage(this.oStream.getInputStream());
                        if (this.bk instanceof ErrorResponsePacket) {
                            this.status = -1;
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                            if (encodingFlag) {
                                if (exception == null) {
                                    exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                    continue;
                                }
                                exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                                continue;
                            }
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (this.bk instanceof CompleteResponsePacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            continue;
                        }
                        if (this.bk instanceof BackupMetaDataPacket) continue;
                        if (this.bk instanceof BackupPhysicalDataPacket) {
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            result = ((BackupPhysicalDataPacket)this.bk).getPhysicalData();
                            continue;
                        }
                        if (this.bk instanceof BackupPhysicalRowEndPacket) continue;
                        if (this.bk instanceof ReadyForQueryPacket) {
                            this.status = 1;
                            this.getMessage(this.oStream.getInputStream(), this.bk);
                            break;
                        }
                        this.status = -1;
                        throw new OSQLException("OSCAR-00109", "08003", 109);
                    } while (!(this.bk instanceof BackupPhysicalDataPacket));
                }
                catch (SocketTimeoutException e) {
                    this.status = -1;
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                catch (IOException e) {
                    this.status = -1;
                    throw new OSQLException("OSCAR-00109", "08003", 109, e);
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreKstore(String queryStr, byte[] metaData, byte[] physicalRowData) throws SQLException {
        OStream oStream = this.oStream;
        synchronized (oStream) {
            QueryPacket qp = new QueryPacket(this.connection.getEncoding().encode(queryStr), 0);
            qp.setConnection(this.connection);
            OSQLException exception = null;
            boolean encodingFlag = this.connection.getEncoding() == null;
            this.status = 0;
            try {
                this.sendMessage(this.oStream.getBufferedOutputStream(), qp);
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00108", "88888", 108, e.getMessage());
            }
            try {
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof ReadyForMetaData) {
                        BackupMetaDataPacket metaDataPacket = new BackupMetaDataPacket(metaData);
                        metaDataPacket.setConnection(this.connection);
                        metaDataPacket.sendTo(this.oStream.getBufferedOutputStream());
                        continue;
                    }
                    if (this.bk instanceof ReadyForPhysicalDataPacket) {
                        BackupPhysicalDataPacket physicalDataPacket = new BackupPhysicalDataPacket(physicalRowData);
                        physicalDataPacket.setConnection(this.connection);
                        physicalDataPacket.sendTo(this.oStream.getBufferedOutputStream());
                        this.oStream.getBufferedOutputStream().flush();
                        BasePacket.SendChar(this.oStream.getBufferedOutputStream(), 111);
                        this.oStream.getBufferedOutputStream().flush();
                        continue;
                    }
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    this.status = -1;
                    throw new OSQLException("OSCAR-00109", "08003", 109);
                } while (!(this.bk instanceof ReadyForQueryPacket));
            }
            catch (SocketTimeoutException e) {
                this.status = -1;
                throw new OSQLException("OSCAR-00901", "08003", 901, e);
            }
            catch (IOException e) {
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public void setCkey(int ckey) {
        this.ckey = ckey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseResultSet queryHashResultSet(String queryStr, int maxRows, BaseStatement stmt, int[] bindIDs, int buckets) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocol.class).append(", query, paras: ");
            sb.append(" sql: ").append(queryStr).append(", ");
            sb.append(" maxRows: ").append(maxRows);
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OStream oStream = this.oStream;
        synchronized (oStream) {
            OSQLException exception = null;
            this.statement = stmt;
            this.status = 0;
            boolean encodingFlag = this.connection.getEncoding() == null;
            this.resultset = (BaseResultSet)stmt.getRealResultSet();
            if (this.resultset != null && !this.resultset.isCursorUsed()) {
                this.resultset = null;
            }
            try {
                int marked = -1;
                QueryPacketHash qp = null;
                qp = encodingFlag ? new QueryPacketHash(this.connection.getClientEncoding().encode(queryStr), marked, bindIDs, buckets) : new QueryPacketHash(this.connection.getEncoding().encode(queryStr), marked, bindIDs, buckets);
                qp.setConnection(this.connection);
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                boolean resultTid = false;
                ArrayList<byte[]> tidList = null;
                Field[] fields = null;
                long update_count = -2L;
                long insert_tid = 0L;
                Field tidField = null;
                int columnCount = 0;
                this.sendMessage(this.oStream.getBufferedOutputStream(), qp);
                do {
                    block49: {
                        block51: {
                            String command;
                            block54: {
                                char tag2;
                                char tag1;
                                block53: {
                                    block52: {
                                        block50: {
                                            this.bk = this.getMessage(this.oStream.getInputStream());
                                            if (this.bk instanceof RowDescriptionPacket) {
                                                this.getMessage(this.oStream.getInputStream(), this.bk);
                                                Field[] tempFields = ((RowDescriptionPacket)this.bk).getFields();
                                                columnCount = tempFields.length;
                                                if (columnCount > 0) {
                                                    if ((this.statement.useTid() || this.statement.getAutoGeneratedInfo() != -1) && tempFields[0].getAliasName().equalsIgnoreCase("ROWID")) {
                                                        resultTid = true;
                                                        tidField = tempFields[0];
                                                        tidList = new ArrayList<byte[]>();
                                                        if (columnCount == 1) continue;
                                                        fields = new Field[columnCount - 1];
                                                        for (int i = 0; i < columnCount - 1; ++i) {
                                                            fields[i] = tempFields[i + 1];
                                                        }
                                                        continue;
                                                    } else {
                                                        fields = tempFields;
                                                        continue;
                                                    }
                                                }
                                                fields = new Field[]{};
                                                continue;
                                            }
                                            if (!(this.bk instanceof CompleteResponsePacket)) break block49;
                                            this.getMessage(this.oStream.getInputStream(), this.bk);
                                            command = null;
                                            command = encodingFlag ? this.connection.getClientEncoding().decode(((CompleteResponsePacket)this.bk).getCommand()) : this.connection.getEncoding().decode(((CompleteResponsePacket)this.bk).getCommand());
                                            if (command.length() < 2) continue;
                                            tag1 = command.charAt(0);
                                            tag2 = command.charAt(1);
                                            if (tag1 != '5' || tag2 != '0') break block50;
                                            char tag3 = command.charAt(3);
                                            if (tag3 == '0') {
                                                this.statement.setResultSetCanUpdateable(false);
                                                break block51;
                                            } else if (tag3 == '1') {
                                                this.statement.setResultSetCanUpdateable(true);
                                            }
                                            break block51;
                                        }
                                        if (tag1 != '3') break block52;
                                        if (tag2 == '0') {
                                            this.connection.setInTranscation(true);
                                            break block51;
                                        } else if (tag2 == '1' || tag2 == '2' || tag2 == '3') {
                                            this.connection.setInTranscation(false);
                                        }
                                        break block51;
                                    }
                                    if (!(tag1 == '0' && tag2 != '6' && tag2 <= 'S' || tag1 == '1' && (tag2 == '0' || tag2 == '1') || tag1 == '2' && tag2 != '2' || tag1 == '5' && tag2 == '5' || tag1 == '4' && tag2 == '0' || tag1 == '4' && tag2 == '5' || tag1 == '4' && tag2 == '8' || tag1 == '5' && tag2 == '6') && (tag1 != '5' || tag2 != 'D')) break block51;
                                    if (tag1 == '0' && tag2 != '6' && tag2 <= 'S') {
                                        update_count = 0L;
                                    }
                                    if (tag1 == '4' && tag2 == '0') {
                                        update_count = 0L;
                                    }
                                    if (tag1 == '2' && (tag2 == '0' || tag2 == '5')) {
                                        update_count = Long.parseLong(command.substring(1 + command.indexOf(32)));
                                    }
                                    if (tag1 == '2' && tag2 == '1') {
                                        update_count = Long.parseLong(command.substring(command.indexOf(32) + 1, command.lastIndexOf(32)));
                                        insert_tid = Long.parseLong(command.substring(1 + command.lastIndexOf(32)));
                                    }
                                    if (this.resultset != null) break block53;
                                    this.resultset = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid, 1);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                        this.resultset.setCursorUsed(true);
                                    }
                                    if (this.statement.getResultSetHoldability() == 2) {
                                        this.connection.addCursor(this.resultset.getCursorName());
                                    }
                                    break block51;
                                }
                                if (!this.resultset.isCursorUsed()) break block54;
                                int moveSize = 0;
                                moveSize = Integer.parseInt(command.substring(1 + command.indexOf(32)));
                                fields = new Field[3];
                                if (tag1 == '1' && tag2 == '0') {
                                    this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    this.resultset.setCursorMoveSize(moveSize);
                                    break block51;
                                } else if (tag1 == '1' && tag2 == '1') {
                                    this.resultset.setCursorMoveSize(moveSize);
                                }
                                break block51;
                            }
                            BaseResultSet rs = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid, 1);
                            if (resultTid) {
                                this.resultset.setTidValues(tidField, tidList);
                            }
                            this.resultset.append(rs);
                            if (this.statement.getResultSetHoldability() == 2) {
                                this.connection.addCursor(this.resultset.getCursorName());
                            }
                        }
                        tuples = new ArrayList();
                        resultTid = false;
                        tidList = null;
                        fields = null;
                        update_count = -2L;
                        insert_tid = 0L;
                        continue;
                    }
                    if (this.bk instanceof HashDataPacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        HashDataPacket hashDataPacket = (HashDataPacket)this.bk;
                        byte[][] tuple = new byte[][]{hashDataPacket.getHashkey(), hashDataPacket.getDataSize(), hashDataPacket.getData()};
                        tuples.add(tuple);
                        continue;
                    }
                    if (this.bk instanceof ParamInforPacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        this.statement.setParamInfor(((ParamInforPacket)this.bk).getParamInfo());
                        continue;
                    }
                    if (this.bk instanceof EmptyQueryResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof CursorResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (encodingFlag) {
                            this.statement.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.statement.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    if (this.bk instanceof ImportPacket) {
                        if (encodingFlag) {
                            ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getClientEncoding());
                        } else {
                            ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getEncoding());
                        }
                        ((ImportPacket)this.bk).setImportValues(this.statement.getImportValues());
                        this.sendMessage(this.oStream.getBufferedOutputStream(), this.bk);
                        this.statement.importValues(null);
                        continue;
                    }
                    if (this.bk instanceof ImportExportResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        this.statement.setTransferRowCount(((ImportExportResponsePacket)this.bk).getAmount());
                        continue;
                    }
                    if (!(this.bk instanceof ReadyForQueryPacket)) {
                        this.status = -1;
                        throw new OSQLException("OSCAR-00109", "08003", 109);
                    }
                    this.status = 1;
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                } while (!(this.bk instanceof ReadyForQueryPacket));
                if (exception != null) {
                    throw exception;
                }
            }
            catch (SocketTimeoutException e) {
                this.status = -1;
                throw new OSQLException("OSCAR-00901", "08003", 901, e);
            }
            catch (IOException e) {
                this.status = -1;
                if (this.isSocketConnectionError(e)) {
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            return this.resultset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBlogBegin(QueryPacket qp) throws SQLException {
        OStream oStream = this.oStream;
        synchronized (oStream) {
            try {
                OSQLException exception = null;
                this.sendMessage(this.oStream.getBufferedOutputStream(), qp);
                boolean encodingFlag = this.connection.getEncoding() == null;
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk == null) {
                        throw new OSQLException("The received information is abnormal, the network may be disconnected", "08003");
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof NewImportPacket || this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (!(this.bk instanceof ErrorResponsePacket)) continue;
                    this.status = -1;
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                    ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                    exception = encodingFlag ? new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())) : new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                } while (!(this.bk instanceof ReadyForQueryPacket) && !(this.bk instanceof NewImportPacket));
                if (exception != null) {
                    throw exception;
                }
            }
            catch (IOException e) {
                if (this.isSocketConnectionError(e)) {
                    this.status = -1;
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                throw new OSQLException("OSCAR-00120", "88888", 120, e);
            }
        }
    }

    public int importBinlogData(byte[] b, int pos, int len) throws SQLException {
        OStream oStream = this.oStream;
        synchronized (oStream) {
            int retVal = -1;
            try {
                BlogDataPacket bp = new BlogDataPacket(b, pos, len);
                this.sendMessage(this.oStream.getBufferedOutputStream(), bp);
                int n = retVal;
                return n;
            }
            catch (IOException e) {
                if (this.isSocketConnectionError(e)) {
                    this.status = -1;
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                throw new OSQLException("OSCAR-00120", "88888", 120, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBinlogEnd() throws SQLException {
        OStream oStream = this.oStream;
        synchronized (oStream) {
            try {
                BasePacket.SendChar(this.oStream.getBufferedOutputStream(), 67);
                this.oStream.getBufferedOutputStream().flush();
                OSQLException exception = null;
                boolean encodingFlag = this.connection.getEncoding() == null;
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk == null) {
                        throw new OSQLException("The received information is abnormal, the network may be disconnected", "08003");
                    }
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (encodingFlag) {
                            this.connection.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.connection.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        this.cmd = ((CompleteResponsePacket)this.bk).getCommand();
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof BLogErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        BLogErrorResponsePacket errorPacket = (BLogErrorResponsePacket)this.bk;
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (!(this.bk instanceof ReadyForQueryPacket)) continue;
                    this.status = 1;
                    this.getMessage(this.oStream.getInputStream(), this.bk);
                } while (!(this.bk instanceof ReadyForQueryPacket));
                if (exception != null) {
                    throw exception;
                }
            }
            catch (IOException e) {
                if (this.isSocketConnectionError(e)) {
                    this.status = -1;
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                throw new OSQLException("OSCAR-00120", "88888", 120, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlogResultSet queryBlogData(QueryPacket qp) throws SQLException {
        OStream oStream = this.oStream;
        synchronized (oStream) {
            BlogResultSet resultSet = null;
            OSQLException exception = null;
            boolean encodingFlag = this.connection.getEncoding() == null;
            try {
                this.sendMessage(this.oStream.getBufferedOutputStream(), qp);
                do {
                    this.bk = this.getMessage(this.oStream.getInputStream());
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    if (this.bk instanceof BlogDataPacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (resultSet == null) {
                            resultSet = new BlogResultSet(this.exportBinlogHandler.getExportFile());
                            System.out.print("export file\uff1a" + this.exportBinlogHandler.getExportFile());
                        }
                        resultSet.setCurData(((BlogDataPacket)this.bk).getTuple());
                        continue;
                    }
                    if (this.bk instanceof BinlogErrorPacket) {
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (resultSet == null) {
                            resultSet = new BlogResultSet(this.exportBinlogHandler.getExportFile());
                        }
                        System.out.println("e\u9519\u8bef\u8bbe\u7f6e\u4e00\u4e2a\u4f4d\u7f6e\uff1a" + ((BinlogErrorPacket)this.bk).getErrorMessage() + ":::" + ((BinlogErrorPacket)this.bk).getCurpos());
                        resultSet.setCurPos(((BinlogErrorPacket)this.bk).getCurpos());
                        resultSet.setOutputFileSeek((long)((BinlogErrorPacket)this.bk).getCurpos() - this.exportBinlogHandler.getStartPos());
                        resultSet.setCurFile(((BinlogErrorPacket)this.bk).getErrorMessage());
                        continue;
                    }
                    if (this.bk instanceof ExportBinlogSuccessPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        if (resultSet == null) {
                            resultSet = new BlogResultSet(this.exportBinlogHandler.getExportFile());
                        }
                        resultSet.setCurFile(((ExportBinlogSuccessPacket)this.bk).getCurfile());
                        resultSet.setCurPos(((ExportBinlogSuccessPacket)this.bk).getCurpos());
                        resultSet.setIsExportEnd(((ExportBinlogSuccessPacket)this.bk).getFlag() != 0);
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.oStream.getInputStream(), this.bk);
                        continue;
                    }
                    this.status = -1;
                    OSQLException e = new OSQLException("OSCAR-00109", "08003", 109);
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                    }
                    throw e;
                } while (!(this.bk instanceof ReadyForQueryPacket));
                if (exception != null) {
                    throw exception;
                }
            }
            catch (IOException e) {
                if (this.isSocketConnectionError(e)) {
                    this.status = -1;
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                throw new OSQLException("OSCAR-00906", "88888", 906, e);
            }
            if (resultSet != null) {
                resultSet.close();
            }
            return resultSet;
        }
    }

    protected boolean isSocketConnectionError(Throwable e) {
        if (e instanceof ThreadDeath) {
            return true;
        }
        SocketException se = null;
        if (e instanceof SocketException) {
            se = (SocketException)e;
        } else if (e.getCause() instanceof SocketException) {
            se = (SocketException)e.getCause();
        }
        if (se != null) {
            if (se.getMessage().startsWith("Software caused connection abort: ")) {
                return true;
            }
            if (se.getMessage().startsWith("Connection reset")) {
                return true;
            }
            if (e.getMessage().contains("Broken pipe") || e.getMessage().contains("\u65ad\u5f00\u7684\u7ba1\u9053")) {
                return true;
            }
        } else if (e.getMessage() != null && e.getMessage().contains("system closing")) {
            return true;
        }
        return false;
    }

    protected boolean needRetry(int getMessageTimes) {
        return getMessageTimes <= this.errorRetryTimes || this.errorRetryTimes < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLsn(SetQueryLsnPacket sqlp, BaseConnection conn) throws SQLException {
        OStream oStream = this.oStream;
        synchronized (oStream) {
            try {
                sqlp.setConnection(conn);
                this.sendMessage(this.oStream.getBufferedOutputStream(), sqlp);
            }
            catch (IOException e) {
                throw new OSQLException("OSCAR-00906", "88888", 109, e);
            }
        }
    }
}

