/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.protocol.OSCARProtocolV2;
import com.oscar.sql.Time;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.converter.BooleanConverter;
import com.oscar.util.converter.DateConverter;
import com.oscar.util.converter.IntervalConverter;
import com.oscar.util.converter.NumberConverter;
import com.oscar.util.converter.RowidConverter;
import com.oscar.util.converter.TimestampConverter;
import com.oscar.util.converter.TimestamptzConverter;
import com.oscar.util.converter.TimetzConverter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class OscarResultSetV2
extends OscarResultSet {
    private boolean netDataByStr = false;
    private boolean numericKeepPrecision = true;

    public OscarResultSetV2(BaseStatement statement, BaseConnection connection, boolean netDataByStr, boolean numericKeepPrecision, int resultSetType, int resultSetConcurrency, boolean canUpdateable, int fetchDirection, Encoding encoding, String curSorName, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) {
        super(statement, connection, resultSetType, resultSetConcurrency, canUpdateable, fetchDirection, curSorName, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows);
        this.netDataByStr = netDataByStr;
        this.numericKeepPrecision = numericKeepPrecision;
        this.encoding = encoding;
    }

    public OscarResultSetV2(BaseStatement statement, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) throws SQLException {
        super(statement, statement.getDBConnection(), statement.getResultSetType(), statement.getResultSetConcurrency(), statement.getResultSetCanUpdateable(), statement.getFetchDirection(), statement.getCursorName(), fields, tuples, status, updateCount, insertOID, statement.getFetchSize(), maxRows);
        this.netDataByStr = this.connection.isNetDataByStr();
        this.numericKeepPrecision = this.connection.isNumericKeepPrecision();
    }

    @Override
    public void close() throws SQLException {
        if (this.type != 1003 || this.concurrency != 1007) {
            super.close();
            return;
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.cursorUsed && this.connection != null && !((Connection)((Object)this.connection)).isClosed()) {
                int index = this.connection.checkPlanID(this.planID);
                if (index > -1) {
                    ((OSCARProtocolV2)this.connection.getProtocol()).fetchMore(null, null, null, null, this.planID, this.fetchSize, this.maxRows, true, false, this.statement, false);
                    this.connection.removePlanID(index);
                }
                try {
                    if (this.connection.hasCursor(this.cursorName)) {
                        String sql = "CLOSE " + this.cursorName + ";DEALLOCATE " + this.cursorName;
                        this.connection.execSQL(sql, this.statement);
                        this.connection.removeCursor(this.cursorName);
                    }
                }
                catch (Exception e) {
                    Driver.writeLog(e);
                }
            }
            this.rows = null;
            this.encoding = null;
            this.fields = null;
            this.status = null;
            this.this_row = null;
            this.tidList = null;
            this.tidField = null;
            this.warnings = null;
            this.next = null;
            this.sbuf = null;
            this.rowBuffer = null;
            this.updateValues = null;
            this.connection = null;
            this.cursorName = null;
            this.closed = true;
            this.deleteStatement = null;
            this.columnNameIndexMap = null;
        }
        finally {
            if (this.statement != null) {
                this.statement.checkAndPerformCloseOnCompletionAction();
            }
            this.statement = null;
        }
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.isOldProtocolResult || this.type != 1003 || this.concurrency != 1007) {
            return super.next();
        }
        this.checkClosed();
        if (this.maxRows > 0 && this.maxRowsCopy <= 0) {
            this.cursorPosition = 1;
            return false;
        }
        this.updateValues.clear();
        if (!this.cursorUsed && this.current_row == this.rows.size()) {
            this.this_row = null;
            return false;
        }
        if (this.cursorPosition == 1 && this.current_row == this.rows.size()) {
            this.this_row = null;
            return false;
        }
        if (++this.current_row >= this.rows.size()) {
            if (!this.cursorUsed) {
                this.this_row = null;
                return false;
            }
            if (this.cursorPosition == 1) {
                this.this_row = null;
                return false;
            }
            int nextMaxRows = 0;
            if (this.maxRows > 0) {
                nextMaxRows = this.maxRowsCopy;
            }
            if (this.planID != null) {
                ((OSCARProtocolV2)this.connection.getProtocol()).fetchMore(null, null, null, null, this.planID, this.fetchSize, nextMaxRows, false, false, this.statement, this, false, 0);
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            } else {
                this.cursorPosition = 1;
            }
            this.current_row = 0;
            if (this.rows.size() == 0) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        }
        if (this.maxRows > 0) {
            --this.maxRowsCopy;
        }
        this.this_row = (byte[][])this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getString(columnIndex);
        }
        return this.getStringValue(this.this_row[columnIndex - 1], this.getOscarType(columnIndex));
    }

    @Override
    protected String getFixedString(int columnIndex) throws SQLException {
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getFixedString(columnIndex);
        }
        return this.getStringValue(this.this_row[columnIndex - 1], this.getOscarType(columnIndex));
    }

    private String getStringValue(byte[] value, int oscarType) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length == 2 && value[0] == -3) {
            if (value[1] == 1) {
                return "NaN";
            }
            if (value[1] == 2) {
                return "infinity";
            }
            if (value[1] == 3) {
                return "-infinity";
            }
        }
        switch (oscarType) {
            case 35: {
                return this.encoding.decode(value);
            }
            case 51: {
                OscarClob clob = this.connection.getClobInstance(this.connection.getEncoding().decode(value));
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new OSQLException("OSCAR-00316", "22000", 316);
                }
                return clob.getSubString(1L, (int)length);
            }
            case 33: {
                return String.valueOf(BooleanConverter.convertToBoolean(value));
            }
            case 25: {
                return DateConverter.convertBytesToDateString(value);
            }
            case 34: {
                if (this.numericKeepPrecision) {
                    return this.encoding.decode(value);
                }
                String retVal = String.valueOf(NumberConverter.convertBytesToDouble(value));
                if (retVal.endsWith(".0") && retVal.length() > 2) {
                    return retVal.substring(0, retVal.length() - 2);
                }
                return retVal;
            }
            case 31: {
                return IntervalConverter.convertToIntervalDTS(value);
            }
            case 30: {
                return IntervalConverter.convertToIntervalYTM(value);
            }
            case 23: {
                return String.valueOf(NumberConverter.convertBytesToLong(value));
            }
            case 32: {
                return String.valueOf(RowidConverter.convertToRowID(value));
            }
            case 26: {
                return TimetzConverter.convertBytesToTimeString(value);
            }
            case 28: {
                return TimestampConverter.convertBytesToTimeStamp(value).stringValue();
            }
            case 29: {
                return TimestamptzConverter.convertBytesToTimeStamp(value).stringValue();
            }
            case 27: {
                return TimetzConverter.convertBytesToTimeZoneString(value);
            }
            case 24: 
            case 2003: {
                return this.encoding.decode(value);
            }
        }
        return this.encoding.decode(value);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return 0;
        }
        if (this.netDataByStr) {
            return super.getInt(columnIndex);
        }
        switch (this.getOscarType(columnIndex)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    String dbType = this.fields[columnIndex - 1].getDBType();
                    String value = this.encoding.decode(this.this_row[columnIndex - 1]);
                    if (dbType.equalsIgnoreCase("float") || dbType.startsWith("double")) {
                        double doubleValue = Double.parseDouble(value);
                        if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                            throw new OSQLException("OSCAR-00719", "88888", 719);
                        }
                        return (int)doubleValue;
                    }
                    if (dbType.equalsIgnoreCase("decimal") || dbType.equalsIgnoreCase("numeric")) {
                        BigDecimal d = new BigDecimal(value);
                        if (d.compareTo(BIG_DECIMAL_MIN_INTEGER_VALUE) < 0 || d.compareTo(BIG_DECIMAL_MAX_INTEGER_VALUE) > 0) {
                            throw new OSQLException("OSCAR-00719", "88888", 719);
                        }
                        return d.intValue();
                    }
                    return Integer.parseInt(value);
                }
                return (int)NumberConverter.convertBytesToDouble(this.this_row[columnIndex - 1]);
            }
            case 23: {
                return (int)NumberConverter.convertBytesToLong(this.this_row[columnIndex - 1]);
            }
        }
        return super.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return 0L;
        }
        if (this.netDataByStr) {
            return super.getLong(columnIndex);
        }
        switch (this.getOscarType(columnIndex)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    String dbType = this.fields[columnIndex - 1].getDBType();
                    String value = this.encoding.decode(this.this_row[columnIndex - 1]);
                    if (dbType.equalsIgnoreCase("decimal") || dbType.equalsIgnoreCase("numeric") || dbType.startsWith("double")) {
                        BigDecimal d = new BigDecimal(value);
                        if (d.compareTo(BIG_DECIMAL_MIN_LONG_VALUE) < 0 || d.compareTo(BIG_DECIMAL_MAX_LONG_VALUE) > 0) {
                            throw new OSQLException("OSCAR-00718", "88888", 718);
                        }
                        return d.longValue();
                    }
                    if (dbType.equalsIgnoreCase("float")) {
                        return (long)Double.parseDouble(value);
                    }
                    return Long.parseLong(value);
                }
                return (long)NumberConverter.convertBytesToDouble(this.this_row[columnIndex - 1]);
            }
            case 23: {
                return NumberConverter.convertBytesToLong(this.this_row[columnIndex - 1]);
            }
        }
        return super.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return 0.0f;
        }
        if (this.netDataByStr) {
            return super.getFloat(columnIndex);
        }
        switch (this.getOscarType(columnIndex)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    return Float.parseFloat(this.encoding.decode(this.this_row[columnIndex - 1]));
                }
                return (float)NumberConverter.convertBytesToDouble(this.this_row[columnIndex - 1]);
            }
            case 23: {
                return NumberConverter.convertBytesToLong(this.this_row[columnIndex - 1]);
            }
        }
        return super.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return 0.0;
        }
        if (this.netDataByStr) {
            return super.getDouble(columnIndex);
        }
        if (this.this_row[columnIndex - 1].length == 2 && this.this_row[columnIndex - 1][0] == -3) {
            if (this.this_row[columnIndex - 1][1] == 1) {
                return Double.NaN;
            }
            if (this.this_row[columnIndex - 1][1] == 2) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.this_row[columnIndex - 1][1] == 3) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        switch (this.getOscarType(columnIndex)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    return Double.parseDouble(this.encoding.decode(this.this_row[columnIndex - 1]));
                }
                return NumberConverter.convertBytesToDouble(this.this_row[columnIndex - 1]);
            }
            case 23: {
                return NumberConverter.convertBytesToLong(this.this_row[columnIndex - 1]);
            }
        }
        return super.getDouble(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getBytes(columnIndex);
        }
        switch (this.getOscarType(columnIndex)) {
            case 24: {
                if (this.encodingFlag) {
                    return this.this_row[columnIndex - 1];
                }
                return this.clientEncoding.encode(this.encoding.decode(this.this_row[columnIndex - 1]));
            }
            case 2003: {
                if (this.encodingFlag) {
                    return this.this_row[columnIndex - 1];
                }
                return this.clientEncoding.encode(this.encoding.decode(this.this_row[columnIndex - 1]));
            }
            case 50: {
                OscarBlob blob = this.connection.getBlobInstance(new String(this.this_row[columnIndex - 1]));
                long length = blob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new OSQLException("OSCAR-00316", "22000", 316);
                }
                return blob.getBytes(1L, (int)length);
            }
            case 35: {
                if (this.encodingFlag) {
                    return OSCARbyte.toBytes(this.this_row[columnIndex - 1]);
                }
                return OSCARbyte.toBytes(this.clientEncoding.encode(this.encoding.decode(this.this_row[columnIndex - 1])));
            }
        }
        return this.clientEncoding.encode(this.getString(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTimestamp(columnIndex);
        }
        switch (this.getOscarType(columnIndex)) {
            case 26: 
            case 27: {
                Time oscarTime = TimetzConverter.convertBytesToTime(this.this_row[columnIndex - 1]);
                Timestamp res = new Timestamp(oscarTime.getTime());
                res.setNanos(oscarTime.getNanos());
                return res;
            }
            case 28: {
                com.oscar.sql.Timestamp value = TimestampConverter.convertBytesToTimeStamp(this.this_row[columnIndex - 1]);
                Timestamp timestamp = new Timestamp(value.getTime());
                timestamp.setNanos(value.getNanos());
                return timestamp;
            }
            case 29: {
                com.oscar.sql.Timestamp valueTZ = TimestamptzConverter.convertBytesToTimeStamp(this.this_row[columnIndex - 1]);
                Timestamp timestamptz = new Timestamp(valueTZ.getTime());
                timestamptz.setNanos(valueTZ.getNanos());
                return timestamptz;
            }
        }
        return super.getTimestamp(columnIndex);
    }

    public Timestamp getOscarTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTimestamp(columnIndex);
        }
        switch (this.getOscarType(columnIndex)) {
            case 26: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[columnIndex - 1]).getTime());
            }
            case 28: {
                return TimestampConverter.convertBytesToTimeStamp(this.this_row[columnIndex - 1]);
            }
            case 29: {
                return TimestamptzConverter.convertBytesToTimeStamp(this.this_row[columnIndex - 1]);
            }
            case 27: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[columnIndex - 1]).getTime());
            }
        }
        return super.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTimestamp(columnIndex, cal);
        }
        switch (this.getOscarType(columnIndex)) {
            case 26: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[columnIndex - 1], cal).getTime());
            }
            case 28: 
            case 29: {
                com.oscar.sql.Timestamp oscarTs = (com.oscar.sql.Timestamp)TimestamptzConverter.convertBytesToTimeStamp(this.this_row[columnIndex - 1], cal);
                Timestamp timestamp = new Timestamp(oscarTs.getTime());
                timestamp.setNanos(oscarTs.getNanos());
                return timestamp;
            }
            case 27: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[columnIndex - 1], cal).getTime());
            }
        }
        return super.getTimestamp(columnIndex, cal);
    }

    @Override
    protected java.sql.Time getOscarTime(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTime(columnIndex);
        }
        switch (this.getOscarType(columnIndex)) {
            case 26: {
                return new java.sql.Time(TimetzConverter.convertBytesToTime(this.this_row[columnIndex - 1]).getTime());
            }
            case 28: {
                return new java.sql.Time(TimestampConverter.convertBytesToTimeStamp(this.this_row[columnIndex - 1]).getTime());
            }
            case 29: {
                return new java.sql.Time(TimestamptzConverter.convertBytesToTimeStamp(this.this_row[columnIndex - 1]).getTime());
            }
            case 27: {
                return TimetzConverter.convertBytesToTime(this.this_row[columnIndex - 1]);
            }
        }
        return super.getTime(columnIndex);
    }

    @Override
    public java.sql.Time getTime(int columnIndex) throws SQLException {
        java.sql.Time innerTime = this.getOscarTime(columnIndex);
        if (innerTime instanceof Time) {
            return new java.sql.Time(((Time)innerTime).getTime());
        }
        return innerTime;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSetV2.class + ", isLast() ");
        }
        this.checkClosed();
        if (this.nullResult && this.rows.size() == 0) {
            return false;
        }
        if (!this.cursorUsed) {
            return this.current_row == this.rows.size() - 1 && this.rows.size() != 0;
        }
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return false;
        }
        if (this.maxRows > 0 && this.maxRowsCopy - 1 <= 0) {
            return true;
        }
        if (this.current_row == this.rows.size() - 1) {
            if (this.cursorPosition == 1) {
                return true;
            }
            if (this.planID != null) {
                ((OSCARProtocolV2)this.connection.getProtocol()).fetchMore(null, null, null, null, this.planID, this.fetchSize, this.maxRows, false, false, this.statement, this, false, 0);
                if (this.moveSize == 0) {
                    return true;
                }
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
                return false;
            }
            return super.isLast();
        }
        return false;
    }
}

