/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.gis.OscarObject;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarResultSetMetaData;
import com.oscar.jdbc.OscarResultSetV2;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStringClob;
import com.oscar.jdbc.ResultArray;
import com.oscar.jdbc.handler.NClobInvocationHandler;
import com.oscar.r2dbc.R2dbcNextPredicate;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarJDBCUtil;
import com.oscar.util.OtherType;
import com.oscar.util.TypeConverter;
import com.oscar.util.converter.BooleanConverter;
import com.oscar.util.converter.DateConverter;
import com.oscar.util.converter.NumberConverter;
import com.oscar.util.converter.TimeConverter;
import com.oscar.util.converter.TimestampConverter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class OscarResultSet
implements BaseResultSet,
R2dbcNextPredicate {
    protected Encoding encoding;
    protected Encoding clientEncoding;
    protected List<byte[][]> rows;
    protected BaseStatement statement;
    protected Field[] fields;
    protected String status;
    protected long updateCount;
    protected long insertRowid;
    protected int current_row = -1;
    protected byte[][] this_row;
    protected int lastColumn;
    protected boolean resultTid;
    protected List<byte[]> tidList;
    protected Field tidField;
    protected BaseConnection connection;
    protected SQLWarning warnings;
    protected BaseResultSet next = null;
    protected BaseResultSet previous = null;
    protected BaseResultSet lastResult = null;
    protected StringBuffer sbuf = null;
    protected byte[][] rowBuffer = null;
    protected int type = 1003;
    protected int concurrency = 1007;
    protected boolean canUpdateable = true;
    protected int statementType = 0;
    protected int fetchSize = 0;
    protected int fetchDirection = 1000;
    protected int maxRows = 0;
    protected boolean closed = false;
    protected boolean cursorUsed = false;
    protected int moveSize = 0;
    protected String cursorName = null;
    protected int cursorPosition = 0;
    protected Hashtable<String, Object> updateValues = new Hashtable();
    protected boolean nullResult;
    protected boolean doingUpdates = false;
    protected boolean onInsertRow = false;
    protected String tableName = null;
    protected String schemaName = null;
    protected PreparedStatement updateStatement = null;
    protected PreparedStatement insertStatement = null;
    protected Statement deleteStatement = null;
    protected static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    protected static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    protected HashMap<Object, Object> columnNameIndexMap;
    protected byte[] planID;
    protected boolean encodingFlag = false;
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    protected int datakind = 0;
    protected boolean isRowDeleted = false;
    protected boolean isRowinserted = false;
    protected boolean isRowupdated = false;
    protected boolean isOldProtocolResult = false;
    protected int maxRowsCopy = 0;
    protected boolean objectToString = false;
    protected boolean rsDateWithHMS = false;
    protected int sessionId;
    protected int pid;
    protected Calendar localCalendar;
    private static final Constructor<?> JDBC_4_RS_1_ARG;
    private static final Constructor<?> JDBC_4_RS_2_ARG;
    private static final Constructor<?> JDBC_4_RS_1_ARG_V2;
    private static final Constructor<?> JDBC_4_RS_2_ARG_V2;

    public OscarResultSet(BaseStatement statement, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) throws SQLException {
        this(statement, statement.getDBConnection(), statement.getResultSetType(), statement.getResultSetConcurrency(), statement.getResultSetCanUpdateable(), statement.getFetchDirection(), statement.getCursorName(), fields, tuples, status, updateCount, insertOID, fetchSize, maxRows);
    }

    public OscarResultSet(BaseStatement statement, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows, int dataKind) throws SQLException {
        this(statement, fields, tuples, status, updateCount, insertOID, maxRows, 0);
        this.datakind = dataKind;
        this.fields = new Field[3];
        this.cursorPosition = this.rows != null && this.rows.size() == 0 ? 1 : 0;
    }

    OscarResultSet(BaseStatement statement, BaseConnection connection, int resultSetType, int resultSetConcurrency, boolean canUpdateable, int fetchDirection, String curSorName, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) {
        this.connection = connection;
        this.statement = statement;
        this.type = resultSetType;
        this.concurrency = resultSetConcurrency;
        this.canUpdateable = canUpdateable;
        this.fetchSize = fetchSize;
        this.fetchDirection = fetchDirection;
        this.encoding = connection.getEncoding();
        this.clientEncoding = connection.getClientEncoding();
        if (this.encoding == null) {
            this.encodingFlag = true;
            this.encoding = this.clientEncoding;
        } else {
            this.encodingFlag = this.encoding.equals(this.clientEncoding);
        }
        this.fields = fields;
        this.rows = tuples;
        this.status = status;
        this.updateCount = updateCount;
        this.insertRowid = insertOID;
        this.cursorName = curSorName;
        if (fetchSize > this.rows.size()) {
            this.cursorPosition = 1;
        }
        if (this.rows.size() == 0) {
            this.nullResult = true;
        }
        this.maxRows = this.maxRowsCopy = maxRows;
        if (fields != null && fields.length > 0 && fields[0] != null) {
            this.tableName = fields[0].getTableName();
            this.schemaName = fields[0].getSchemaName();
        }
        Properties prop = connection.getConnectionProperties();
        this.objectToString = Boolean.valueOf(prop.getProperty("OBJECTTOSTRING", "false"));
        this.rsDateWithHMS = Boolean.valueOf(prop.getProperty("RSDATEWITHHMS", "false"));
        this.sessionId = connection.getSessionID();
        this.pid = connection.getPlanID();
        this.localCalendar = connection.getCalendar();
    }

    @Override
    public void reInit(Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID) {
        this.fields = fields;
        this.rows = tuples;
        this.status = status;
        this.updateCount = updateCount;
        this.insertRowid = insertOID;
        this.this_row = null;
        this.current_row = -1;
        this.columnNameIndexMap = null;
    }

    @Override
    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public List<byte[][]> getTuples() {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getTuples(), rows: " + this.rows.size());
        }
        return this.rows;
    }

    @Override
    public byte[][] getCurrentRow() {
        return this.this_row;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.logFlag && this.connection != null) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", next()");
        }
        this.checkClosed();
        if (this.maxRows > 0 && this.maxRowsCopy <= 0) {
            this.cursorPosition = 1;
            return false;
        }
        this.updateValues.clear();
        if (!this.cursorUsed && this.current_row == this.rows.size()) {
            this.this_row = null;
            return false;
        }
        if (this.cursorPosition == 1 && this.current_row == this.rows.size()) {
            this.this_row = null;
            return false;
        }
        if (++this.current_row >= this.rows.size()) {
            if (!this.cursorUsed) {
                this.this_row = null;
                return false;
            }
            if (this.cursorPosition == 1) {
                this.this_row = null;
                return false;
            }
            String sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement, this);
            this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            this.current_row = 0;
            if (this.rows.size() == 0) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        }
        if (this.maxRows > 0) {
            --this.maxRowsCopy;
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            if (this.cursorUsed) {
                try {
                    this.connection.closeCursor(this.cursorName, this.statement);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.rows = null;
            this.encoding = null;
            this.fields = null;
            this.status = null;
            this.this_row = null;
            this.tidList = null;
            this.tidField = null;
            this.warnings = null;
            this.next = null;
            this.sbuf = null;
            this.rowBuffer = null;
            this.updateValues = null;
            this.connection = null;
            this.cursorName = null;
            this.closed = true;
            this.deleteStatement = null;
            this.columnNameIndexMap = null;
        }
        finally {
            if (this.statement != null) {
                this.statement.checkAndPerformCloseOnCompletionAction();
            }
            this.statement = null;
        }
    }

    @Override
    public void setTidValues(Field field, List<byte[]> tids) {
        this.resultTid = true;
        this.tidField = field;
        this.tidList = tids;
        if (field != null && this.statement instanceof OscarStatement) {
            ((OscarStatement)this.statement).firstField = field;
        }
        if (this.schemaName == null || this.schemaName.length() == 0) {
            this.schemaName = field.getSchemaName();
        }
        if (this.tableName == null || this.tableName.length() == 0) {
            this.tableName = field.getTableName();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkNull();
        if (this.lastColumn == 0) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
        return this.this_row[this.lastColumn - 1] == null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        switch (this.getFieldType(columnIndex)) {
            case -4: 
            case -3: 
            case -2: {
                return OSCARbyte.toOSCARString(this.getBytes(columnIndex));
            }
            case 2005: {
                OscarClob clob = this.connection.getClobInstance(this.connection.getEncoding().decode(this.this_row[columnIndex - 1]));
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new OSQLException("OSCAR-00316", "22000", 316);
                }
                return clob.getSubString(1L, (int)length);
            }
            case 16: {
                return String.valueOf(this.getBoolean(columnIndex));
            }
        }
        return this.encoding.decode(this.this_row[columnIndex - 1]);
    }

    protected String getFixedString(int columnIndex) throws SQLException {
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        return this.encoding.decode(this.this_row[columnIndex - 1]);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toBoolean(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toByte(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toShort(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.encoding.hasAsciiNumbers()) {
            try {
                return this.getFastInt(columnIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String dbType = this.fields[columnIndex - 1].getDBType();
        String value = this.getFixedString(columnIndex);
        if (dbType.equalsIgnoreCase("float") || dbType.startsWith("double")) {
            double doubleValue = Double.parseDouble(value);
            if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                throw new OSQLException("OSCAR-00719", "88888", 719);
            }
            return (int)doubleValue;
        }
        if (dbType.equalsIgnoreCase("decimal") || dbType.equalsIgnoreCase("numeric")) {
            BigDecimal d = new BigDecimal(value);
            if (d.compareTo(BIG_DECIMAL_MIN_INTEGER_VALUE) < 0 || d.compareTo(BIG_DECIMAL_MAX_INTEGER_VALUE) > 0) {
                throw new OSQLException("OSCAR-00719", "88888", 719);
            }
            return d.intValue();
        }
        return OscarResultSet.toInt(value);
    }

    public static int toInt(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                if (s.length() > 0) {
                    return Integer.parseInt(s);
                }
                return 0;
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(INTMAX);
                    int lt = i.compareTo(INTMIN);
                    if (gt > 0 || lt < 0) {
                        throw new OSQLException("OSCAR-00719", "88888", 719, e);
                    }
                    return i.intValue();
                }
                catch (NumberFormatException ne) {
                    throw new OSQLException("OSCAR-00703", "88888", 703, ne);
                }
            }
        }
        return 0;
    }

    private int getFastInt(int columnIndex) throws SQLException, NumberFormatException {
        int start;
        boolean neg;
        byte[] bytes = this.this_row[columnIndex - 1];
        if (bytes == null) {
            return 0;
        }
        if (bytes.length == 0) {
            return 0;
        }
        int val = 0;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length == 1 || bytes.length > 10) {
                throw new NumberFormatException();
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 9) {
                throw new NumberFormatException();
            }
        }
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                throw new NumberFormatException();
            }
            val *= 10;
            val += b - 48;
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toLong(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toFloat(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toDouble(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toBigDecimal(this.getFixedString(columnIndex), this.getFieldType(columnIndex), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.getFieldType(columnIndex) == 2004) {
            OscarBlob blob = this.connection.getBlobInstance(new String(this.this_row[columnIndex - 1]));
            long length = blob.length();
            if (length > Integer.MAX_VALUE) {
                throw new OSQLException("OSCAR-00316", "22000", 316);
            }
            if (this.encodingFlag) {
                return blob.getBytes(1L, (int)length);
            }
            return this.clientEncoding.encode(this.encoding.decode(blob.getBytes(1L, (int)length)));
        }
        if (this.encodingFlag) {
            return TypeConverter.toBytes(this.connection, this.this_row[columnIndex - 1], this.getFieldType(columnIndex));
        }
        return TypeConverter.toBytes(this.connection, this.clientEncoding.encode(this.encoding.decode(this.this_row[columnIndex - 1])), this.getFieldType(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toDate(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toTime(this.getFixedString(columnIndex), this.getFieldType(columnIndex), this.localCalendar);
    }

    protected int getOscarType(int columnIndex) throws SQLException {
        return this.fields[columnIndex - 1].getOscarType();
    }

    protected Time getOscarTime(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        switch (this.getOscarType(columnIndex)) {
            case 27: {
                return TypeConverter.convertToTime(this.getFixedString(columnIndex), this.localCalendar.getTimeZone());
            }
        }
        return TypeConverter.toTime(this.getFixedString(columnIndex), this.getFieldType(columnIndex), this.localCalendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toTimestamp(this.getFixedString(columnIndex), this.getFieldType(columnIndex), this.localCalendar);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.getFixedString(columnIndex).getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new OSQLException("OSCAR-00303", "88888", 303, l_uee.getMessage(), l_uee);
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    public void addWarnings(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return this.cursorName;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Integer index;
        this.checkClosed();
        if (this.columnNameIndexMap == null) {
            this.initalizeColNames();
        }
        if ((index = (Integer)this.columnNameIndexMap.get(columnName.toUpperCase())) == null) {
            throw new OSQLException("OSCAR-00304", "88888", 304);
        }
        return index;
    }

    private void initalizeColNames() {
        int flen = this.fields.length;
        this.columnNameIndexMap = new HashMap(flen * 2);
        for (int i = 0; i < flen; ++i) {
            this.columnNameIndexMap.put(this.fields[i].getAliasName().toUpperCase(), i + 1);
        }
    }

    @Override
    public boolean reallyResultSet() {
        boolean isNotNull = false;
        if (this.fields == null) {
            return isNotNull;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == null) continue;
            isNotNull = true;
            break;
        }
        return isNotNull;
    }

    @Override
    public ResultSet getNext() {
        return this.next;
    }

    @Override
    public BaseResultSet getLastResult() {
        return this.lastResult;
    }

    @Override
    public void append(BaseResultSet r) {
        if (this.next == null) {
            this.next = r;
            r.setPrevious(this);
            this.lastResult = r;
        } else {
            this.lastResult.append(r);
        }
        this.lastResult = r;
    }

    @Override
    public void setPrevious(BaseResultSet rs) {
        this.previous = rs;
    }

    @Override
    public ResultSet getPrevious() {
        return this.previous;
    }

    @Override
    public long getResultCount() {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getResultCount()" + this.updateCount);
        }
        return this.updateCount;
    }

    @Override
    public int getTupleCount() {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getTupleCount()" + this.rows.size());
        }
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.length;
    }

    @Override
    public String getStatusString() {
        return this.status;
    }

    @Override
    public long getInsertRowid() {
        return this.insertRowid;
    }

    public void checkIndex(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        this.lastColumn = column;
    }

    protected void checkNull() throws SQLException {
        if (this.this_row == null) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
    }

    protected final int getFieldType(int columnIndex) throws SQLException {
        return this.fields[columnIndex - 1].getSQLType();
    }

    @Override
    public final boolean isCursorUsed() {
        return this.cursorUsed;
    }

    @Override
    public void setCursorUsed(boolean flag) {
        this.cursorUsed = flag;
    }

    @Override
    public void setCursorMoveSize(int size) {
        this.moveSize = size;
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new OSQLException("OSCAR-00306", "88888", 306);
        }
    }

    protected boolean checkResultClosed() throws SQLException {
        return !this.closed;
    }

    @Override
    public List<byte[]> getTidValues() {
        return this.tidList;
    }

    @Override
    public Field getTidField() {
        return this.tidField;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        switch (field.getSQLType()) {
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case 2: 
            case 3: {
                String value = this.getFixedString(columnIndex);
                if ("NaN".equals(value)) {
                    return Double.NaN;
                }
                return this.getBigDecimal(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case -7: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 91: {
                if (this.rsDateWithHMS) {
                    return this.getTimestamp(columnIndex);
                }
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                if (this.objectToString) {
                    return this.getString(columnIndex);
                }
                return this.getTimestamp(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2004: {
                if (this.objectToString) {
                    return ((OscarBlob)this.getBlob(columnIndex)).getSubString(1L, 8000);
                }
                return this.getBlob(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case -11: {
                return this.getBfile(columnIndex);
            }
            case 1111: {
                String type = this.getFields()[columnIndex - 1].getDBType();
                Class<? extends OscarObject> objClass = this.connection.getOscarObject(type);
                OscarObject oscarObj = null;
                try {
                    oscarObj = objClass != null ? objClass.newInstance() : new OscarObject();
                    oscarObj.setType(type);
                    oscarObj.setValue(this.getString(columnIndex));
                }
                catch (Exception e) {
                    Driver.writeLog(e);
                    oscarObj = new OscarObject();
                    oscarObj.setType(type);
                    oscarObj.setValue(this.getString(columnIndex));
                }
                return oscarObj;
            }
        }
        return this.getString(columnIndex);
    }

    @Override
    public synchronized boolean absolute(int index) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", absolute(int index), params: " + index);
        }
        this.checkClosed();
        this.checkMovable();
        if (this.maxRows > 0) {
            if (index > 0) {
                if (index > this.maxRows) {
                    this.maxRowsCopy = this.maxRows - index;
                    return false;
                }
                this.maxRowsCopy = this.maxRows - index;
                if (this.maxRowsCopy == 0) {
                    return true;
                }
            } else if (index < 0) {
                int absIndex = -index;
                if (absIndex > this.maxRows) {
                    return false;
                }
                this.maxRowsCopy = absIndex - 1;
            } else {
                this.maxRowsCopy = this.maxRows;
            }
        }
        this.updateValues.clear();
        String sql = null;
        if (!this.cursorUsed) {
            if (index == 0) {
                this.current_row = -1;
                this.this_row = null;
                return false;
            }
            if (index > 0) {
                if (index > this.rows.size()) {
                    this.current_row = this.rows.size();
                    this.this_row = null;
                    return false;
                }
                this.current_row = index - 1;
            } else {
                if (-index > this.rows.size()) {
                    this.current_row = -1;
                    this.this_row = null;
                    return false;
                }
                this.current_row = index + this.rows.size();
            }
        } else if (index == 0 || index == 1) {
            sql = "MOVE BACKWARD ALL IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            if (index == 0) {
                this.current_row = -1;
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            this.current_row = 0;
        } else if (index > 1) {
            sql = "MOVE BACKWARD ALL IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            sql = "MOVE FORWARD " + (index - 1) + " IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            if (this.moveSize < index - 1) {
                this.cursorPosition = 1;
                this.rows.clear();
                this.current_row = 0;
                this.rowBuffer = null;
                this.this_row = null;
                return false;
            }
            if (this.moveSize == index - 1) {
                sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                this.current_row = 0;
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            }
        } else {
            int absIndex = -index;
            if (this.maxRows > 0) {
                sql = "MOVE BACKWARD ALL IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                if (this.maxRows != absIndex) {
                    sql = "MOVE FORWARD " + this.maxRows + "IN " + this.cursorName;
                    this.connection.execSQL(sql, this.statement);
                    sql = "MOVE BACKWARD " + (this.maxRowsCopy + 1) + " IN " + this.cursorName;
                    this.connection.execSQL(sql, this.statement);
                }
            } else {
                sql = "MOVE FORWARD ALL IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                sql = "MOVE BACKWARD " + (absIndex + 1) + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
            }
            if (this.moveSize < absIndex) {
                sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
                this.this_row = null;
                this.rowBuffer = null;
                this.current_row = -1;
                return false;
            }
            if (this.moveSize == absIndex + 1 || this.moveSize == absIndex) {
                sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                this.current_row = 0;
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            }
        }
        if (this.rows.size() == 0) {
            this.current_row = index > 0 ? index : -1;
            this.this_row = null;
            this.rowBuffer = null;
            return false;
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", absolute(int index), rows: " + this.rows.size());
        }
        return true;
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", afterLast ");
        }
        this.checkClosed();
        this.checkMovable();
        this.updateValues.clear();
        this.this_row = null;
        if (this.isAfterLast()) {
            return;
        }
        if (!this.cursorUsed) {
            this.current_row = this.rows.size();
            return;
        }
        String sql = "MOVE FORWARD ALL IN " + this.cursorName;
        this.connection.execSQL(sql, this.statement);
        this.current_row = 0;
        this.rows.clear();
        this.this_row = null;
        this.rowBuffer = null;
        this.cursorPosition = 1;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", beforeFirst ");
        }
        this.checkClosed();
        this.checkMovable();
        this.updateValues.clear();
        this.this_row = null;
        if (this.isBeforeFirst()) {
            return;
        }
        if (!this.cursorUsed) {
            this.current_row = -1;
            return;
        }
        String sql = "MOVE BACKWARD ALL IN " + this.cursorName;
        this.connection.execSQL(sql, this.statement);
        sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
        this.connection.execSQL(sql, this.statement);
        this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
        this.this_row = null;
        this.rowBuffer = null;
        this.current_row = -1;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", first ");
        }
        return this.absolute(1);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        try {
            int type = this.getFieldType(columnIndex);
            if (type == 2004) {
                throw new SQLException("OSCAR-00302", "88888", 302);
            }
            if (type == 2005) {
                return this.getClob(columnIndex).getAsciiStream();
            }
            return new ByteArrayInputStream(this.getFixedString(columnIndex).getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new OSQLException("OSCAR-00302", "88888", 302, l_uee.getMessage(), l_uee);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        int type = this.getFieldType(columnIndex);
        if (type == 2004) {
            return this.getBlob(columnIndex).getBinaryStream();
        }
        byte[] b = this.getBytes(columnIndex);
        return new ByteArrayInputStream(b);
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.findColumn(columnName));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        return new ResultArray(this.connection, columnIndex, this.fields[columnIndex - 1], this);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toBigDecimal(this.getFixedString(columnIndex), this.getFieldType(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int t = this.findColumn(columnName);
        return this.getBigDecimal(t);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.getFieldType(columnIndex) != 2004) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        return this.connection.getBlobInstance(new String(this.this_row[columnIndex - 1]));
    }

    public OscarBfile getBfile(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.getFieldType(columnIndex) != -11) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        return this.connection.getBfileInstance(new String(this.this_row[columnIndex - 1]));
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        if (this.getFieldType(columnIndex) == 2005) {
            return this.connection.getClobInstance(this.connection.getEncoding().decode(this.this_row[columnIndex - 1]));
        }
        return new OscarStringClob(this.getString(columnIndex));
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        int type = this.getFieldType(columnIndex);
        if (type == 2004) {
            throw new SQLException("OSCAR-00302", "88888", 302);
        }
        if (type == 2005) {
            return this.getClob(columnIndex).getCharacterStream();
        }
        return new CharArrayReader(this.getFixedString(columnIndex).toCharArray());
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toDate(this.getFixedString(columnIndex), this.getFieldType(columnIndex), cal, Calendar.getInstance());
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toTime(this.getFixedString(columnIndex), this.getFieldType(columnIndex), cal, Calendar.getInstance());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        return TypeConverter.toTimestamp(this.getFixedString(columnIndex), this.getFieldType(columnIndex), cal, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.statement == null) {
            return 1007;
        }
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLException("oscar.osqlnotimp", "HY000", -1);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getRow()");
        }
        this.checkClosed();
        int rows_size = this.rows.size();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", rows_size: " + rows_size);
        }
        if (this.current_row < 0 || this.current_row >= rows_size) {
            return 0;
        }
        if (!this.cursorUsed || this.cursorName == null) {
            return this.current_row + 1;
        }
        String sql = "MOVE BACKWARD ALL IN " + this.cursorName;
        this.connection.execSQL(sql, this.statement);
        int size = this.moveSize;
        int retSize = 0;
        if (this.cursorPosition != 1) {
            sql = "MOVE FORWARD " + (this.moveSize + 1) + " IN " + this.cursorName;
            retSize = this.current_row + 2 - this.rows.size();
        } else {
            sql = "MOVE FORWARD ALL IN " + this.cursorName;
            retSize = this.current_row + 1 - this.rows.size();
        }
        this.connection.execSQL(sql, this.statement);
        return size + retSize;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    @Override
    public int getType() throws SQLException {
        return this.type;
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return true;
        }
        if (!this.cursorUsed) {
            return this.current_row >= this.rows.size();
        }
        return this.current_row >= this.rows.size() && this.cursorPosition == 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.nullResult && this.rows.size() == 0) {
            return false;
        }
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return false;
        }
        return this.current_row == -1;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", isFirst() ");
        }
        this.checkClosed();
        if (!this.cursorUsed) {
            return this.current_row == 0 && this.rows.size() > 0;
        }
        if (this.maxRows > 0 && this.maxRowsCopy <= 0) {
            return false;
        }
        if (this.current_row == -1) {
            return false;
        }
        if (this.current_row == 0 && this.rows.size() > 0) {
            if (this.cursorPosition == 1) {
                String sql = "MOVE BACKWARD " + (this.rows.size() + 1) + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                int size = this.moveSize;
                sql = "MOVE FORWARD ALL IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                return size < this.rows.size() + 1;
            }
            String sql = "MOVE BACKWARD " + this.rows.size() + " IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            int size = this.moveSize;
            if (size < this.rows.size()) {
                sql = "MOVE FORWARD " + (size + 1) + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                return true;
            }
            sql = "MOVE FORWARD " + size + " IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", isLast() ");
        }
        if (!this.cursorUsed) {
            return this.current_row == this.rows.size() - 1 && this.rows.size() != 0;
        }
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return false;
        }
        if (this.maxRows > 0 && this.maxRowsCopy - 1 <= 0) {
            return true;
        }
        if (this.current_row == this.rows.size() - 1) {
            if (this.cursorPosition == 1) {
                return true;
            }
            String sql = "MOVE FORWARD 1 IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            int size = this.moveSize;
            sql = "MOVE BACKWARD 1 IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            return size < 1;
        }
        return false;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", last()");
        }
        return this.absolute(-1);
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", previous()");
        }
        this.checkClosed();
        this.checkMovable();
        this.updateValues.clear();
        if (this.current_row == -1) {
            this.this_row = null;
            return false;
        }
        if (--this.current_row < 0) {
            if (!this.cursorUsed) {
                this.this_row = null;
                return false;
            }
            int previousSize = this.rows.size();
            String sql = null;
            if (this.cursorPosition == 0) {
                sql = "MOVE BACKWARD " + (this.fetchSize + previousSize) + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                if (this.moveSize < previousSize) {
                    this.current_row = -1;
                    this.rows.clear();
                    this.cursorPosition = -1;
                    this.rowBuffer = null;
                    this.this_row = null;
                    return false;
                }
                int newFetchsize = this.moveSize - previousSize;
                if (this.moveSize < this.fetchSize + previousSize) {
                    ++newFetchsize;
                }
                sql = "FETCH FORWARD " + newFetchsize + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                this.current_row = this.rows.size() - 1;
                this.cursorPosition = 0;
            } else if (this.cursorPosition == 1) {
                sql = "MOVE BACKWARD " + (this.fetchSize + (previousSize + 1)) + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                if (this.moveSize <= previousSize) {
                    this.current_row = -1;
                    this.cursorPosition = -1;
                    this.rows.clear();
                    this.rowBuffer = null;
                    this.this_row = null;
                    return false;
                }
                int newFetchsize = this.moveSize - (previousSize + 1);
                if (this.moveSize < this.fetchSize + (previousSize + 1)) {
                    ++newFetchsize;
                }
                sql = "FETCH FORWARD " + newFetchsize + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                this.current_row = this.rows.size() - 1;
                this.cursorPosition = 0;
            }
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public synchronized boolean relative(int relativeSize) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", relative(int relativeSize)(), params: " + relativeSize);
        }
        this.checkClosed();
        this.checkMovable();
        if (relativeSize == 0) {
            if (this.isAfterLast() || this.isBeforeFirst()) {
                this.this_row = null;
                return false;
            }
            return true;
        }
        this.updateValues.clear();
        int index = relativeSize + this.current_row;
        if (!this.cursorUsed) {
            if (index < 0) {
                this.current_row = -1;
                this.this_row = null;
                return false;
            }
            if (index >= this.rows.size()) {
                this.current_row = this.rows.size();
                this.this_row = null;
                return false;
            }
            this.current_row = index;
        } else if (index < 0) {
            if (this.isBeforeFirst()) {
                this.this_row = null;
                return false;
            }
            int mSize = this.cursorPosition == 1 ? this.rows.size() - index + 1 : this.rows.size() - index;
            String sql = "MOVE BACKWARD " + mSize + " IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            if (this.moveSize < mSize - 1) {
                this.current_row = -1;
                this.rows.clear();
                this.rowBuffer = null;
                this.this_row = null;
                this.cursorPosition = -1;
                return false;
            }
            sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
            this.connection.execSQL(sql, this.statement);
            this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            this.current_row = 0;
        } else if (index >= this.rows.size()) {
            if (this.cursorPosition == 1) {
                this.current_row = this.rows.size();
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            int mSize = index - this.rows.size();
            if (mSize > 0) {
                String sql = "MOVE FORWARD " + mSize + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                if (this.moveSize < mSize) {
                    this.rows.clear();
                    this.current_row = 0;
                    this.this_row = null;
                    this.rowBuffer = null;
                    this.cursorPosition = 1;
                    return false;
                }
                if (this.moveSize == mSize) {
                    sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                    this.connection.execSQL(sql, this.statement);
                    this.current_row = 0;
                    if (this.moveSize < this.fetchSize) {
                        this.cursorPosition = 1;
                        if (this.rows.size() == 0) {
                            this.this_row = null;
                            this.rowBuffer = null;
                            return false;
                        }
                    } else {
                        this.cursorPosition = 0;
                    }
                }
            } else {
                String sql = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(sql, this.statement);
                this.current_row = 0;
                if (this.moveSize < this.fetchSize) {
                    this.cursorPosition = 1;
                    if (this.rows.size() == 0) {
                        this.this_row = null;
                        this.rowBuffer = null;
                        return false;
                    }
                } else {
                    this.cursorPosition = 0;
                }
            }
        } else {
            this.current_row = index;
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new OSQLException("OSCAR-00418", "88888", 408);
        }
        if (this.type == 1003 && direction != 1000) {
            throw new OSQLException("OSCAR-00418", "88888", 408);
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        if (this.maxRows != 0 && rows > this.maxRows) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer();
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (this.onInsertRow) {
            throw new OSQLException("OSCAR-00308", "88888", 308);
        }
        if (this.rows.size() == 0 || this.isBeforeFirst() || this.isAfterLast()) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
        if (this.deleteStatement == null) {
            this.deleteStatement = this.connection.getMasterConnection().createStatement();
        }
        StringBuffer deleteSQL = new StringBuffer("DELETE FROM ").append(this.schemaName).append(".").append(this.tableName).append(" where rowid = ");
        byte[] rowidArray = this.tidList.get(this.current_row);
        if (this.connection.getProtocolVersion().getProtocolType() >= 2) {
            long rowid = NumberConverter.convertBytesToLong(rowidArray);
            deleteSQL.append(rowid);
        } else {
            deleteSQL.append(this.encoding.decode(rowidArray));
        }
        int deleteCount = this.deleteStatement.executeUpdate(deleteSQL.toString());
        if (deleteCount > 0) {
            this.rows.remove(this.current_row);
            this.tidList.remove(this.current_row);
            --this.current_row;
            this.this_row = null;
        }
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (!this.onInsertRow) {
            throw new OSQLException("OSCAR-00309", "88888", 309);
        }
        StringBuilder insertSQL = new StringBuilder("INSERT INTO ").append(this.schemaName).append(".").append(this.tableName).append(" (");
        StringBuilder paramSQL = new StringBuilder(") values (");
        Enumeration<String> columnNames = this.updateValues.keys();
        int numColumns = this.updateValues.size();
        int i = 0;
        while (columnNames.hasMoreElements()) {
            String columnName = columnNames.nextElement();
            insertSQL.append(columnName);
            if (i < numColumns - 1) {
                insertSQL.append(", ");
                paramSQL.append("?,");
            } else {
                paramSQL.append("?)");
            }
            ++i;
        }
        insertSQL.append(paramSQL.toString());
        this.insertStatement = this.connection.getMasterConnection().prepareStatement(insertSQL.toString());
        Enumeration<String> keys = this.updateValues.keys();
        int i2 = 1;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object o = this.updateValues.get(key);
            if (o instanceof NullObject) {
                this.insertStatement.setNull(i2, 0);
            } else {
                this.insertStatement.setObject(i2, o);
            }
            ++i2;
        }
        int insertCount = this.insertStatement.executeUpdate();
        this.isRowinserted = insertCount > 0;
        this.updateRowBuffer();
        if (!this.cursorUsed) {
            int insertRowid = ((OscarStatement)((Object)this.insertStatement)).getInsertRowid();
            this.tidList.add(this.encoding.encode(String.valueOf(insertRowid)));
            this.rows.add(this.rowBuffer);
        }
        this.insertStatement.close();
        this.this_row = this.rowBuffer;
        this.clearRowBuffer();
        this.onInsertRow = false;
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (this.current_row < 0 || this.current_row >= this.rows.size()) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.this_row = this.rows.get(this.current_row);
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.onInsertRow = false;
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer();
        this.onInsertRow = true;
    }

    private synchronized void clearRowBuffer() throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        this.updateValues.clear();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.isRowDeleted;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.isRowinserted;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.isRowupdated;
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        this.checkUpdatable();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] theData = new byte[length];
        try {
            x.read(theData, 0, length);
            this.updateValue(columnIndex, new String(theData, "US-ASCII"));
        }
        catch (IOException ie) {
            throw new OSQLException("OSCAR-00310", "88888", 310, ie.getMessage(), ie);
        }
        catch (Exception e) {
            throw new OSQLException("OSCAR-00310", "88888", 310, e);
        }
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkUpdatable();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] data = new byte[length];
        try {
            x.read(data, 0, length);
        }
        catch (IOException ie) {
            throw new OSQLException("OSCAR-00103", "88888", 103, ie.getMessage(), ie);
        }
        this.updateBytes(columnIndex, data);
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkUpdatable();
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        char[] data = new char[length];
        String value = null;
        try {
            int rLength = x.read(data, 0, length);
            value = new String(data, 0, rLength);
        }
        catch (IOException ie) {
            throw new OSQLException("OSCAR-00311", "88888", 311, ie.getMessage(), ie);
        }
        this.updateValue(columnIndex, value);
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, new Double(x));
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, new Float(x));
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, new NullObject());
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (this.fields[columnIndex - 1].getSQLType() == 2 || this.fields[columnIndex - 1].getSQLType() == 3) {
            try {
                if (scale < -1) {
                    throw new OSQLException("OSCAR-00312", "88888", 312);
                }
                BigDecimal dec = new BigDecimal(x.toString()).setScale(scale);
                this.updateObject(columnIndex, (Object)dec);
            }
            catch (Exception e) {
                throw new OSQLException("OSCAR-00707", "88888", 707, e);
            }
        } else {
            this.updateObject(columnIndex, x);
        }
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw new OSQLException("OSCAR-00308", "88888", 308);
        }
        if (this.rows.size() == 0 || this.isBeforeFirst() || this.isAfterLast()) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
        try {
            this.updateRowBuffer();
            System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
            this.rows.set(this.current_row, this.rowBuffer);
            this.this_row = this.rowBuffer;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw new OSQLException("OSCAR-00308", "88888", 308);
        }
        if (this.updateValues.isEmpty()) {
            return;
        }
        try {
            StringBuffer updateSQL = new StringBuffer("UPDATE ").append(this.schemaName).append(".").append(this.tableName).append(" SET ");
            int numColumns = this.updateValues.size();
            Enumeration<String> columns = this.updateValues.keys();
            ArrayList<Integer> nullColumns = new ArrayList<Integer>();
            int i = 0;
            while (columns.hasMoreElements()) {
                String column = columns.nextElement();
                if (this.updateValues.get(column) instanceof NullObject) {
                    int columnIndex = this.findColumn(column) - 1;
                    nullColumns.add(columnIndex);
                }
                updateSQL.append(column);
                updateSQL.append(" = ?");
                if (i < numColumns - 1) {
                    updateSQL.append(", ");
                }
                ++i;
            }
            if (this.tidList == null) {
                throw new OSQLException("OSCAR-00317", "88888", 317);
            }
            byte[] rowidArray = this.tidList.get(this.current_row);
            if (this.connection.getProtocolVersion().getProtocolType() >= 2) {
                long rowid = NumberConverter.convertBytesToLong(rowidArray);
                updateSQL.append(" WHERE rowid = " + rowid);
            } else {
                updateSQL.append(" WHERE rowid = " + this.encoding.decode(rowidArray));
            }
            this.updateStatement = this.connection.getMasterConnection().prepareStatement(updateSQL.toString());
            int i2 = 0;
            for (Object o : this.updateValues.values()) {
                if (o instanceof NullObject) {
                    this.updateStatement.setNull(i2 + 1, 0);
                } else {
                    this.updateStatement.setObject(i2 + 1, o);
                }
                ++i2;
            }
            int updateCount = this.updateStatement.executeUpdate();
            this.isRowupdated = updateCount > 0;
            this.updateStatement.close();
            this.updateStatement = null;
            this.updateRowBuffer();
            for (int col = 0; col < this.rowBuffer.length; ++col) {
                if (this.rowBuffer[col] != null || nullColumns.size() > 0 && nullColumns.contains(col)) continue;
                this.rowBuffer[col] = this.this_row[col];
            }
            System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
            this.rows.set(this.current_row, this.rowBuffer);
            this.updateValues.clear();
            this.doingUpdates = false;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    private void updateRowBuffer() throws SQLException {
        Enumeration<String> columns = this.updateValues.keys();
        block21: while (columns.hasMoreElements()) {
            String columnName = columns.nextElement();
            int columnIndex = this.findColumn(columnName) - 1;
            Object valueObject = this.updateValues.get(columnName);
            if (valueObject instanceof NullObject) {
                this.rowBuffer[columnIndex] = null;
                continue;
            }
            if (this.connection.getProtocolVersion().getProtocolType() >= 2) {
                byte[] tmpBytes = null;
                boolean netDataByStr = this.connection.isNetDataByStr();
                switch (this.connection.getSQLType(this.fields[columnIndex].getDBType())) {
                    case -6: 
                    case 5: {
                        this.rowBuffer[columnIndex] = NumberConverter.convertIntToBytes(((Short)valueObject).intValue());
                        break;
                    }
                    case 4: {
                        this.rowBuffer[columnIndex] = NumberConverter.convertIntToBytes((Integer)valueObject);
                        break;
                    }
                    case -5: {
                        this.rowBuffer[columnIndex] = NumberConverter.convertLongToBytes(((Long)valueObject).intValue());
                        break;
                    }
                    case -7: 
                    case 16: {
                        this.rowBuffer[columnIndex] = BooleanConverter.convertBooleanToBytes(Boolean.parseBoolean(String.valueOf(valueObject)));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        tmpBytes = this.encoding.encode(String.valueOf(valueObject));
                        this.rowBuffer[columnIndex] = this.convertByteArr(tmpBytes);
                        break;
                    }
                    case 91: {
                        if (netDataByStr) {
                            this.rowBuffer[columnIndex] = this.encoding.encode(String.valueOf(((Date)valueObject).getTime()));
                            break;
                        }
                        this.rowBuffer[columnIndex] = DateConverter.convertDateToBytes((Date)valueObject, this.localCalendar);
                        break;
                    }
                    case 92: {
                        this.rowBuffer[columnIndex] = TimeConverter.convertTimeToBytes((Time)valueObject, this.localCalendar);
                        break;
                    }
                    case 93: {
                        if (netDataByStr) {
                            if (valueObject instanceof Timestamp) {
                                this.rowBuffer[columnIndex] = this.encoding.encode(String.valueOf(((Timestamp)valueObject).getTime()));
                                break;
                            }
                            this.rowBuffer[columnIndex] = this.encoding.encode(String.valueOf(((Date)valueObject).getTime()));
                            break;
                        }
                        if (valueObject instanceof Timestamp) {
                            this.rowBuffer[columnIndex] = TimestampConverter.convertTimestampToBytes((Timestamp)valueObject, this.localCalendar);
                            break;
                        }
                        this.rowBuffer[columnIndex] = TimestampConverter.convertTimestampToBytes(new Timestamp(((Date)valueObject).getTime()), this.localCalendar);
                        break;
                    }
                    case 2004: 
                    case 2005: {
                        tmpBytes = this.encoding.encode(String.valueOf(valueObject));
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (valueObject instanceof byte[]) {
                            this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(OSCARbyte.toOSCARString((byte[])valueObject));
                            break;
                        }
                        this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(valueObject));
                        break;
                    }
                    default: {
                        throw new OSQLException("OSCAR-00411", "88888", 411);
                    }
                }
                continue;
            }
            switch (this.connection.getSQLType(this.fields[columnIndex].getDBType())) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: 
                case 92: {
                    this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(valueObject));
                    continue block21;
                }
                case 2004: 
                case 2005: {
                    continue block21;
                }
                case 91: {
                    this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(((Date)valueObject).getTime()));
                    continue block21;
                }
                case 93: {
                    if (valueObject instanceof Timestamp) {
                        this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(((Timestamp)valueObject).getTime()));
                        continue block21;
                    }
                    this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(((Date)valueObject).getTime()));
                    continue block21;
                }
                case 0: {
                    continue block21;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (valueObject instanceof byte[]) {
                        this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(OSCARbyte.toOSCARString((byte[])valueObject));
                        continue block21;
                    }
                    this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(valueObject));
                    continue block21;
                }
            }
            throw new OSQLException("OSCAR-00411", "88888", 411);
        }
    }

    protected byte[] convertByteArr(byte[] src) {
        if (src != null && src.length > 240) {
            byte[] s = this.convertVarcharData(src);
            return s;
        }
        return src;
    }

    public byte[] convertVarcharData(byte[] data) {
        int len = data.length + 1 + (data.length + 240 - 1) / 240 + 1;
        byte[] result = new byte[len];
        result[0] = -2;
        int srcPosition = 0;
        int destPosition = 1;
        int tmp = data.length - srcPosition;
        while (true) {
            if (tmp == 240) {
                result[destPosition] = -16;
                System.arraycopy(data, srcPosition, result, ++destPosition, 240);
                srcPosition += 240;
                destPosition += 240;
                break;
            }
            if (tmp > 240) {
                result[destPosition] = -16;
                System.arraycopy(data, srcPosition, result, ++destPosition, 240);
                destPosition += 240;
            } else {
                result[destPosition] = (byte)tmp;
                System.arraycopy(data, srcPosition, result, ++destPosition, tmp);
                srcPosition += tmp;
                destPosition += tmp;
                break;
            }
            tmp = data.length - (srcPosition += 240);
        }
        result[len - 1] = 0;
        return result;
    }

    protected void updateValue(int columnIndex, Object value) throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        if (!this.onInsertRow) {
            this.checkNull();
        }
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (value == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateValues.put(this.fields[columnIndex - 1].getName(), value);
        }
    }

    protected void checkMovable() throws SQLException {
        if (this.type == 1003) {
            throw new OSQLException("OSCAR-00313", "88888", 313);
        }
    }

    protected void checkUpdatable() throws SQLException {
        if (this.concurrency == 1007 || !this.canUpdateable) {
            throw new OSQLException("OSCAR-00314", "88888", 314);
        }
    }

    @Override
    public boolean hasNext() throws SQLException {
        return !this.isLast() && !this.isAfterLast() && this.getTupleCount() > 0;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new OscarResultSetMetaData(this.fields, (OscarJdbc2Connection)this.connection);
    }

    @Override
    public void setPlanID(byte[] planID) {
        this.planID = planID;
    }

    @Override
    public byte[] getPlanID() {
        return this.planID;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public byte[] getCurrentBlock() {
        System.arraycopy(this.this_row[0], 0, this.this_row[2], 0, 4);
        System.arraycopy(this.this_row[1], 0, this.this_row[2], 4, 4);
        return this.this_row[2];
    }

    @Override
    public void setResultType(boolean flag) {
        this.isOldProtocolResult = flag;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        Clob clob = this.getClob(columnIndex);
        if (clob == null) {
            return null;
        }
        return (NClob)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{NClob.class}, (InvocationHandler)new NClobInvocationHandler(clob));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented();
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(this.findColumn(columnName));
        }
        throw Driver.notImplemented();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        String data = this.getString(columnIndex);
        if (data == null) {
            return null;
        }
        return new OscarSQLXML(this.connection, data);
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        return this.getSQLXML(this.findColumn(arg0));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(inputStream, -1L));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(x, length));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(inputStream, -1L));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(inputStream, length));
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(inputStream, -1L));
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(inputStream, length));
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(x, -1L));
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(x, length));
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(x, -1L));
    }

    @Override
    public void updateClob(String columnName, Reader x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.updateObject(columnIndex, (Object)new OtherType(x, length));
    }

    @Override
    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        this.updateClob(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML obj) throws SQLException {
        this.updateString(columnIndex, obj.getString());
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML obj) throws SQLException {
        this.updateSQLXML(this.findColumn(columnName), obj);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return arg0.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (type == null) {
            throw new OSQLException("OSCAR-00319", "88888", 319);
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(columnIndex);
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(columnIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(columnIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type.equals(Clob.class)) {
            return (T)this.getClob(columnIndex);
        }
        if (type.equals(Blob.class)) {
            return (T)this.getBlob(columnIndex);
        }
        if (type.equals(Array.class)) {
            return (T)this.getArray(columnIndex);
        }
        if (type.equals(Ref.class)) {
            return (T)this.getRef(columnIndex);
        }
        if (type.equals(URL.class)) {
            return (T)this.getURL(columnIndex);
        }
        if (type.equals(Struct.class)) {
            throw Driver.notImplemented();
        }
        if (type.equals(RowId.class)) {
            return (T)this.getRowId(columnIndex);
        }
        if (type.equals(NClob.class)) {
            return (T)this.getNClob(columnIndex);
        }
        if (type.equals(SQLXML.class)) {
            return (T)this.getSQLXML(columnIndex);
        }
        try {
            return (T)this.getObject(columnIndex);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Conversion not supported for type " + type.getName());
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    protected static BaseResultSet getInstance(BaseStatement statement, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_1_ARG, new Object[]{statement, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows});
        }
        return new OscarResultSet(statement, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows);
    }

    protected static BaseResultSet getInstanceDataKind(BaseStatement statement, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows, int dataKind) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_2_ARG, new Object[]{statement, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows, dataKind});
        }
        return new OscarResultSet(statement, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows, dataKind);
    }

    protected static BaseResultSet getInstanceV2(BaseStatement statement, BaseConnection connection, boolean netDataByStr, boolean numericKeepPrecision, int resultSetType, int resultSetConcurrency, boolean canUpdateable, int fetchDirection, Encoding encoding, String curSorName, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_1_ARG_V2, new Object[]{statement, connection, netDataByStr, numericKeepPrecision, resultSetType, resultSetConcurrency, canUpdateable, fetchDirection, encoding, curSorName, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows});
        }
        return new OscarResultSetV2(statement, connection, netDataByStr, numericKeepPrecision, resultSetType, resultSetConcurrency, canUpdateable, fetchDirection, encoding, curSorName, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows);
    }

    protected static BaseResultSet getInstanceV2CallableStatement(BaseStatement statement, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_2_ARG_V2, new Object[]{statement, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows});
        }
        return new OscarResultSetV2(statement, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows);
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    static {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc4()) {
            try {
                String jdbc4ClassNameV2 = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42ResultSetV2" : "com.oscar.jdbc.OscarResultSetV2";
                JDBC_4_RS_1_ARG_V2 = Class.forName(jdbc4ClassNameV2).getConstructor(BaseStatement.class, BaseConnection.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Encoding.class, String.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
                JDBC_4_RS_2_ARG_V2 = Class.forName(jdbc4ClassNameV2).getConstructor(BaseStatement.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
                String jdbc4ClassName = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42ResultSet" : "com.oscar.jdbc.OscarResultSet";
                JDBC_4_RS_1_ARG = Class.forName(jdbc4ClassName).getConstructor(BaseStatement.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
                JDBC_4_RS_2_ARG = Class.forName(jdbc4ClassName).getConstructor(BaseStatement.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            JDBC_4_RS_1_ARG = null;
            JDBC_4_RS_2_ARG = null;
            JDBC_4_RS_1_ARG_V2 = null;
            JDBC_4_RS_2_ARG_V2 = null;
        }
    }

    static class NullObject {
        NullObject() {
        }
    }
}

