/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import java.net.SocketException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;

public abstract class ExceptionUtil {
    public static final int STATE_CLOSED_NO = 0;
    public static final int STATE_CLOSED_YES = 1;
    public static final int STATE_DISCONNECTIONED = 2;

    public static int isConnectionClosed(Throwable e) {
        if (!(e instanceof SQLException)) {
            return 0;
        }
        if (e instanceof SQLRecoverableException) {
            return 1;
        }
        SQLException tmp = (SQLException)e;
        if ("08003".equals(tmp.getSQLState())) {
            if (tmp.getErrorCode() == 211 || tmp.getErrorCode() == 109) {
                return 2;
            }
            return 1;
        }
        if (e.getMessage().indexOf("system closing") != -1 || e.getMessage().contains("closed Statement") || e.getMessage().contains("connection was broken") || e.getMessage().contains("has been closed") || e.getMessage().contains("\u4e3b\u4ece\u5207\u6362\u672a\u5b8c\u6210") || e.getMessage().contains("\u4e3b\u5907\u5207\u6362\u672a\u5b8c\u6210") || e.getMessage().contains("\u6570\u636e\u4f20\u8f93\u9519\u8bef") || e.getMessage().toLowerCase().indexOf("connection ") != -1) {
            return 1;
        }
        return 0;
    }

    public static boolean isSocketConnectionError(Throwable e) {
        SocketException se = null;
        if (e instanceof SocketException) {
            se = (SocketException)e;
        } else if (e.getCause() instanceof SocketException) {
            se = (SocketException)e.getCause();
        }
        if (se != null) {
            if (se.getMessage().startsWith("Software caused connection abort: ")) {
                return true;
            }
            if (se.getMessage().startsWith("Connection reset")) {
                return true;
            }
            if (e.getMessage().contains("Broken pipe") || e.getMessage().contains("\u65ad\u5f00\u7684\u7ba1\u9053")) {
                return true;
            }
        } else if (e.getMessage().contains("system closing")) {
            return true;
        }
        return false;
    }
}

