/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarPath
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8171736651491981495L;
    private boolean open;
    private OscarPoint[] points;

    public OscarPath(OscarPoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public OscarPath() {
        this.setType("path");
    }

    public OscarPath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = OscarTokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = OscarTokenizer.removePara(s);
        } else {
            throw new SQLException("Cannot tell if path is open or closed: " + s);
        }
        OscarTokenizer t = new OscarTokenizer(s, ',');
        int npoints = t.getSize();
        this.points = new OscarPoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new OscarPoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OscarPath) {
            OscarPath p = (OscarPath)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarPath newOscarPath = (OscarPath)super.clone();
        if (newOscarPath.points != null) {
            newOscarPath.points = (OscarPoint[])newOscarPath.points.clone();
            for (int i = 0; i < newOscarPath.points.length; ++i) {
                newOscarPath.points[i] = (OscarPoint)newOscarPath.points[i].clone();
            }
        }
        return newOscarPath;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder(this.open ? "[" : "(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

