/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.dispatcher.entity;

import com.oscar.Driver;
import com.oscar.cluster.Cluster;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.DistributeImportHandler;
import com.oscar.core.Encoding;
import com.oscar.core.ExportHandler;
import com.oscar.core.ImportHandler;
import com.oscar.core.ProviderImportHandler;
import com.oscar.core.QueryExecutor;
import com.oscar.dispatcher.core.ConnectionMangerV2;
import com.oscar.dispatcher.entity.FakeConnection;
import com.oscar.dispatcher.entity.GlobalLsnVo;
import com.oscar.dispatcher.entity.LsnVo;
import com.oscar.dispatcher.entity.ThreadLocalLsnVo;
import com.oscar.dispatcher.executor.DispatchCallableStatementV2;
import com.oscar.dispatcher.executor.DispatchPreparedStatementV2;
import com.oscar.dispatcher.executor.DispatchStatementV2;
import com.oscar.fastpath.Fastpath;
import com.oscar.gis.OscarObject;
import com.oscar.jdbc.OSCARTransfer;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbcx.optional.PooledConnectionImpl;
import com.oscar.protocol.OSCARProtocol;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.util.VersionConfig;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.sql.StatementEventListener;

public class DispatchConnection
implements Connection,
BaseConnection {
    private int transStatus;
    private String dispatcherSessionId;
    private OscarJdbc2Connection mainConn;
    protected String[] directToMainArray = null;
    protected String[] directToSlaveArray = null;
    public Integer sessionID = -1;
    public String passward;
    public String dbName;
    public final Properties props = new Properties();
    public String url;
    private final Map<String, Connection> slaveConnMap = new ConcurrentHashMap<String, Connection>();
    private final Map<String, Map<String, String>> slaveConnInfo = new HashMap<String, Map<String, String>>();
    public static final String SLAVE = "slave";
    public final int slaveCount;
    private int fakeSlaveConnectionCount;
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    protected volatile boolean autoCommit = true;
    protected volatile boolean hasUpdate = false;
    protected boolean isResultSetZeroResend = false;
    protected boolean useSlaveSynRead = false;
    private boolean useSlaveSyncReadGlobal = false;
    private long slaveDelayTime = 0L;
    private boolean dispatchAggBool = false;
    private Object lockOnCreate = new Object();
    private final Map<String, Integer> slaveTryCountMap = new ConcurrentHashMap<String, Integer>();
    private static final int MAX_SLAVE_TRY_CREATE_COUNT = 3;
    private boolean autoReconnect = false;
    public static final ThreadLocal<ThreadLocalLsnVo> threadLocalLsn = new ThreadLocal<ThreadLocalLsnVo>(){

        @Override
        public ThreadLocalLsnVo initialValue() {
            return new ThreadLocalLsnVo();
        }
    };
    public static final GlobalLsnVo globalLsnVo = new GlobalLsnVo();

    public DispatchConnection(OscarJdbc2Connection mainConn, String passward, String dbName, Properties props) {
        this(mainConn, passward, dbName, props, null);
    }

    public DispatchConnection(OscarJdbc2Connection mainConn, String passward, String dbName, Properties props, Map<String, Map<String, String>> slaveConnInfo) {
        String directToSlave;
        this.mainConn = mainConn;
        this.passward = passward;
        this.dbName = dbName;
        this.props.putAll((Map<?, ?>)props);
        this.sessionID = mainConn.sessionID;
        this.url = this.getUrl();
        String directToMain = props.getProperty("DIRECTTOMAINSQL", "");
        if (directToMain.trim().length() > 0) {
            String[] stringArray;
            String[] _directToMainArray = directToMain.split(";");
            ArrayList<String> strs = new ArrayList<String>();
            boolean all = false;
            for (String mainStr : _directToMainArray) {
                String mainStrTrim = mainStr.trim();
                if ("*".equals(mainStrTrim)) {
                    all = true;
                    break;
                }
                if (mainStrTrim.length() <= 0) continue;
                strs.add(mainStrTrim);
            }
            if (all) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*";
            } else {
                stringArray = this.directToMainArray = strs.toArray(new String[strs.size()]);
            }
        }
        if ((directToSlave = props.getProperty("DIRECTTOSLAVESQL", "")).trim().length() > 0) {
            String[] _directToSlaveArray = directToSlave.split(";");
            ArrayList<String> strs = new ArrayList<String>();
            for (String slaveStr : _directToSlaveArray) {
                String slaveStrTrim = slaveStr.trim();
                if (slaveStrTrim.length() <= 0) continue;
                strs.add(slaveStrTrim);
            }
            this.directToSlaveArray = strs.toArray(new String[strs.size()]);
        }
        this.isResultSetZeroResend = Boolean.valueOf(props.getProperty("RESULTSETZERORESEND", "false"));
        this.useSlaveSynRead = Boolean.valueOf(props.getProperty("USESLAVESYNCREAD", "false"));
        this.useSlaveSyncReadGlobal = Boolean.valueOf(props.getProperty("USESLAVESYNCREADGLOBAL", "false"));
        this.slaveDelayTime = Long.parseLong(props.getProperty("SLAVEDELAYTIME", "0"));
        this.dispatchAggBool = Boolean.parseBoolean(props.getProperty("DISPATCHAGG_FUNC", "false"));
        mainConn.setDispatchConn(this);
        if (slaveConnInfo != null) {
            this.slaveConnInfo.putAll(slaveConnInfo);
        }
        this.slaveCount = this.slaveConnInfo.size();
        this.autoReconnect = Boolean.valueOf(props.getProperty("AUTORECONNECT", "false"));
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setHasUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public OscarJdbc2Connection getMainConn() {
        return this.mainConn;
    }

    public void setMainConn(OscarJdbc2Connection mainConn) {
        this.mainConn = mainConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getSlaveConnection(String key) {
        if (key == null) {
            return null;
        }
        Connection conn = this.slaveConnMap.get(key);
        if (conn == null) {
            Object object = this.lockOnCreate;
            synchronized (object) {
                conn = this.slaveConnMap.get(key);
                if (conn != null) {
                    return conn;
                }
                Integer tryCnt = this.slaveTryCountMap.get(key);
                if (tryCnt != null && tryCnt >= 3) {
                    return this.fakeConnection(key);
                }
                Map<String, String> infoMap = this.slaveConnInfo.get(key);
                if (infoMap == null) {
                    return null;
                }
                String url = "jdbc:oscar://" + infoMap.get("ADDRESS") + ":" + infoMap.get("PORT") + "/" + this.dbName;
                try {
                    this.props.setProperty("USEDISPATCH", "FALSE");
                    this.props.setProperty("RWHA", "0");
                    conn = DriverManager.getConnection(url, this.props);
                    ((OscarJdbc2Connection)conn).setDispatchConn(this);
                    ((BaseConnection)((Object)conn)).setMasterConnection(this.mainConn);
                    ((BaseConnection)((Object)conn)).setIsSlave(true);
                    this.slaveConnMap.put(key, conn);
                }
                catch (SQLException e) {
                    if (this.logFlag) {
                        StringBuilder sb = new StringBuilder(DispatchConnection.class + ", getSlaveConnection(String key), ");
                        sb.append("connect slave: " + url + "failed:");
                        sb.append(e.getMessage());
                        Driver.writeLog(this.sessionID, this.mainConn.getPlanID(), sb.toString());
                    }
                    return this.fakeConnection(key);
                }
            }
        }
        return conn;
    }

    private Connection fakeConnection(String key) {
        FakeConnection tagConn = FakeConnection.getInstance();
        this.slaveConnMap.put(key, tagConn);
        ++this.fakeSlaveConnectionCount;
        return tagConn;
    }

    public synchronized void removeSlaveConnection(String key) {
        if (key != null) {
            Connection conn = this.slaveConnMap.remove(key);
            if (conn instanceof FakeConnection) {
                --this.fakeSlaveConnectionCount;
            } else {
                Integer tryCnt = this.slaveTryCountMap.get(key);
                this.slaveTryCountMap.put(key, tryCnt == null ? Integer.valueOf(1) : (tryCnt = Integer.valueOf(tryCnt + 1)));
            }
        }
    }

    public List<Connection> getAllSlaveConn() throws SQLException {
        ArrayList<Connection> rs = new ArrayList<Connection>();
        for (int i = 0; i < this.slaveCount; ++i) {
            Connection conn = this.getSlaveConnection(SLAVE + i);
            if (conn == null) continue;
            rs.add(conn);
        }
        return rs;
    }

    protected String getUrl() {
        String url = "jdbc:oscar://" + this.props.get("DBHOST") + ":" + this.props.get("DBPORT") + "/" + this.dbName + "?hostLoadRate=" + this.props.getProperty("HOSTLOADRATE");
        return url;
    }

    public String getDispatcherSessionId() {
        return this.dispatcherSessionId;
    }

    public void setDispatcherSessionId(String dispatcherSessionId) {
        this.dispatcherSessionId = dispatcherSessionId;
    }

    @Override
    public void close() throws SQLException {
        this.mainConn.close();
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            Connection conn = it.next();
            if (!(conn instanceof FakeConnection)) {
                conn.close();
            }
            it.remove();
        }
        if (this.logFlag) {
            Driver.writeLog(ConnectionMangerV2.printSlaveAccessCount());
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.mainConn.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.mainConn.commit();
        this.hasUpdate = false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DispatchStatementV2(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchStatementV2(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchStatementV2(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.mainConn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.mainConn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.mainConn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.mainConn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.mainConn.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.mainConn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.mainConn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.mainConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.mainConn.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.mainConn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new DispatchCallableStatementV2(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchCallableStatementV2(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchCallableStatementV2(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, columnNames);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.mainConn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.mainConn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.mainConn.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.mainConn.setAutoCommit(autoCommit);
        if (this.autoCommit != autoCommit) {
            this.autoCommit = autoCommit;
            this.hasUpdate = false;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.mainConn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.mainConn.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.mainConn.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.mainConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.mainConn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.mainConn.setTransactionIsolation(level);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.mainConn.setTypeMap(map);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DispatchPreparedStatementV2(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public void addWarning(String msg, String code) {
        this.mainConn.addWarning(msg, code);
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.mainConn.cancelQuery();
    }

    @Override
    public BaseResultSet execSQL(String s) throws SQLException {
        return this.mainConn.execSQL(s);
    }

    @Override
    public BaseResultSet execSQL(String s, BaseStatement stmt) throws SQLException {
        return this.mainConn.execSQL(s, stmt);
    }

    @Override
    public BaseResultSet execSQL(String s, BaseStatement stmt, BaseResultSet res) throws SQLException {
        return this.mainConn.execSQL(s, stmt, res);
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.mainConn.getCursorName();
    }

    @Override
    public Encoding getClientEncoding() {
        return this.mainConn.getClientEncoding();
    }

    @Override
    public void setClientEncoding(String encode) {
        this.mainConn.setClientEncoding(encode);
    }

    @Override
    public Encoding getEncoding() {
        return this.mainConn.getEncoding();
    }

    @Override
    public OSCARProtocol getProtocol() throws SQLException {
        return this.mainConn.getProtocol();
    }

    @Override
    public String getDBType(int oid) throws SQLException {
        return this.mainConn.getDBType(oid);
    }

    @Override
    public int getDBTypeOid(String DBTypeName) throws SQLException {
        return this.mainConn.getDBTypeOid(DBTypeName);
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.mainConn.getSQLType(oid);
    }

    @Override
    public int getOscarType(int oid) throws SQLException {
        return this.mainConn.getOscarType(oid);
    }

    @Override
    public int getSQLType(String DBTypeName) throws SQLException {
        return this.mainConn.getSQLType(DBTypeName);
    }

    @Override
    public void setCursorName(String cursor) throws SQLException {
        this.mainConn.setCursorName(cursor);
    }

    @Override
    public void addCursor(String cursorName) {
        this.mainConn.addCursor(cursorName);
    }

    @Override
    public void removePlanID(int index) {
        this.mainConn.removePlanID(index);
    }

    @Override
    public void addPlanID(byte[] planID) {
        this.mainConn.addPlanID(planID);
    }

    @Override
    public boolean hasCursor(String cursorName) {
        return this.mainConn.hasCursor(cursorName);
    }

    @Override
    public void removeCursor(String cursorName) {
        this.mainConn.removeCursor(cursorName);
    }

    @Override
    public OscarBlob getBlobInstance(String locatorStr) throws SQLException {
        return this.mainConn.getBlobInstance(locatorStr);
    }

    @Override
    public OscarBfile getBfileInstance(String locatorStr) throws SQLException {
        return this.mainConn.getBfileInstance(locatorStr);
    }

    @Override
    public OscarClob getClobInstance(String locatorStr) throws SQLException {
        return this.mainConn.getClobInstance(locatorStr);
    }

    @Override
    public BaseStatement getDefaultStatement() throws SQLException {
        return this.mainConn.getDefaultStatement();
    }

    @Override
    public void setInTranscation(boolean tran) {
        this.mainConn.setInTranscation(tran);
    }

    @Override
    public boolean isInTransaction() {
        return this.mainConn.isInTransaction();
    }

    @Override
    public int getPreapredCacheSize() {
        return this.mainConn.getPreapredCacheSize();
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        return this.mainConn.getFastpathAPI();
    }

    @Override
    public long getAccessHandle() {
        return this.mainConn.getAccessHandle();
    }

    @Override
    public void setSeed(long seed) {
        this.mainConn.setSeed(seed);
    }

    @Override
    public VersionConfig getVersion() {
        return this.mainConn.getVersion();
    }

    @Override
    public void setVersion(ProtocolVersion version) {
        this.mainConn.setVersion(version);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.mainConn.getProtocolVersion();
    }

    @Override
    public boolean isUsePrepareCache() {
        return this.mainConn.isUsePrepareCache();
    }

    @Override
    public boolean isCompatibleOracle() {
        return this.mainConn.isCompatibleOracle();
    }

    @Override
    public boolean isNotRealPrepare() {
        return this.mainConn.isNotRealPrepare();
    }

    @Override
    public void closeCursor(String cursorName, BaseStatement statement) throws SQLException {
        this.mainConn.closeCursor(cursorName, statement);
    }

    @Override
    public OSCARTransfer getTransfer() {
        return this.mainConn.getTransfer();
    }

    @Override
    public OscarBlob createTempBlob(boolean cache, int duration) throws SQLException {
        return this.mainConn.createTempBlob(cache, duration);
    }

    @Override
    public OscarClob createTempClob(boolean cache, int duration) throws SQLException {
        return this.mainConn.createTempClob(cache, duration);
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.mainConn.getQueryExecutor();
    }

    @Override
    public boolean isCompressTransfer() {
        return this.mainConn.isCompressTransfer();
    }

    @Override
    public void setCompressTransfer(boolean compressTransfer) {
        this.mainConn.setCompressTransfer(compressTransfer);
    }

    @Override
    public int getBatchBufferSize() {
        return this.mainConn.getBatchBufferSize();
    }

    @Override
    public void setBatchBufferSize(int defaultBatchBufferSize) {
        this.mainConn.setBatchBufferSize(defaultBatchBufferSize);
    }

    @Override
    public ImportHandler createImportHandler() throws SQLException {
        return this.mainConn.createImportHandler();
    }

    @Override
    public ImportHandler createImportHandler(String tableName) throws SQLException {
        return this.mainConn.createImportHandler(tableName);
    }

    @Override
    public ImportHandler createImportHandler(String schemName, String tableName) throws SQLException {
        return this.mainConn.createImportHandler(schemName, tableName);
    }

    @Override
    public ProviderImportHandler createProviderImportHandler(String tableName) throws SQLException {
        return this.mainConn.createProviderImportHandler(tableName);
    }

    @Override
    public ProviderImportHandler createProviderImportHandler(String schemName, String tableName) throws SQLException {
        return this.mainConn.createProviderImportHandler(schemName, tableName);
    }

    @Override
    public ExportHandler createExportHandler() throws SQLException {
        return this.mainConn.createExportHandler();
    }

    @Override
    public int getEndianType() {
        return this.mainConn.getEndianType();
    }

    @Override
    public void setEndianType(int type) {
        this.mainConn.setEndianType(type);
    }

    @Override
    public int checkPlanID(byte[] planID) {
        return this.mainConn.checkPlanID(planID);
    }

    @Override
    public Integer getSessionID() {
        return this.mainConn.getSessionID();
    }

    @Override
    public int getPlanID() {
        return this.mainConn.getPlanID();
    }

    @Override
    public boolean isNetDataByStr() {
        return this.mainConn.isNetDataByStr();
    }

    @Override
    public boolean isNumericKeepPrecision() {
        return this.mainConn.isNumericKeepPrecision();
    }

    @Override
    public boolean isPrepareSimpleExecute() {
        return this.mainConn.isPrepareSimpleExecute();
    }

    @Override
    public boolean isTcpKeepAlive() {
        return this.mainConn.isTcpKeepAlive();
    }

    @Override
    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.mainConn.setTcpKeepAlive(tcpKeepAlive);
    }

    @Override
    public boolean isValidate() {
        return this.mainConn.isValidate();
    }

    @Override
    public boolean isValidate(int timeout) {
        return this.mainConn.isValidate(timeout);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.mainConn.isValid(timeout);
    }

    @Override
    public boolean isValid() throws SQLException {
        return this.mainConn.isValid();
    }

    @Override
    public boolean isVerifyPoolConnection() {
        return this.mainConn.isVerifyPoolConnection();
    }

    @Override
    public int getBatchCount() {
        return this.mainConn.getBatchCount();
    }

    @Override
    public boolean isUseAsynBatch() {
        return this.mainConn.isUseAsynBatch();
    }

    @Override
    public boolean isReceiveStringByLen() {
        return this.mainConn.isReceiveStringByLen();
    }

    @Override
    public void setMasterConnection(Connection conn) {
    }

    @Override
    public Connection getMasterConnection() {
        return this.mainConn;
    }

    @Override
    public Properties getConnectionProperties() {
        return this.props;
    }

    @Override
    public void setTransStatus(int transStatus) {
        this.transStatus = transStatus;
    }

    @Override
    public int getTransStatus() {
        return this.transStatus;
    }

    public LsnVo getLsnVo() {
        if (this.isUseSlaveSyncReadGlobal()) {
            return globalLsnVo;
        }
        return threadLocalLsn.get();
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
    }

    public boolean isZeroResend() {
        return this.isResultSetZeroResend;
    }

    public boolean isUseSlaveSynRead() {
        return this.useSlaveSynRead;
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        if (paramClass.isAssignableFrom(this.getClass())) {
            return paramClass.cast(this);
        }
        throw new SQLException();
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return paramClass.isAssignableFrom(this.getClass());
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.mainConn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.mainConn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.mainConn.createSQLXML();
    }

    @Override
    public void setClientInfo(String paramString1, String paramString2) throws SQLClientInfoException {
        this.mainConn.setClientInfo(paramString1, paramString2);
    }

    @Override
    public void setClientInfo(Properties pro) throws SQLClientInfoException {
        this.mainConn.setClientInfo(pro);
    }

    @Override
    public String getClientInfo(String paramString) throws SQLException {
        return this.mainConn.getClientInfo(paramString);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.mainConn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String paramString, Object[] paramArrayOfObject) throws SQLException {
        return this.mainConn.createArrayOf(paramString, paramArrayOfObject);
    }

    @Override
    public Struct createStruct(String paramString, Object[] paramArrayOfObject) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public List<StatementEventListener> getStatementListeners() {
        return null;
    }

    @Override
    public PooledConnectionImpl getPc() {
        return null;
    }

    @Override
    public boolean checkDBLinkSql() {
        return false;
    }

    @Override
    public boolean sendBinaryTypeAsHex() {
        return this.mainConn.sendBinaryTypeAsHex();
    }

    @Override
    public DistributeImportHandler createDistributeImportHandler(String schemName, String tableName) throws SQLException {
        return this.mainConn.createDistributeImportHandler(schemName, tableName);
    }

    @Override
    public DistributeImportHandler createDistributeImportHandler(String tableName) throws SQLException {
        return this.mainConn.createDistributeImportHandler(tableName);
    }

    @Override
    public void setClusterImportNodeRetryTime(int time) {
        this.mainConn.setClusterImportNodeRetryTime(time);
    }

    @Override
    public int getClusterImportNodeRetryTime() {
        return this.mainConn.getClusterImportNodeRetryTime();
    }

    @Override
    public void setCluster(Cluster cluster) {
    }

    @Override
    public Cluster getCluster() {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.mainConn.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.mainConn.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.mainConn.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.mainConn.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.mainConn.getNetworkTimeout();
    }

    @Override
    public byte[] getHdSymEncryptKey() {
        return this.mainConn.getHdSymEncryptKey();
    }

    @Override
    public void setHdSymEncryptKey(byte[] key) {
        this.mainConn.setHdSymEncryptKey(key);
    }

    public String[] getDirectToMainArray() {
        return this.directToMainArray;
    }

    public String[] getDirectToSlaveArray() {
        return this.directToSlaveArray;
    }

    public boolean isUseSlaveSyncReadGlobal() {
        return this.useSlaveSyncReadGlobal;
    }

    public long getSlaveDelayTime() {
        return this.slaveDelayTime;
    }

    public boolean isDispatchAggFunction() {
        return this.dispatchAggBool;
    }

    @Override
    public Class<? extends OscarObject> getOscarObject(String type) {
        return this.mainConn.getOscarObject(type);
    }

    public boolean hasAvailableSlaveConnection() {
        return this.slaveCount > 0 && (this.fakeSlaveConnectionCount == 0 || this.fakeSlaveConnectionCount < this.slaveCount);
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Override
    public boolean enableCe() {
        return false;
    }

    @Override
    public Calendar getCalendar() {
        return this.mainConn.getCalendar();
    }
}

