/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.cluster;

import com.oscar.cluster.Cluster;
import com.oscar.cluster.core.ClusterProtocol;
import com.oscar.cluster.core.NodeProtocol;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.DistributeImportHandler;
import com.oscar.core.Encoding;
import com.oscar.core.ExportHandler;
import com.oscar.core.ImportHandler;
import com.oscar.core.ProviderImportHandler;
import com.oscar.core.QueryExecutor;
import com.oscar.fastpath.Fastpath;
import com.oscar.gis.OscarObject;
import com.oscar.jdbc.OSCARTransfer;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbcx.optional.PooledConnectionImpl;
import com.oscar.protocol.OSCARProtocol;
import com.oscar.protocol.Packet;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.protocol.packets.BasePacket;
import com.oscar.protocol.packets.CompleteResponsePacket;
import com.oscar.protocol.packets.ErrorResponsePacket;
import com.oscar.protocol.packets.NewImportPacket;
import com.oscar.protocol.packets.NoticeResponsePacket;
import com.oscar.protocol.packets.QueryPacket;
import com.oscar.protocol.packets.ReadyForQueryPacket;
import com.oscar.util.OSQLException;
import com.oscar.util.VersionConfig;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import javax.sql.StatementEventListener;

public class Protocol
implements ClusterProtocol,
NodeProtocol {
    protected Packet pk = new Packet();
    private Encoding encoding;
    private BaseConnection connection;

    public Protocol(Encoding encoding, BaseConnection connection) {
        this.encoding = encoding;
        this.connection = connection;
    }

    public Protocol(Encoding encoding) {
        this.encoding = encoding;
        this.connection = new FakeConnection();
    }

    @Override
    public void nodeImportEnd(InputStream in, OutputStream out) throws SQLException {
        BufferedOutputStream bfout = this.decorateStream(out);
        try {
            BasePacket.SendChar(bfout, 67);
            bfout.flush();
        }
        catch (Exception e) {
            throw new OSQLException("OSCAR-00804", "88888", 804, e);
        }
    }

    @Override
    public void sendImportCredential(int globalID, int identity, InputStream in, OutputStream out) throws SQLException {
        BufferedOutputStream bfout = this.decorateStream(out);
        try {
            BasePacket.SendChar(bfout, 82);
            BasePacket.SendInteger(bfout, globalID, 4);
            BasePacket.SendInteger(bfout, identity, 4);
            bfout.flush();
            BasePacket bk = this.getRespond(in);
            if (!(bk instanceof NewImportPacket)) {
                throw new OSQLException("OSCAR-00804", "88888", 804, "\u8282\u70b9\u8fd8\u672a\u51c6\u5907\u597d\uff0c\u53ef\u80fd\u7e41\u5fd9");
            }
        }
        catch (IOException e) {
            throw new OSQLException("OSCAR-00804", "88888", 804, e);
        }
    }

    @Override
    public void importData2Node(byte[] data, InputStream in, OutputStream out) throws SQLException {
        try {
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            throw new OSQLException("OSCAR-00804", "88888", 804, e);
        }
    }

    @Override
    public void importBegin(String insertBulk, InputStream in, OutputStream out) throws SQLException {
        try {
            BasePacket bk;
            byte[] data = this.encoding.encode(insertBulk);
            QueryPacket qp = new QueryPacket(data, 0);
            this.sendMessage(this.decorateStream(out), qp);
            BasePacket readyBk = null;
            do {
                if ((bk = this.getRespond(in)) instanceof NoticeResponsePacket) {
                    this.getMessage(in, bk);
                    continue;
                }
                if (bk instanceof NewImportPacket) {
                    this.getMessage(in, bk);
                    continue;
                }
                if (bk instanceof ErrorResponsePacket) {
                    this.getMessage(in, bk);
                    readyBk = this.getRespond(in);
                    while (!(readyBk instanceof ReadyForQueryPacket)) {
                        readyBk = this.getRespond(in);
                    }
                    ErrorResponsePacket errorPacket = (ErrorResponsePacket)bk;
                    throw new OSQLException(errorPacket.getErrorCode(), this.encoding.decode(errorPacket.getSQLState()), this.encoding.decode(errorPacket.getErrorMessage()));
                }
                throw new OSQLException("OSCAR-00109", "08003", 109);
            } while (!(bk instanceof NewImportPacket));
        }
        catch (IOException e) {
            throw new OSQLException("OSCAR-00804", "88888", 804, e);
        }
    }

    private BufferedOutputStream decorateStream(OutputStream out) {
        BufferedOutputStream bf = null;
        bf = out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out, 8192);
        return bf;
    }

    protected void sendMessage(BufferedOutputStream stream, BasePacket packet) throws IOException, SQLException {
        packet.sendTo(stream);
    }

    protected BasePacket getRespond(InputStream stream) throws IOException {
        byte[] tagTemp = new byte[1];
        stream.read(tagTemp, 0, 1);
        char tag = (char)tagTemp[0];
        return this.pk.getInstance(tag, this.connection);
    }

    protected void getMessage(InputStream stream, BasePacket packet) throws IOException, SQLException {
        packet.receiveFrom(stream);
    }

    @Override
    public int importEnd(InputStream in, OutputStream out) throws SQLException {
        try {
            BasePacket bk;
            BasePacket readyBk = null;
            int updateCount = 0;
            do {
                if ((bk = this.getRespond(in)) instanceof NoticeResponsePacket || bk instanceof NewImportPacket) {
                    this.getMessage(in, bk);
                    continue;
                }
                if (bk instanceof CompleteResponsePacket) {
                    this.getMessage(in, bk);
                    String command = this.connection.getEncoding().decode(((CompleteResponsePacket)bk).getCommand());
                    if (command.length() < 2) continue;
                    char tag1 = command.charAt(0);
                    char tag2 = command.charAt(1);
                    if (tag1 != '2' || tag2 != '1') continue;
                    updateCount = Integer.parseInt(command.substring(command.indexOf(32) + 1, command.lastIndexOf(32)));
                    continue;
                }
                if (bk instanceof ReadyForQueryPacket) {
                    this.getMessage(in, bk);
                    continue;
                }
                if (bk instanceof ErrorResponsePacket) {
                    this.getMessage(in, bk);
                    readyBk = this.getRespond(in);
                    while (!(readyBk instanceof ReadyForQueryPacket)) {
                        readyBk = this.getRespond(in);
                    }
                    ErrorResponsePacket errorPacket = (ErrorResponsePacket)bk;
                    throw new OSQLException(errorPacket.getErrorCode(), this.encoding.decode(errorPacket.getSQLState()), this.encoding.decode(errorPacket.getErrorMessage()));
                }
                throw new OSQLException("OSCAR-00109", "08003", 109);
            } while (!(bk instanceof ReadyForQueryPacket));
            return updateCount;
        }
        catch (IOException e) {
            throw new OSQLException("OSCAR-00804", "88888", 804, e);
        }
    }

    static class FakeConnection
    implements BaseConnection {
        FakeConnection() {
        }

        @Override
        public void addWarning(String msg, String code) {
        }

        @Override
        public void cancelQuery() throws SQLException {
        }

        @Override
        public Statement createStatement() throws SQLException {
            return null;
        }

        @Override
        public BaseResultSet execSQL(String s) throws SQLException {
            return null;
        }

        @Override
        public BaseResultSet execSQL(String s, BaseStatement stmt) throws SQLException {
            return null;
        }

        @Override
        public BaseResultSet execSQL(String s, BaseStatement stmt, BaseResultSet res) throws SQLException {
            return null;
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return false;
        }

        @Override
        public String getCursorName() throws SQLException {
            return null;
        }

        @Override
        public Encoding getClientEncoding() {
            return null;
        }

        @Override
        public void setClientEncoding(String encode) {
        }

        @Override
        public Encoding getEncoding() {
            return null;
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return null;
        }

        @Override
        public OSCARProtocol getProtocol() {
            return null;
        }

        @Override
        public String getDBType(int oid) throws SQLException {
            return null;
        }

        @Override
        public int getDBTypeOid(String DBTypeName) throws SQLException {
            return 0;
        }

        @Override
        public int getSQLType(int oid) throws SQLException {
            return 0;
        }

        @Override
        public int getOscarType(int oid) throws SQLException {
            return 0;
        }

        @Override
        public int getSQLType(String DBTypeName) throws SQLException {
            return 0;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
        }

        @Override
        public void setCursorName(String cursor) throws SQLException {
        }

        @Override
        public void addCursor(String cursorName) {
        }

        @Override
        public void removePlanID(int index) {
        }

        @Override
        public void addPlanID(byte[] planID) {
        }

        @Override
        public boolean hasCursor(String cursorName) {
            return false;
        }

        @Override
        public void removeCursor(String cursorName) {
        }

        @Override
        public OscarBlob getBlobInstance(String locatorStr) throws SQLException {
            return null;
        }

        @Override
        public OscarBfile getBfileInstance(String locatorStr) throws SQLException {
            return null;
        }

        @Override
        public OscarClob getClobInstance(String locatorStr) throws SQLException {
            return null;
        }

        @Override
        public BaseStatement getDefaultStatement() throws SQLException {
            return null;
        }

        @Override
        public void setInTranscation(boolean tran) {
        }

        @Override
        public boolean isInTransaction() {
            return false;
        }

        @Override
        public int getPreapredCacheSize() {
            return 0;
        }

        @Override
        public Fastpath getFastpathAPI() throws SQLException {
            return null;
        }

        @Override
        public long getAccessHandle() {
            return 0L;
        }

        @Override
        public void setSeed(long seed) {
        }

        @Override
        public VersionConfig getVersion() {
            return null;
        }

        @Override
        public void setVersion(ProtocolVersion version) {
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return null;
        }

        @Override
        public boolean isUsePrepareCache() {
            return false;
        }

        @Override
        public boolean isCompatibleOracle() {
            return false;
        }

        @Override
        public boolean isNotRealPrepare() {
            return false;
        }

        @Override
        public void closeCursor(String cursorName, BaseStatement statement) throws SQLException {
        }

        @Override
        public OSCARTransfer getTransfer() {
            return null;
        }

        @Override
        public OscarBlob createTempBlob(boolean cache, int duration) throws SQLException {
            return null;
        }

        @Override
        public OscarClob createTempClob(boolean cache, int duration) throws SQLException {
            return null;
        }

        @Override
        public QueryExecutor getQueryExecutor() {
            return null;
        }

        @Override
        public boolean isCompressTransfer() {
            return false;
        }

        @Override
        public void setCompressTransfer(boolean compressTransfer) {
        }

        @Override
        public int getBatchBufferSize() {
            return 0;
        }

        @Override
        public void setBatchBufferSize(int defaultBatchBufferSize) {
        }

        @Override
        public ImportHandler createImportHandler() throws SQLException {
            return null;
        }

        @Override
        public ImportHandler createImportHandler(String tableName) throws SQLException {
            return null;
        }

        @Override
        public ImportHandler createImportHandler(String schemName, String tableName) throws SQLException {
            return null;
        }

        @Override
        public ProviderImportHandler createProviderImportHandler(String tableName) throws SQLException {
            return null;
        }

        @Override
        public ProviderImportHandler createProviderImportHandler(String schemName, String tableName) throws SQLException {
            return null;
        }

        @Override
        public ExportHandler createExportHandler() throws SQLException {
            return null;
        }

        @Override
        public int getEndianType() {
            return 0;
        }

        @Override
        public void setEndianType(int type) {
        }

        @Override
        public int checkPlanID(byte[] planID) {
            return 0;
        }

        @Override
        public Integer getSessionID() {
            return null;
        }

        @Override
        public int getPlanID() {
            return 0;
        }

        @Override
        public boolean isNetDataByStr() {
            return false;
        }

        @Override
        public boolean isNumericKeepPrecision() {
            return false;
        }

        @Override
        public boolean isPrepareSimpleExecute() {
            return false;
        }

        @Override
        public boolean isTcpKeepAlive() {
            return false;
        }

        @Override
        public void setTcpKeepAlive(boolean tcpKeepAlive) {
        }

        @Override
        public boolean isValidate() {
            return false;
        }

        @Override
        public boolean isValidate(int timeout) {
            return false;
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return false;
        }

        @Override
        public boolean isValid() throws SQLException {
            return false;
        }

        @Override
        public boolean isVerifyPoolConnection() {
            return false;
        }

        @Override
        public int getBatchCount() {
            return 0;
        }

        @Override
        public boolean isUseAsynBatch() {
            return false;
        }

        @Override
        public boolean isReceiveStringByLen() {
            return false;
        }

        @Override
        public void setMasterConnection(Connection conn) {
        }

        @Override
        public Connection getMasterConnection() {
            return null;
        }

        @Override
        public Properties getConnectionProperties() {
            return null;
        }

        @Override
        public void setTransStatus(int transStatus) {
        }

        @Override
        public int getTransStatus() {
            return 0;
        }

        @Override
        public boolean isSlave() {
            return false;
        }

        @Override
        public void setIsSlave(boolean isSlave) {
        }

        public boolean isZeroResend() {
            return false;
        }

        public boolean isUseSlaveSynRead() {
            return false;
        }

        @Override
        public boolean checkDBLinkSql() {
            return false;
        }

        @Override
        public boolean sendBinaryTypeAsHex() {
            return false;
        }

        public boolean getIntWithPrecision() {
            return false;
        }

        @Override
        public DistributeImportHandler createDistributeImportHandler(String schemName, String tableName) throws SQLException {
            return null;
        }

        @Override
        public DistributeImportHandler createDistributeImportHandler(String tableName) throws SQLException {
            return null;
        }

        @Override
        public void setClusterImportNodeRetryTime(int time) {
        }

        @Override
        public int getClusterImportNodeRetryTime() {
            return 0;
        }

        @Override
        public PooledConnectionImpl getPc() {
            return null;
        }

        @Override
        public List<StatementEventListener> getStatementListeners() {
            return null;
        }

        @Override
        public void setCluster(Cluster cluster) {
        }

        @Override
        public Cluster getCluster() {
            return null;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return false;
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public byte[] getHdSymEncryptKey() {
            return null;
        }

        @Override
        public void setHdSymEncryptKey(byte[] key) {
        }

        @Override
        public Class<? extends OscarObject> getOscarObject(String type) {
            return null;
        }

        @Override
        public boolean enableCe() {
            return false;
        }

        @Override
        public Calendar getCalendar() {
            return Calendar.getInstance();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return null;
        }
    }
}

