/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.util.internal.NameUtils;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class Realm
implements Serializable,
Comparable<Realm> {
    private static final Map<String, Realm> KNOWN_REALMS = new LinkedHashMap<String, Realm>();
    private static final Map<String, Realm> ALLOY_REALMS = new LinkedHashMap<String, Realm>();
    private static final Map<String, Realm> ALL_REALMS = new LinkedHashMap<String, Realm>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Lock readLock = lock.readLock();
    private static final Lock writeLock = lock.writeLock();
    public static final Realm OC1 = new Realm("oc1", "oraclecloud.com");
    public static final Realm OC2 = new Realm("oc2", "oraclegovcloud.com");
    public static final Realm OC3 = new Realm("oc3", "oraclegovcloud.com");
    public static final Realm OC4 = new Realm("oc4", "oraclegovcloud.uk");
    public static final Realm OC8 = new Realm("oc8", "oraclecloud8.com");
    public static final Realm OC9 = new Realm("oc9", "oraclecloud9.com");
    public static final Realm OC10 = new Realm("oc10", "oraclecloud10.com");
    public static final Realm OC14 = new Realm("oc14", "oraclecloud14.com");
    public static final Realm OC20 = new Realm("oc20", "oraclecloud20.com");
    public static final Realm OC19 = new Realm("oc19", "oraclecloud.eu");
    public static final Realm OC24 = new Realm("oc24", "oraclecloud24.com");
    public static final Realm OC21 = new Realm("oc21", "oraclecloud21.com");
    public static final Realm OC26 = new Realm("oc26", "oraclecloud26.com");
    public static final Realm OC15 = new Realm("oc15", "oraclecloud15.com");
    public static final Realm OC29 = new Realm("oc29", "oraclecloud29.com");
    public static final Realm OC23 = new Realm("oc23", "oraclecloud23.com");
    private static final long serialVersionUID = -905344971L;
    private final String realmId;
    private final String secondLevelDomain;

    private Realm(@Nonnull String realmId, @Nonnull String secondLevelDomain) {
        this(realmId, secondLevelDomain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Realm(@Nonnull String realmId, @Nonnull String secondLevelDomain, boolean isAlloyRealm) {
        if (realmId == null) {
            throw new NullPointerException("realmId is marked non-null but is null");
        }
        if (secondLevelDomain == null) {
            throw new NullPointerException("secondLevelDomain is marked non-null but is null");
        }
        this.realmId = realmId;
        this.secondLevelDomain = secondLevelDomain;
        writeLock.lock();
        try {
            if (isAlloyRealm) {
                ALLOY_REALMS.put(NameUtils.canonicalizeForEnumTypes(realmId), this);
            } else {
                KNOWN_REALMS.put(NameUtils.canonicalizeForEnumTypes(realmId), this);
            }
            ALL_REALMS.put(NameUtils.canonicalizeForEnumTypes(realmId), this);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int compareTo(Realm other) {
        return this.realmId.compareTo(other.realmId);
    }

    public String toString() {
        return NameUtils.canonicalizeForEnumTypes(this.getRealmId());
    }

    public static Realm[] values() {
        readLock.lock();
        try {
            if (Alloy.doesAlloyConfigExist()) {
                if (Alloy.shouldUseOnlyAlloyRegions()) {
                    Realm[] realmArray = ALLOY_REALMS.values().toArray(new Realm[ALLOY_REALMS.size()]);
                    return realmArray;
                }
                Realm[] realmArray = ALL_REALMS.values().toArray(new Realm[ALL_REALMS.size()]);
                return realmArray;
            }
            Realm[] realmArray = KNOWN_REALMS.values().toArray(new Realm[KNOWN_REALMS.size()]);
            return realmArray;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Realm valueOf(@Nonnull String name) throws IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        readLock.lock();
        try {
            Optional<Realm> maybeRealm;
            if (Alloy.doesAlloyConfigExist()) {
                maybeRealm = Optional.ofNullable(ALLOY_REALMS.get(name));
                if (maybeRealm.isPresent()) {
                    Realm realm = maybeRealm.get();
                    return realm;
                }
                if (!Alloy.isAlloyRegionCoexistEnabled()) {
                    throw new IllegalArgumentException("Unknown realm " + name);
                }
            }
            if (!(maybeRealm = Optional.ofNullable(KNOWN_REALMS.get(name))).isPresent()) {
                throw new IllegalArgumentException("Unknown realm " + name);
            }
            Realm realm = maybeRealm.get();
            return realm;
        }
        finally {
            readLock.unlock();
        }
    }

    public static Realm register(@Nonnull String realmId, @Nonnull String secondLevelDomain) {
        return Realm.register(realmId, secondLevelDomain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm register(@Nonnull String realmId, @Nonnull String secondLevelDomain, boolean isAlloyRealm) {
        if (realmId == null) {
            throw new NullPointerException("realmId is marked non-null but is null");
        }
        if (secondLevelDomain == null) {
            throw new NullPointerException("secondLevelDomain is marked non-null but is null");
        }
        realmId = realmId.toLowerCase(Locale.US);
        secondLevelDomain = secondLevelDomain.toLowerCase(Locale.US);
        writeLock.lock();
        try {
            for (Realm realm : Realm.values()) {
                if (!realm.realmId.equals(realmId)) continue;
                if (!realm.secondLevelDomain.equals(secondLevelDomain)) {
                    throw new IllegalArgumentException("RealmId : " + realmId + " is already registered with " + realm.getSecondLevelDomain() + ". It cannot be re-registered with a different secondLevelDomain");
                }
                Realm realm2 = realm;
                return realm2;
            }
            Realm realm = new Realm(realmId, secondLevelDomain, isAlloyRealm);
            return realm;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Realm)) {
            return false;
        }
        Realm other = (Realm)o;
        String this$realmId = this.realmId;
        String other$realmId = other.realmId;
        if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) {
            return false;
        }
        String this$secondLevelDomain = this.secondLevelDomain;
        String other$secondLevelDomain = other.secondLevelDomain;
        return !(this$secondLevelDomain == null ? other$secondLevelDomain != null : !this$secondLevelDomain.equals(other$secondLevelDomain));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realmId = this.realmId;
        result = result * 59 + ($realmId == null ? 43 : $realmId.hashCode());
        String $secondLevelDomain = this.secondLevelDomain;
        result = result * 59 + ($secondLevelDomain == null ? 43 : $secondLevelDomain.hashCode());
        return result;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getSecondLevelDomain() {
        return this.secondLevelDomain;
    }

    @InternalSdk
    @VisibleForTesting
    protected static void clearAlloyRealms() {
        writeLock.lock();
        try {
            ALL_REALMS.keySet().removeIf(key -> ALLOY_REALMS.containsKey(key) && !KNOWN_REALMS.containsKey(key));
            ALLOY_REALMS.clear();
        }
        finally {
            writeLock.unlock();
        }
    }
}

