/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import java.util.Properties;
import oracle.net.url.common.Node;
import oracle.net.url.common.URLFormat;

public class URLParseResult {
    private final Node rootNode;
    private final Properties connectionProperties;
    private final URLFormat resolvedURLFormat;

    URLParseResult(Node rootNode, Properties connectionProperties, URLFormat resolvedURLFormat) {
        this.rootNode = rootNode;
        this.connectionProperties = connectionProperties;
        this.resolvedURLFormat = resolvedURLFormat;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String urlAsString() {
        return this.rootNode.toString();
    }

    public URLFormat getResolvedURLFormat() {
        return this.resolvedURLFormat;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Resolved URL Format : ").append((Object)this.resolvedURLFormat);
        if (this.rootNode != null) {
            result.append("\nRoot Node : ").append(this.rootNode);
        }
        if (this.connectionProperties != null && !this.connectionProperties.isEmpty()) {
            result.append("\nConnection Properties : ").append(this.connectionProperties);
        }
        return result.toString();
    }
}

