/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.jdbc.proxy.MethodSignature;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.GetProxy;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

class AnnotationsRegistry {
    private Map<Class<?>, Value> ifacesToAnnotatedSuperclasses = new IdentityHashMap();

    AnnotationsRegistry() {
    }

    void register(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) {
                throw SyntaxError.mustBeClass(clazz);
            }
            Value value = new Value(clazz);
            for (Class<?> iface : value.getIfacesToProxy()) {
                this.ifacesToAnnotatedSuperclasses.put(iface, value);
            }
        }
    }

    Value get(Class<?> iface) {
        if (null == iface) {
            return null;
        }
        return this.ifacesToAnnotatedSuperclasses.get(iface);
    }

    Set<Class<?>> keySet() {
        return this.ifacesToAnnotatedSuperclasses.keySet();
    }

    Collection<Value> values() {
        return this.ifacesToAnnotatedSuperclasses.values();
    }

    boolean containsKey(Object key) {
        return this.ifacesToAnnotatedSuperclasses.containsKey(key);
    }

    static class Value {
        private final Class<?> superclass;
        private final List<Class<?>> ifacesToProxy = new ArrayList();
        private final MethodSpecific.Pres pres = new MethodSpecific.Pres();
        private final MethodSpecific.VoidPosts voidPosts = new MethodSpecific.VoidPosts();
        private final MethodSpecific.ReturningPosts returningPosts = new MethodSpecific.ReturningPosts();
        private final MethodSpecific.VoidOnErrors voidOnErrors = new MethodSpecific.VoidOnErrors();
        private final MethodSpecific.ReturningOnErrors returningOnErrors = new MethodSpecific.ReturningOnErrors();
        private final Rest rest;
        private Method methodGetCreator = null;
        private Method methodGetDelegate = null;
        private Method methodGetProxy = null;
        private Method methodSetDelegate = null;
        private boolean isProxyLocale = false;
        private ProxyResultPolicy proxyResultPolicy = ProxyResultPolicy.CACHE;
        private Class<?> proxyAccessIface = null;
        private Method proxyAccessGetter = null;
        private Method proxyAccessSetter = null;
        private Method pre = null;
        private Method voidPost = null;
        private Method returningPost = null;
        private final Map<Class<?>, Method> voidOnErrorsMap = new IdentityHashMap();
        private final Map<Class<?>, Method> returningOnErrorsMap = new IdentityHashMap();
        private static final List<Class<? extends Annotation>> listOfMethodOperators = Arrays.asList(Pre.class, Post.class, OnError.class, GetCreator.class, GetDelegate.class, GetProxy.class, SetDelegate.class);

        Value(Class<?> superclass) {
            this.superclass = superclass;
            this.rest = this.parseAnnotations();
        }

        private void parseAnnotationTypeProxyResult() {
            if (this.superclass.isAnnotationPresent(ProxyResult.class)) {
                ProxyResult proxyResult = this.superclass.getAnnotation(ProxyResult.class);
                this.proxyResultPolicy = proxyResult.value();
            }
        }

        private void parseAnnotationProxyLocale() {
            if (this.superclass.isAnnotationPresent(ProxyLocale.class)) {
                this.isProxyLocale = true;
            }
        }

        private void parseAnnotationProxyFor() {
            if (this.superclass.isAnnotationPresent(ProxyFor.class)) {
                ProxyFor proxyFor = this.superclass.getAnnotation(ProxyFor.class);
                for (Class<?> clazz : proxyFor.value()) {
                    if (!clazz.isInterface()) {
                        throw SyntaxError.mustBeIface(clazz);
                    }
                    this.ifacesToProxy.add(clazz);
                }
            } else {
                throw SyntaxError.noProxyForClass(this.superclass);
            }
        }

        private boolean isProxyAccessGetter(Method method) {
            if (!Object.class.equals(method.getReturnType())) {
                return false;
            }
            if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                return false;
            }
            return Arrays.deepEquals(new Class[0], method.getExceptionTypes());
        }

        private boolean isProxyAccessSetter(Method method) {
            if (!Void.TYPE.equals(method.getReturnType())) {
                return false;
            }
            if (!Arrays.deepEquals(new Class[]{Object.class}, method.getParameterTypes())) {
                return false;
            }
            return Arrays.deepEquals(new Class[0], method.getExceptionTypes());
        }

        private void parseAnnotationProxyAccess() {
            if (this.superclass.isAnnotationPresent(ProxyAccess.class)) {
                this.proxyAccessIface = this.superclass.getAnnotation(ProxyAccess.class).value();
                if (!this.proxyAccessIface.isInterface()) {
                    throw SyntaxError.mustBeIface(this.proxyAccessIface);
                }
                if (0 != this.proxyAccessIface.getInterfaces().length) {
                    throw SyntaxError.mustNotImplementIfaces(this.proxyAccessIface);
                }
                Method[] methods = this.proxyAccessIface.getMethods();
                if (2 != methods.length) {
                    throw SyntaxError.wrongProxyAccessIface(this.proxyAccessIface);
                }
                if (this.isProxyAccessGetter(methods[0]) && this.isProxyAccessSetter(methods[1])) {
                    this.proxyAccessGetter = methods[0];
                    this.proxyAccessSetter = methods[1];
                } else if (this.isProxyAccessGetter(methods[1]) && this.isProxyAccessSetter(methods[0])) {
                    this.proxyAccessGetter = methods[1];
                    this.proxyAccessSetter = methods[0];
                } else {
                    throw SyntaxError.wrongProxyAccessIface(this.proxyAccessIface);
                }
            }
        }

        private void checkIsSingle(Method method, Class<?> operator) {
            for (Class<? extends Annotation> op : listOfMethodOperators) {
                if (op.equals(operator) || !method.isAnnotationPresent(op)) continue;
                throw SyntaxError.onlyOneAllowed;
            }
        }

        private void parseAnnotationPre(Method method) {
            if (method.isAnnotationPresent(Pre.class)) {
                this.checkIsSingle(method, Pre.class);
                if (!Arrays.deepEquals(new Class[]{Method.class, Object.class, Object[].class}, method.getParameterTypes())) {
                    throw SyntaxError.wrongPre;
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongPre;
                }
                if (method.isAnnotationPresent(Methods.class)) {
                    for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                        this.pres.put(new MethodSignature(signature.name(), signature.args()), method);
                    }
                } else {
                    if (null != this.pre) {
                        throw SyntaxError.onlyOneMethodslessAllowed;
                    }
                    this.pre = method;
                }
            }
        }

        private Class<?> doAutoBoxing(Class<?> clazz) {
            if (Boolean.TYPE.equals(clazz)) {
                return Boolean.class;
            }
            if (Character.TYPE.equals(clazz)) {
                return Character.class;
            }
            if (Byte.TYPE.equals(clazz)) {
                return Byte.class;
            }
            if (Short.TYPE.equals(clazz)) {
                return Short.class;
            }
            if (Integer.TYPE.equals(clazz)) {
                return Integer.class;
            }
            if (Long.TYPE.equals(clazz)) {
                return Long.class;
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.class;
            }
            if (Double.TYPE.equals(clazz)) {
                return Double.class;
            }
            return clazz;
        }

        private void checkReturnTypesMismatch(MethodSignature methodSignature, Method methodInterceptor) {
            Method methodInterceptee = null;
            Class<?> interceptorReturnType = this.doAutoBoxing(methodInterceptor.getReturnType());
            for (Class<?> iface : this.getIfacesToProxy()) {
                try {
                    methodInterceptee = iface.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes());
                    Class<?> intercepteeReturnType = this.doAutoBoxing(methodInterceptee.getReturnType());
                    if (Void.TYPE.equals(intercepteeReturnType) || intercepteeReturnType.isAssignableFrom(interceptorReturnType)) continue;
                    throw new RuntimeException("method \"" + methodSignature.getName() + "(" + Arrays.toString(methodSignature.getParameterTypes()) + ")\", interceptor \"" + String.valueOf(methodInterceptor.getDeclaringClass()) + "." + methodInterceptor.getName() + "\": non-assignable return types: \"" + String.valueOf(intercepteeReturnType) + "\" and \"" + String.valueOf(interceptorReturnType) + "\"");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }

        private void checkReturnTypesMismatch(Method methodInterceptor) {
            Class<?> interceptorReturnType = this.doAutoBoxing(methodInterceptor.getReturnType());
            for (Class<?> iface : this.getIfacesToProxy()) {
                for (Method methodInterceptee : iface.getDeclaredMethods()) {
                    Class<?> intercepteeReturnType = this.doAutoBoxing(methodInterceptee.getReturnType());
                    if (Void.TYPE.equals(intercepteeReturnType)) continue;
                    try {
                        intercepteeReturnType.asSubclass(interceptorReturnType);
                    }
                    catch (ClassCastException e) {
                        throw SyntaxError.returnTypeMismatch(methodInterceptor, methodInterceptee);
                    }
                }
            }
        }

        private void parseAnnotationPost(Method method) {
            if (method.isAnnotationPresent(Post.class)) {
                this.checkIsSingle(method, Post.class);
                Class<?> returnType = method.getReturnType();
                Object[] parameterTypes = method.getParameterTypes();
                Class<?>[] exceptionTypes = method.getExceptionTypes();
                if (Void.TYPE.equals(returnType) && Arrays.deepEquals(new Class[]{Method.class}, parameterTypes)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            this.voidPosts.put(new MethodSignature(signature.name(), signature.args()), method);
                        }
                    } else {
                        if (null != this.voidPost) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                        this.voidPost = method;
                    }
                } else if (!Void.TYPE.equals(returnType) && Arrays.deepEquals(new Class[]{Method.class, returnType}, parameterTypes)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args());
                            this.checkReturnTypesMismatch(methodSignature, method);
                            this.returningPosts.put(methodSignature, method);
                        }
                    } else {
                        this.checkReturnTypesMismatch(method);
                        if (null != this.returningPost) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                        this.returningPost = method;
                    }
                } else {
                    throw SyntaxError.wrongPost;
                }
            }
        }

        private void parseAnnotationOnError(Method method) {
            if (method.isAnnotationPresent(OnError.class)) {
                this.checkIsSingle(method, OnError.class);
                Class<?> returnType = method.getReturnType();
                Object[] parameterTypes = method.getParameterTypes();
                Object[] exceptionTypes = method.getExceptionTypes();
                OnError onError = method.getAnnotation(OnError.class);
                Class<?> exceptionClass = onError.value();
                if (Arrays.deepEquals(new Class[]{Method.class, exceptionClass}, parameterTypes) && Arrays.deepEquals(new Class[]{exceptionClass}, exceptionTypes) && Void.TYPE.equals(returnType)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args());
                            IdentityHashMap onErrorsMap = (IdentityHashMap)this.voidOnErrors.get(methodSignature);
                            if (null == onErrorsMap) {
                                onErrorsMap = new IdentityHashMap();
                                this.voidOnErrors.put(methodSignature, onErrorsMap);
                            }
                            if (null == onErrorsMap.put(exceptionClass, method)) continue;
                            throw SyntaxError.onlyOneOnErrorExceptionTypeAllowed;
                        }
                    } else if (null != this.voidOnErrorsMap.put(exceptionClass, method)) {
                        throw SyntaxError.onlyOneMethodslessAllowed;
                    }
                } else if (Arrays.deepEquals(new Class[]{Method.class, exceptionClass}, parameterTypes) && Arrays.deepEquals(new Class[]{exceptionClass}, exceptionTypes) && !Void.TYPE.equals(returnType)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args());
                            this.checkReturnTypesMismatch(methodSignature, method);
                            IdentityHashMap onErrorsMap = (IdentityHashMap)this.returningOnErrors.get(methodSignature);
                            if (null == onErrorsMap) {
                                onErrorsMap = new IdentityHashMap();
                                this.returningOnErrors.put(methodSignature, onErrorsMap);
                            }
                            if (null == onErrorsMap.put(exceptionClass, method)) continue;
                            throw SyntaxError.onlyOneOnErrorExceptionTypeAllowed;
                        }
                    } else {
                        this.checkReturnTypesMismatch(method);
                        if (null != this.returningOnErrorsMap.put(exceptionClass, method)) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                    }
                } else {
                    throw SyntaxError.wrongOnError;
                }
            }
        }

        private void parseAnnotationGetCreator(Method method) {
            if (method.isAnnotationPresent(GetCreator.class)) {
                this.checkIsSingle(method, GetCreator.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongGetCreatorMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongGetCreatorMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                    throw SyntaxError.wrongGetCreator;
                }
                if (!Object.class.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetCreator;
                }
                this.methodGetCreator = method;
            }
        }

        private void parseAnnotationGetProxy(Method method) {
            if (method.isAnnotationPresent(GetProxy.class)) {
                this.checkIsSingle(method, GetProxy.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongGetProxyMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongGetProxyMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[]{Object.class, Object.class}, method.getParameterTypes())) {
                    throw SyntaxError.wrongGetProxy;
                }
                if (!Object.class.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetProxy;
                }
                this.methodGetProxy = method;
            }
        }

        private void parseAnnotationGetDelegate(Method method) {
            if (method.isAnnotationPresent(GetDelegate.class)) {
                this.checkIsSingle(method, GetDelegate.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongGetDelegateMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongGetDelegateMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                    throw new SyntaxError("wrong @GetDelegate");
                }
                if (Void.TYPE.equals(method.getReturnType())) {
                    throw new SyntaxError("wrong @GetDelegate");
                }
                boolean[] assignable = new boolean[]{false};
                this.getIfacesToProxy().forEach(p -> {
                    if (method.getReturnType().isAssignableFrom((Class<?>)p)) {
                        assignable[0] = true;
                    }
                });
                if (!assignable[0]) {
                    throw new SyntaxError("GetDelegate declared to be not assignable to declared interface in proxyFor()");
                }
                this.methodGetDelegate = method;
            }
        }

        private void parseAnnotationSetDelegate(Method method) {
            if (method.isAnnotationPresent(SetDelegate.class)) {
                this.checkIsSingle(method, SetDelegate.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongSetDelegateMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongSetDelegateMustBeAbstract;
                }
                if (1 != method.getParameterTypes().length) {
                    throw SyntaxError.wrongSetDelegate;
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongSetDelegate;
                }
                this.methodSetDelegate = method;
            }
        }

        private Rest parseAnnotations() {
            this.parseAnnotationProxyFor();
            this.parseAnnotationProxyAccess();
            this.parseAnnotationProxyLocale();
            this.parseAnnotationTypeProxyResult();
            for (Method method : this.superclass.getDeclaredMethods()) {
                this.parseAnnotationPre(method);
                this.parseAnnotationPost(method);
                this.parseAnnotationOnError(method);
                this.parseAnnotationGetCreator(method);
                this.parseAnnotationGetProxy(method);
                this.parseAnnotationGetDelegate(method);
                this.parseAnnotationSetDelegate(method);
            }
            if (null != this.proxyAccessIface) {
                for (Class clazz : this.ifacesToProxy) {
                    try {
                        clazz.asSubclass(this.proxyAccessIface);
                    }
                    catch (ClassCastException e) {
                        throw SyntaxError.mustExtendProxyAccessIface(clazz, this.proxyAccessIface);
                    }
                }
            }
            return new Rest(this.pre, this.voidPost, this.returningPost, this.voidOnErrorsMap, this.returningOnErrorsMap);
        }

        boolean belongsToIfaceToProxy(Class<?> ifaceToProxy, MethodSignature methodSignature) {
            for (Class<?> iface : this.ifacesToProxy) {
                try {
                    ifaceToProxy.asSubclass(iface);
                    if (!this.isMethodDeclared(iface, methodSignature)) continue;
                    return true;
                }
                catch (ClassCastException classCastException) {
                }
            }
            return false;
        }

        private boolean isMethodDeclared(Class<?> iface, MethodSignature methodSignature) {
            try {
                if (null != iface.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes())) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            for (Class<?> subiface : iface.getInterfaces()) {
                if (!this.isMethodDeclared(subiface, methodSignature)) continue;
                return true;
            }
            return false;
        }

        Method getMethodPre(Class<?> ifaceToProxy, MethodSignature methodSignature) {
            Objects.requireNonNull(ifaceToProxy);
            Objects.requireNonNull(methodSignature);
            Method methodSpecificPre = (Method)this.pres.get(methodSignature);
            if (Objects.nonNull(methodSpecificPre)) {
                return methodSpecificPre;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getPre() : null;
        }

        Method getMethodVoidPost(Class<?> ifaceToProxy, MethodSignature methodSignature) {
            Method methodSpecificVoidPost = (Method)this.voidPosts.get(methodSignature);
            if (null != methodSpecificVoidPost) {
                return methodSpecificVoidPost;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getVoidPost() : null;
        }

        Method getMethodReturningPost(Class<?> ifaceToProxy, MethodSignature methodSignature) {
            Method methodSpecificReturningPost = (Method)this.returningPosts.get(methodSignature);
            if (null != methodSpecificReturningPost) {
                return methodSpecificReturningPost;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getReturningPost() : null;
        }

        Map<Class<?>, Method> getMapVoidOnError(Class<?> ifaceToProxy, MethodSignature methodSignature) {
            Map methodSpecificVoidOnErrorsMap = (Map)this.voidOnErrors.get(methodSignature);
            if (null != methodSpecificVoidOnErrorsMap) {
                return methodSpecificVoidOnErrorsMap;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getVoidOnError() : null;
        }

        Map<Class<?>, Method> getMapReturningOnError(Class<?> ifaceToProxy, MethodSignature methodSignature) {
            Map methodSpecificReturningOnErrorsMap = (Map)this.returningOnErrors.get(methodSignature);
            if (null != methodSpecificReturningOnErrorsMap) {
                return methodSpecificReturningOnErrorsMap;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getReturningOnError() : null;
        }

        Method getMethodGetCreator() {
            return this.methodGetCreator;
        }

        Method getMethodGetDelegate() {
            return this.methodGetDelegate;
        }

        Method getMethodGetProxy() {
            return this.methodGetProxy;
        }

        Method getMethodSetDelegate() {
            return this.methodSetDelegate;
        }

        List<Class<?>> getIfacesToProxy() {
            return this.ifacesToProxy;
        }

        Class<?> getSuperclass() {
            return this.superclass;
        }

        boolean isProxyLocale() {
            return this.isProxyLocale;
        }

        ProxyResultPolicy getProxyResultPolicy() {
            return this.proxyResultPolicy;
        }

        ProxyResultPolicy getProxyResultPolicy(Method m) {
            Method method;
            try {
                method = this.superclass.getDeclaredMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return this.proxyResultPolicy;
            }
            if (method.isAnnotationPresent(ProxyResult.class)) {
                ProxyResult proxyResult = method.getAnnotation(ProxyResult.class);
                return proxyResult.value();
            }
            return this.proxyResultPolicy;
        }

        Class<?> getProxyAccessIface() {
            return this.proxyAccessIface;
        }

        Method getProxyAccessGetter() {
            return this.proxyAccessGetter;
        }

        Method getProxyAccessSetter() {
            return this.proxyAccessSetter;
        }

        private static class Rest {
            private final Method pre;
            private final Method voidPost;
            private final Method returningPost;
            private final Map<Class<?>, Method> voidOnErrorsMap;
            private final Map<Class<?>, Method> returningOnErrorsMap;

            Rest(Method pre, Method voidPost, Method returningPost, Map<Class<?>, Method> voidOnErrorsMap, Map<Class<?>, Method> returningOnErrorsMap) {
                this.pre = pre;
                this.voidPost = voidPost;
                this.returningPost = returningPost;
                this.voidOnErrorsMap = voidOnErrorsMap;
                this.returningOnErrorsMap = returningOnErrorsMap;
            }

            Method getPre() {
                return this.pre;
            }

            Map<Class<?>, Method> getReturningOnError() {
                return this.returningOnErrorsMap;
            }

            Method getReturningPost() {
                return this.returningPost;
            }

            Map<Class<?>, Method> getVoidOnError() {
                return this.voidOnErrorsMap;
            }

            Method getVoidPost() {
                return this.voidPost;
            }
        }

        private static class MethodSpecific<T> {
            private final Map<MethodSignature, T> ref = new HashMap<MethodSignature, T>();
            private final String annotationType;

            private MethodSpecific(String annotationType) {
                this.annotationType = annotationType;
            }

            void put(MethodSignature methodSignature, T t) {
                if (null != this.ref.put(methodSignature, t)) {
                    throw SyntaxError.annotationDefinedMoreThanOnce(this.annotationType, methodSignature.getName());
                }
            }

            T get(MethodSignature methodSignature) {
                return this.ref.get(methodSignature);
            }

            public String toString() {
                return "annotationType=" + this.annotationType + ", ref=" + this.ref;
            }

            static final class ReturningOnErrors
            extends MethodSpecific<Map<Class<?>, Method>> {
                ReturningOnErrors() {
                    super("Returning @OnError");
                }
            }

            static final class VoidOnErrors
            extends MethodSpecific<Map<Class<?>, Method>> {
                VoidOnErrors() {
                    super("Void @OnError");
                }
            }

            static final class ReturningPosts
            extends MethodSpecific<Method> {
                ReturningPosts() {
                    super("Returning @Post");
                }
            }

            static final class VoidPosts
            extends MethodSpecific<Method> {
                VoidPosts() {
                    super("Void @Post");
                }
            }

            static final class Pres
            extends MethodSpecific<Method> {
                Pres() {
                    super("@Pre");
                }
            }
        }
    }

    private static class SyntaxError
    extends RuntimeException {
        private static final long serialVersionUID = 4343640747507L;
        private static final SyntaxError onlyOneAllowed = new SyntaxError("only one @Pre/@Post/@OnError/@GetDelegate/@SetDelegate/@GetCreator/@GetProxy allowed");
        private static final SyntaxError onlyOneMethodslessAllowed = new SyntaxError("only one @Methods-less @Pre/@Post/@OnError allowed");
        private static final SyntaxError wrongMethodsContext = new SyntaxError("wrong context for @Methods");
        private static final SyntaxError wrongPre = new SyntaxError("wrong @Pre");
        private static final SyntaxError wrongPost = new SyntaxError("wrong @Post");
        private static final SyntaxError wrongOnError = new SyntaxError("wrong @OnError");
        private static final SyntaxError onlyOneOnErrorExceptionTypeAllowed = new SyntaxError("only one @OnError Exception type allowed for a given method");
        private static final SyntaxError wrongGetCreator = new SyntaxError("wrong @GetCreator");
        private static final SyntaxError wrongGetCreatorMustBeProtected = new SyntaxError("wrong @GetCreator: must be protected");
        private static final SyntaxError wrongGetCreatorMustBeAbstract = new SyntaxError("wrong @GetCreator: must be abstract");
        private static final SyntaxError wrongGetDelegate = new SyntaxError("wrong @GetDelegate");
        private static final SyntaxError wrongGetDelegateMustBeProtected = new SyntaxError("wrong @GetDelegate: must be protected");
        private static final SyntaxError wrongGetDelegateMustBeAbstract = new SyntaxError("wrong @GetDelegate: must be abstract");
        private static final SyntaxError wrongGetProxy = new SyntaxError("wrong @GetProxy");
        private static final SyntaxError wrongGetProxyMustBeProtected = new SyntaxError("wrong @GetProxy: must be protected");
        private static final SyntaxError wrongGetProxyMustBeAbstract = new SyntaxError("wrong @GetProxy: must be abstract");
        private static final SyntaxError wrongSetDelegate = new SyntaxError("wrong @SetDelegate");
        private static final SyntaxError wrongSetDelegateMustBeProtected = new SyntaxError("wrong @SetDelegate: must be protected");
        private static final SyntaxError wrongSetDelegateMustBeAbstract = new SyntaxError("wrong @SetDelegate: must be abstract");

        SyntaxError(String message) {
            super(message);
        }

        private static SyntaxError mustBeClass(Class<?> clazz) {
            return new SyntaxError(clazz.getName() + " must be an abstract or concrete class");
        }

        private static SyntaxError mustBeIface(Class<?> clazz) {
            return new SyntaxError(clazz.getName() + " must be an interface");
        }

        private static SyntaxError mustNotImplementIfaces(Class<?> clazz) {
            return new SyntaxError(clazz.getName() + " must not implement interfaces");
        }

        private static SyntaxError wrongProxyAccessIface(Class<?> clazz) {
            return new SyntaxError(clazz.getName() + " wrong @ProxyAccess argument.  Must contain an interface with a simple getter and a simple setter and nothing else, like:\npublic interface Proxyable<T> {\n  void setProxy(T proxy);\n  T getProxy();\n}");
        }

        private static SyntaxError annotationDefinedMoreThanOnce(String annotation, String name) {
            return new SyntaxError(annotation + " is defined more than once for the " + name + " method");
        }

        private static SyntaxError mustExtendProxyAccessIface(Class<?> ifaceToProxy, Class<?> proxyAccessIface) {
            return new SyntaxError(ifaceToProxy.getName() + " must extends @ProxyAccess interface " + proxyAccessIface.getName());
        }

        private static SyntaxError noProxyForClass(Class<?> clazz) {
            return new SyntaxError("no @ProxyFor for class " + clazz.getName());
        }

        private static SyntaxError returnTypeMismatch(Method methodInterceptor, Method methodInterceptee) {
            return new SyntaxError("interceptor " + methodInterceptor.getName() + " and interceptee " + methodInterceptee.getName() + ": have different return types (" + methodInterceptor.getReturnType().getName() + " and " + methodInterceptee.getReturnType().getName() + ")");
        }
    }
}

