/*
 * Decompiled with CFR 0.152.
 */
package com.oppo.push.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.oppo.push.server.Auth;
import com.oppo.push.server.Constants;
import com.oppo.push.server.RequestPath;
import com.oppo.push.server.Result;
import com.oppo.push.server.ReturnCode;
import com.oppo.push.server.Sender;
import com.oppo.push.server.Validate;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

class HttpClientTool {
    private static PoolingHttpClientConnectionManager manager = null;
    private static Charset charset = Consts.UTF_8;

    HttpClientTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void init() throws Exception {
        if (manager != null) return;
        Class<PoolingHttpClientConnectionManager> clazz = PoolingHttpClientConnectionManager.class;
        synchronized (PoolingHttpClientConnectionManager.class) {
            if (manager != null) return;
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            SSLConnectionSocketFactory ssl = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register(Constants.HTTP_PROTOCOL, (Object)ssl).build();
            manager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            manager.setMaxTotal(Constants.HTTP_MAX_CONNECTION);
            manager.setDefaultMaxPerRoute(Constants.HTTP_MAX_ROUTE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getResponse(CloseableHttpResponse response) {
        String result = null;
        try {
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (Charset)charset);
            if (result == null || result.trim().length() == 0) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = JSON.parseObject((String)result);
            return jSONObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)result);
            jsonObject.put("code", (Object)ReturnCode.ErrorCode.RESPONSE_PARSE_ERROR.getCode());
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static List<NameValuePair> buildNameValuePairsParameters(Map<String, Object> params) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(param.getKey(), param.getValue() + ""));
        }
        return nameValuePairs;
    }

    static Result httpPostWithToken(RequestPath path, Map<String, Object> parameters, Sender sender) throws Exception {
        Result tryGetToken;
        Result result = HttpClientTool.httpPost(path, parameters);
        if (result != null && result.getReturnCode() != null && result.getReturnCode().getCode() == ReturnCode.ErrorCode.INVALID_AUTH_TOKEN.getCode() && (tryGetToken = Auth.getAuthResult(sender.getAppKey(), sender.getMasterSecret())) != null && !Validate.isEmpty(tryGetToken.getToken())) {
            sender.setToken(tryGetToken.getToken());
            sender.setCreateTime(tryGetToken.getCreateTime());
            parameters.put("auth_token", tryGetToken.getToken());
            result = HttpClientTool.httpPost(path, parameters);
        }
        return result;
    }

    static Result multipartHttpPostWithToken(RequestPath path, Map<String, Object> parameters, File uploadFile, Sender sender) throws Exception {
        Result tryGetToken;
        Result result = HttpClientTool.multipartHttpPost(path, parameters, uploadFile);
        if (result != null && result.getReturnCode() != null && result.getReturnCode().getCode() == ReturnCode.ErrorCode.INVALID_AUTH_TOKEN.getCode() && (tryGetToken = Auth.getAuthResult(sender.getAppKey(), sender.getMasterSecret())) != null && !Validate.isEmpty(tryGetToken.getToken())) {
            sender.setToken(tryGetToken.getToken());
            sender.setCreateTime(tryGetToken.getCreateTime());
            result = HttpClientTool.multipartHttpPost(path, parameters, uploadFile);
        }
        return result;
    }

    static Result httpPost(RequestPath path, Map<String, Object> parameters) throws Exception {
        HttpPost httpPost = new HttpPost(HttpClientTool.getUrl(path));
        parameters.put("sdk_version", "JAVA_SDK_V1.0.0");
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpClientTool.buildNameValuePairsParameters(parameters), charset));
        CloseableHttpResponse response = HttpClientTool.execute((HttpUriRequest)httpPost);
        Result result = new Result();
        if (response.getStatusLine() != null) {
            result.setStatusCode(response.getStatusLine().getStatusCode());
            result.setReason(response.getStatusLine().getReasonPhrase());
        }
        JSONObject responseBody = HttpClientTool.getResponse(response);
        result.setResult(path, responseBody);
        return result;
    }

    static Result multipartHttpPost(RequestPath path, Map<String, Object> parameters, File file) throws Exception {
        HttpPost httpPost = new HttpPost(HttpClientTool.getMediaUrl(path));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(charset);
        builder.addTextBody("auth_token", String.valueOf(parameters.get("auth_token")), ContentType.TEXT_PLAIN);
        builder.addTextBody("picture_ttl", String.valueOf(parameters.get("picture_ttl")), ContentType.TEXT_PLAIN);
        builder.addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.MULTIPART_FORM_DATA, file.getName());
        httpPost.setEntity(builder.build());
        CloseableHttpResponse response = HttpClientTool.execute((HttpUriRequest)httpPost);
        Result result = new Result();
        if (response.getStatusLine() != null) {
            result.setStatusCode(response.getStatusLine().getStatusCode());
            result.setReason(response.getStatusLine().getReasonPhrase());
        }
        JSONObject responseBody = HttpClientTool.getResponse(response);
        result.setResult(path, responseBody);
        return result;
    }

    private static CloseableHttpResponse execute(HttpUriRequest request) throws Exception {
        CloseableHttpResponse response;
        try {
            response = HttpClientTool.getSSLClient().execute(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return response;
    }

    private static CloseableHttpClient getSSLClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }

    private static String getUrl(RequestPath path) {
        return String.format("https://%s%s%s%s", Constants.HOST_PRODUCTION_CHINA, RequestPath.BASE_PATH.getPath(), RequestPath.VERSION_PATH.getPath(), path.getPath());
    }

    private static String getMediaUrl(RequestPath path) {
        return String.format("https://%s%s%s%s", Constants.MEDIA_HOST_PRODUCTION_CHINA, RequestPath.BASE_PATH.getPath(), RequestPath.VERSION_PATH.getPath(), path.getPath());
    }
}

