/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.ConfigurationUtil;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.impl.LocatableFactory;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.config.providers.XmlHelper;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ClassPathFinder;
import com.opensymphony.xwork2.util.DomHelper;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationUtils;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfigurationProvider.class);
    private List<Document> documents;
    private Set<String> includedFileNames;
    private String configFileName;
    private ObjectFactory objectFactory;
    private Set<String> loadedFileUrls = new HashSet<String>();
    private boolean errorIfMissing;
    private Map<String, String> dtdMappings;
    private Configuration configuration;
    private boolean throwExceptionOnDuplicateBeans = true;

    public XmlConfigurationProvider() {
        this("xwork.xml", true);
    }

    public XmlConfigurationProvider(String filename) {
        this(filename, true);
    }

    public XmlConfigurationProvider(String filename, boolean errorIfMissing) {
        this.configFileName = filename;
        this.errorIfMissing = errorIfMissing;
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("-//OpenSymphony Group//XWork 2.0//EN", "xwork-2.0.dtd");
        mappings.put("-//OpenSymphony Group//XWork 1.1.1//EN", "xwork-1.1.1.dtd");
        mappings.put("-//OpenSymphony Group//XWork 1.1//EN", "xwork-1.1.dtd");
        mappings.put("-//OpenSymphony Group//XWork 1.0//EN", "xwork-1.0.dtd");
        this.setDtdMappings(mappings);
    }

    public void setThrowExceptionOnDuplicateBeans(boolean val) {
        this.throwExceptionOnDuplicateBeans = val;
    }

    public void setDtdMappings(Map<String, String> mappings) {
        this.dtdMappings = Collections.unmodifiableMap(mappings);
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public Map<String, String> getDtdMappings() {
        return this.dtdMappings;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.includedFileNames = configuration.getLoadedFileNames();
        this.loadDocuments(this.configFileName);
    }

    @Override
    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlConfigurationProvider)) {
            return false;
        }
        XmlConfigurationProvider xmlConfigurationProvider = (XmlConfigurationProvider)o;
        return !(this.configFileName != null ? !this.configFileName.equals(xmlConfigurationProvider.configFileName) : xmlConfigurationProvider.configFileName != null);
    }

    public int hashCode() {
        return this.configFileName != null ? this.configFileName.hashCode() : 0;
    }

    private void loadDocuments(String configFileName) {
        try {
            this.loadedFileUrls.clear();
            this.documents = this.loadConfigurationFiles(configFileName, null);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration file " + configFileName, e);
        }
    }

    @Override
    public void register(ContainerBuilder containerBuilder, LocatableProperties props) throws ConfigurationException {
        LOG.info("Parsing configuration file [" + this.configFileName + "]", new String[0]);
        HashMap<String, Element> loadedBeans = new HashMap<String, Element>();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element child = (Element)childNode;
                String nodeName = child.getNodeName();
                if (nodeName.equals("bean")) {
                    String type = child.getAttribute("type");
                    String name = child.getAttribute("name");
                    String impl = child.getAttribute("class");
                    String onlyStatic = child.getAttribute("static");
                    String scopeStr = child.getAttribute("scope");
                    boolean optional = "true".equals(child.getAttribute("optional"));
                    Scope scope = Scope.SINGLETON;
                    if ("default".equals(scopeStr)) {
                        scope = Scope.DEFAULT;
                    } else if ("request".equals(scopeStr)) {
                        scope = Scope.REQUEST;
                    } else if ("session".equals(scopeStr)) {
                        scope = Scope.SESSION;
                    } else if ("singleton".equals(scopeStr)) {
                        scope = Scope.SINGLETON;
                    } else if ("thread".equals(scopeStr)) {
                        scope = Scope.THREAD;
                    }
                    if (!TextUtils.stringSet(name)) {
                        name = "default";
                    }
                    try {
                        Class cimpl;
                        Class ctype = cimpl = ClassLoaderUtil.loadClass(impl, this.getClass());
                        if (TextUtils.stringSet(type)) {
                            ctype = ClassLoaderUtil.loadClass(type, this.getClass());
                        }
                        if ("true".equals(onlyStatic)) {
                            cimpl.getDeclaredClasses();
                            containerBuilder.injectStatics(cimpl);
                        } else {
                            if (containerBuilder.contains(ctype, name)) {
                                Location loc = LocationUtils.getLocation(loadedBeans.get(ctype.getName() + name));
                                if (this.throwExceptionOnDuplicateBeans) {
                                    throw new ConfigurationException("Bean type " + ctype + " with the name " + name + " has already been loaded by " + loc, (Object)child);
                                }
                            }
                            cimpl.getDeclaredConstructors();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Loaded type:" + type + " name:" + name + " impl:" + impl, new String[0]);
                            }
                            containerBuilder.factory(ctype, name, new LocatableFactory(name, ctype, cimpl, scope, childNode), scope);
                        }
                        loadedBeans.put(ctype.getName() + name, child);
                    }
                    catch (Throwable ex) {
                        if (!optional) {
                            throw new ConfigurationException("Unable to load bean: type:" + type + " class:" + impl, ex, childNode);
                        }
                        LOG.debug("Unable to load optional class: " + ex, new String[0]);
                    }
                    continue;
                }
                if (!nodeName.equals("constant")) continue;
                String name = child.getAttribute("name");
                String value = child.getAttribute("value");
                props.setProperty(name, value, childNode);
            }
        }
    }

    @Override
    public void loadPackages() throws ConfigurationException {
        ArrayList<Element> reloads = new ArrayList<Element>();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                PackageConfig cfg;
                Element child;
                String nodeName;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !(nodeName = (child = (Element)childNode).getNodeName()).equals("package") || !(cfg = this.addPackage(child)).isNeedsRefresh()) continue;
                reloads.add(child);
            }
            this.loadExtraConfiguration(doc);
        }
        if (reloads.size() > 0) {
            this.reloadRequiredPackages(reloads);
        }
        for (Document doc : this.documents) {
            this.loadExtraConfiguration(doc);
        }
        this.documents.clear();
        this.configuration = null;
    }

    private void reloadRequiredPackages(List<Element> reloads) {
        if (reloads.size() > 0) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element pkg : reloads) {
                PackageConfig cfg = this.addPackage(pkg);
                if (!cfg.isNeedsRefresh()) continue;
                result.add(pkg);
            }
            if (result.size() > 0 && result.size() != reloads.size()) {
                this.reloadRequiredPackages(result);
                return;
            }
            if (result.size() > 0) {
                for (Element rp : result) {
                    List parents;
                    String parent = rp.getAttribute("extends");
                    if (parent == null || (parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent)) == null || parents.size() > 0) continue;
                    LOG.error("Unable to find parent packages " + parent, new String[0]);
                }
            }
        }
    }

    @Override
    public boolean needsReload() {
        for (String url : this.loadedFileUrls) {
            if (!FileManager.fileNeedsReloading(url)) continue;
            return true;
        }
        return false;
    }

    protected void addAction(Element actionElement, PackageConfig.Builder packageContext) throws ConfigurationException {
        Map results;
        String name = actionElement.getAttribute("name");
        String className = actionElement.getAttribute("class");
        String methodName = actionElement.getAttribute("method");
        Location location = DomHelper.getLocationObject(actionElement);
        if (location == null) {
            LOG.warn("location null for " + className, new String[0]);
        }
        String string = methodName = methodName.trim().length() > 0 ? methodName.trim() : null;
        if (TextUtils.stringSet(className) && !this.verifyAction(className, name, location)) {
            return;
        }
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), e, actionElement);
        }
        List interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List exceptionMappings = this.buildExceptionMappings(actionElement, packageContext);
        ActionConfig actionConfig = ((ActionConfig.Builder)new ActionConfig.Builder(packageContext.getName(), name, className).methodName(methodName).addResultConfigs(results).addInterceptors(interceptorList)).addExceptionMappings(exceptionMappings).addParams(XmlHelper.getParams(actionElement)).location(location).build();
        packageContext.addActionConfig(name, actionConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + (TextUtils.stringSet(packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : "") + name + " in '" + packageContext.getName() + "' package:" + actionConfig, new String[0]);
        }
    }

    protected boolean verifyAction(String className, String name, Location loc) {
        if (className.indexOf(123) > -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action class [" + className + "] contains a wildcard " + "replacement value, so it can't be verified", new String[0]);
            }
            return true;
        }
        try {
            Class clazz = this.objectFactory.getClassInstance(className);
            if (this.objectFactory.isNoArgConstructorRequired()) {
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    throw new ConfigurationException("Action class [" + className + "] is not public", (Object)loc);
                }
                clazz.getConstructor(new Class[0]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Action class [" + className + "] not found", (Object)loc);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Action class [" + className + "] does not have a public no-arg constructor", e, loc);
        }
        catch (RuntimeException ex) {
            LOG.info("Unable to verify action class [" + className + "] exists at initialization", new String[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action verification cause", ex, new String[0]);
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex, (Object)loc);
        }
        return true;
    }

    protected PackageConfig addPackage(Element packageElement) throws ConfigurationException {
        PackageConfig.Builder newPackage = this.buildPackageContext(packageElement);
        if (newPackage.isNeedsRefresh()) {
            return newPackage.build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + newPackage, new String[0]);
        }
        this.addResultTypes(newPackage, packageElement);
        this.loadInterceptors(newPackage, packageElement);
        this.loadDefaultInterceptorRef(newPackage, packageElement);
        this.loadDefaultClassRef(newPackage, packageElement);
        this.loadGlobalResults(newPackage, packageElement);
        this.loadGobalExceptionMappings(newPackage, packageElement);
        NodeList actionList = packageElement.getElementsByTagName("action");
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element actionElement = (Element)actionList.item(i);
            this.addAction(actionElement, newPackage);
        }
        this.loadDefaultActionRef(newPackage, packageElement);
        PackageConfig cfg = newPackage.build();
        this.configuration.addPackageConfig(cfg.getName(), cfg);
        return cfg;
    }

    protected void addResultTypes(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("result-type");
        for (int i = 0; i < resultTypeList.getLength(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.item(i);
            String name = resultTypeElement.getAttribute("name");
            String className = resultTypeElement.getAttribute("class");
            String def = resultTypeElement.getAttribute("default");
            Location loc = DomHelper.getLocationObject(resultTypeElement);
            Class clazz = this.verifyResultType(className, loc);
            if (clazz == null) continue;
            String paramName = null;
            try {
                paramName = (String)clazz.getField("DEFAULT_PARAM").get(null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ResultTypeConfig.Builder resultType = new ResultTypeConfig.Builder(name, className).defaultResultParam(paramName).location(DomHelper.getLocationObject(resultTypeElement));
            Map params = XmlHelper.getParams(resultTypeElement);
            if (!params.isEmpty()) {
                resultType.addParams(params);
            }
            packageContext.addResultTypeConfig(resultType.build());
            if (!"true".equals(def)) continue;
            packageContext.defaultResultType(name);
        }
    }

    protected Class verifyResultType(String className, Location loc) {
        try {
            return this.objectFactory.getClassInstance(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Result class [" + className + "] doesn't exist (ClassNotFoundException) at " + loc.toString() + ", ignoring", e, new String[0]);
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Result class [" + className + "] doesn't exist (NoClassDefFoundError) at " + loc.toString() + ", ignoring", e, new String[0]);
        }
        return null;
    }

    protected List buildInterceptorList(Element element, PackageConfig.Builder context) throws ConfigurationException {
        ArrayList interceptorList = new ArrayList();
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int i = 0; i < interceptorRefList.getLength(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.item(i);
            if (!interceptorRefElement.getParentNode().equals(element) && !interceptorRefElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    protected PackageConfig.Builder buildPackageContext(Element packageElement) {
        String parent = packageElement.getAttribute("extends");
        String abstractVal = packageElement.getAttribute("abstract");
        boolean isAbstract = Boolean.valueOf(abstractVal);
        String name = TextUtils.noNull(packageElement.getAttribute("name"));
        String namespace = TextUtils.noNull(packageElement.getAttribute("namespace"));
        if (TextUtils.stringSet(packageElement.getAttribute("externalReferenceResolver"))) {
            throw new ConfigurationException("The 'externalReferenceResolver' attribute has been removed.  Please use a custom ObjectFactory or Interceptor.", (Object)packageElement);
        }
        PackageConfig.Builder cfg = new PackageConfig.Builder(name).namespace(namespace).isAbstract(isAbstract).location(DomHelper.getLocationObject(packageElement));
        if (TextUtils.stringSet(TextUtils.noNull(parent))) {
            List parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent);
            if (parents.size() <= 0) {
                cfg.needsRefresh(true);
            } else {
                cfg.addParents(parents);
            }
        }
        return cfg;
    }

    protected Map buildResults(Element element, PackageConfig.Builder packageContext) {
        NodeList resultEls = element.getElementsByTagName("result");
        LinkedHashMap<String, ResultConfig> results = new LinkedHashMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.getLength(); ++i) {
            Element resultElement = (Element)resultEls.item(i);
            if (!resultElement.getParentNode().equals(element) && !resultElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String resultName = resultElement.getAttribute("name");
            String resultType = resultElement.getAttribute("type");
            if (!TextUtils.stringSet(resultName)) {
                resultName = "success";
            }
            if (!TextUtils.stringSet(resultType) && !TextUtils.stringSet(resultType = packageContext.getFullDefaultResultType())) {
                throw new ConfigurationException("No result type specified for result named '" + resultName + "', perhaps the parent package does not specify the result type?", (Object)resultElement);
            }
            ResultTypeConfig config = packageContext.getResultType(resultType);
            if (config == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'", (Object)resultElement);
            }
            String resultClass = config.getClazz();
            if (resultClass == null) {
                throw new ConfigurationException("Result type '" + resultType + "' is invalid");
            }
            LinkedHashMap<String, String> resultParams = XmlHelper.getParams(resultElement);
            if (resultParams.size() == 0 && resultElement.getChildNodes().getLength() >= 1) {
                resultParams = new LinkedHashMap<String, String>();
                String paramName = config.getDefaultResultParam();
                if (paramName != null) {
                    StringBuffer paramValue = new StringBuffer();
                    for (int j = 0; j < resultElement.getChildNodes().getLength(); ++j) {
                        String val;
                        if (resultElement.getChildNodes().item(j).getNodeType() != 3 || (val = resultElement.getChildNodes().item(j).getNodeValue()) == null) continue;
                        paramValue.append(val);
                    }
                    String val = paramValue.toString().trim();
                    if (val.length() > 0) {
                        resultParams.put(paramName, val);
                    }
                } else {
                    LOG.warn("no default parameter defined for result of type " + config.getName(), new String[0]);
                }
            }
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            Map<String, String> configParams = config.getParams();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.putAll(resultParams);
            ResultConfig resultConfig = new ResultConfig.Builder(resultName, resultClass).addParams(params).location(DomHelper.getLocationObject(element)).build();
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    protected List buildExceptionMappings(Element element, PackageConfig.Builder packageContext) {
        NodeList exceptionMappingEls = element.getElementsByTagName("exception-mapping");
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (int i = 0; i < exceptionMappingEls.getLength(); ++i) {
            Element ehElement = (Element)exceptionMappingEls.item(i);
            if (!ehElement.getParentNode().equals(element) && !ehElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String emName = ehElement.getAttribute("name");
            String exceptionClassName = ehElement.getAttribute("exception");
            String exceptionResult = ehElement.getAttribute("result");
            Map params = XmlHelper.getParams(ehElement);
            if (!TextUtils.stringSet(emName)) {
                emName = exceptionResult;
            }
            ExceptionMappingConfig ehConfig = new ExceptionMappingConfig.Builder(emName, exceptionClassName, exceptionResult).addParams(params).location(DomHelper.getLocationObject(ehElement)).build();
            exceptionMappings.add(ehConfig);
        }
        return exceptionMappings;
    }

    protected void loadDefaultInterceptorRef(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-interceptor-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.defaultInterceptorRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadDefaultActionRef(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-action-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.defaultActionRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig.Builder packageContext, Element packageElement) {
        NodeList globalResultList = packageElement.getElementsByTagName("global-results");
        if (globalResultList.getLength() > 0) {
            Element globalResultElement = (Element)globalResultList.item(0);
            Map results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected void loadDefaultClassRef(PackageConfig.Builder packageContext, Element element) {
        NodeList defaultClassRefList = element.getElementsByTagName("default-class-ref");
        if (defaultClassRefList.getLength() > 0) {
            Element defaultClassRefElement = (Element)defaultClassRefList.item(0);
            packageContext.defaultClassRef(defaultClassRefElement.getAttribute("class"));
        }
    }

    protected void loadGobalExceptionMappings(PackageConfig.Builder packageContext, Element packageElement) {
        NodeList globalExceptionMappingList = packageElement.getElementsByTagName("global-exception-mappings");
        if (globalExceptionMappingList.getLength() > 0) {
            Element globalExceptionMappingElement = (Element)globalExceptionMappingList.item(0);
            List exceptionMappings = this.buildExceptionMappings(globalExceptionMappingElement, packageContext);
            packageContext.addGlobalExceptionMappingConfigs(exceptionMappings);
        }
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig.Builder context) throws ConfigurationException {
        String name = element.getAttribute("name");
        InterceptorStackConfig.Builder config = new InterceptorStackConfig.Builder(name).location(DomHelper.getLocationObject(element));
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int j = 0; j < interceptorRefList.getLength(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.item(j);
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors(interceptors);
        }
        return config.build();
    }

    protected void loadInterceptorStacks(Element element, PackageConfig.Builder context) throws ConfigurationException {
        NodeList interceptorStackList = element.getElementsByTagName("interceptor-stack");
        for (int i = 0; i < interceptorStackList.getLength(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.item(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void loadInterceptors(PackageConfig.Builder context, Element element) throws ConfigurationException {
        NodeList interceptorList = element.getElementsByTagName("interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            String name = interceptorElement.getAttribute("name");
            String className = interceptorElement.getAttribute("class");
            Map params = XmlHelper.getParams(interceptorElement);
            InterceptorConfig config = new InterceptorConfig.Builder(name, className).addParams(params).location(DomHelper.getLocationObject(interceptorElement)).build();
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    private List loadConfigurationFiles(String fileName, Element includeElement) {
        ArrayList<Document> docs = new ArrayList<Document>();
        if (!this.includedFileNames.contains(fileName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading action configurations from: " + fileName, new String[0]);
            }
            this.includedFileNames.add(fileName);
            Iterator<URL> urls = null;
            Document doc = null;
            InputStream is = null;
            IOException ioException = null;
            try {
                urls = this.getConfigurationUrls(fileName);
            }
            catch (IOException ex) {
                ioException = ex;
            }
            if (urls == null || !urls.hasNext()) {
                if (this.errorIfMissing) {
                    throw new ConfigurationException("Could not open files of the name " + fileName, ioException);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to locate configuration files of the name " + fileName + ", skipping", new String[0]);
                }
                return docs;
            }
            URL url = null;
            while (urls.hasNext()) {
                try {
                    url = urls.next();
                    is = FileManager.loadFile(url);
                    InputSource in = new InputSource(is);
                    in.setSystemId(url.toString());
                    doc = DomHelper.parse(in, this.dtdMappings);
                }
                catch (XWorkException e) {
                    if (includeElement != null) {
                        throw new ConfigurationException("Unable to load " + url, e, includeElement);
                    }
                    throw new ConfigurationException("Unable to load " + url, e);
                }
                catch (Exception e) {
                    String s = "Caught exception while loading file " + fileName;
                    throw new ConfigurationException(s, e, includeElement);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            LOG.error("Unable to close input stream", e, new String[0]);
                        }
                    }
                }
                Element rootElement = doc.getDocumentElement();
                NodeList children = rootElement.getChildNodes();
                int childSize = children.getLength();
                for (int i = 0; i < childSize; ++i) {
                    Element child;
                    String nodeName;
                    Node childNode = children.item(i);
                    if (!(childNode instanceof Element) || !(nodeName = (child = (Element)childNode).getNodeName()).equals("include")) continue;
                    String includeFileName = child.getAttribute("file");
                    if (includeFileName.indexOf(42) != -1) {
                        ClassPathFinder wildcardFinder = new ClassPathFinder();
                        wildcardFinder.setPattern(includeFileName);
                        Vector<String> wildcardMatches = wildcardFinder.findMatches();
                        for (String match : wildcardMatches) {
                            docs.addAll(this.loadConfigurationFiles(match, child));
                        }
                        continue;
                    }
                    docs.addAll(this.loadConfigurationFiles(includeFileName, child));
                }
                docs.add(doc);
                this.loadedFileUrls.add(url.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded action configuration from: " + fileName, new String[0]);
            }
        }
        return docs;
    }

    private void handleWildCardIncludes(String includeFileName, List<Document> docs, Element child) {
        if (includeFileName.indexOf(42) == -1) {
            throw new XWorkException("handleWildCardIncludes called with name not containing wildcard");
        }
        LOG.info("encountered wildcard include, checking for - " + includeFileName, new String[0]);
        ClassLoader cl = XmlConfigurationProvider.class.getClassLoader();
        if (!(cl instanceof URLClassLoader)) {
            throw new XWorkException("cannot create an URLClassLoader from current classloader");
        }
        URLClassLoader ucl = (URLClassLoader)cl;
        URL[] curDirUrls = ucl.getURLs();
        String fileNamePrefix = null;
        if (!includeFileName.startsWith("*")) {
            fileNamePrefix = includeFileName.substring(0, includeFileName.indexOf(42));
        }
        String fileNameSuffix = null;
        if (!includeFileName.endsWith("*")) {
            fileNameSuffix = includeFileName.substring(includeFileName.lastIndexOf(42) + 1);
        }
        String relativeDir = null;
        if (includeFileName.indexOf("/") != -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("includeFileName contains a /", new String[0]);
            }
            if (includeFileName.lastIndexOf(47) > includeFileName.indexOf(42)) {
                throw new XWorkException("wildcard includes does not support wildcard directories");
            }
            fileNamePrefix = includeFileName.substring(includeFileName.lastIndexOf(47) + 1, includeFileName.indexOf(42));
            relativeDir = includeFileName.substring(0, includeFileName.lastIndexOf(47));
            if (LOG.isDebugEnabled()) {
                LOG.debug("relativeDir = " + relativeDir + ", fileNameMask = " + fileNamePrefix, new String[0]);
            }
        }
        for (URL baseSearchURL : curDirUrls) {
            String[] filesInDir;
            File searchDir;
            if (!baseSearchURL.getProtocol().equals("file")) continue;
            if (relativeDir != null) {
                File parent;
                if (relativeDir.startsWith("/")) {
                    relativeDir = relativeDir.substring(relativeDir.indexOf(47) + 1);
                }
                try {
                    parent = new File(baseSearchURL.toURI());
                }
                catch (URISyntaxException e) {
                    throw new XWorkException("bad URI for searchDir - " + baseSearchURL.toString());
                }
                if (!parent.isDirectory()) continue;
                searchDir = new File(parent, relativeDir);
            } else {
                try {
                    searchDir = new File(baseSearchURL.toURI());
                }
                catch (URISyntaxException e) {
                    throw new XWorkException("bad URI for searchDir - " + baseSearchURL.toString());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("using - " + searchDir.toURI().toString() + ", as searchDir", new String[0]);
            }
            if (searchDir == null || !searchDir.isDirectory()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting searchDir file list", new String[0]);
            }
            if ((filesInDir = searchDir.list()) == null) {
                throw new XWorkException("unable to find any files in include directory");
            }
            for (String fileInDir : filesInDir) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("checking - " + fileInDir, new String[0]);
                }
                boolean fileMatches = false;
                if (fileNameSuffix != null || fileNamePrefix != null) {
                    fileMatches = fileNameSuffix != null && fileNamePrefix != null && fileNameSuffix.length() + fileNamePrefix.length() < fileInDir.length() && fileInDir.startsWith(fileNamePrefix) && fileInDir.endsWith(fileNameSuffix);
                    fileMatches = fileMatches || fileNamePrefix == null && fileInDir.endsWith(fileNameSuffix);
                    boolean bl = fileMatches = fileMatches || fileNameSuffix == null && fileInDir.startsWith(fileNamePrefix);
                }
                if (!fileMatches) continue;
                if (relativeDir != null) {
                    if (!relativeDir.endsWith("/")) {
                        relativeDir = relativeDir.concat("/");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("calling load on - " + relativeDir + fileInDir, new String[0]);
                    }
                    docs.addAll(this.loadConfigurationFiles(relativeDir + fileInDir, child));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("calling load on - " + fileInDir, new String[0]);
                }
                docs.addAll(this.loadConfigurationFiles(fileInDir, child));
            }
        }
    }

    protected Iterator<URL> getConfigurationUrls(String fileName) throws IOException {
        return ClassLoaderUtil.getResources(fileName, XmlConfigurationProvider.class, false);
    }

    protected void loadExtraConfiguration(Document doc) {
    }

    private List lookupInterceptorReference(PackageConfig.Builder context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.getAttribute("name");
        Map refParams = XmlHelper.getParams(interceptorRefElement);
        Location loc = LocationUtils.getLocation(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference(context, refName, refParams, loc, this.objectFactory);
    }
}

