/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.common.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;

public class CryptoUtil {
    private static final String KEY = "LogProxy123*";
    private static final int AES_KEY_SIZE = 256;
    private static final int GCM_TAG_LENGTH = 16;

    public static Encryptor newEncryptor(String key) {
        return new Encryptor(key);
    }

    public static Encryptor newEncryptor() {
        return new Encryptor(KEY);
    }

    public static byte[] sha1(byte[] bytes) {
        return DigestUtils.sha1((byte[])bytes);
    }

    public static byte[] sha1(String text) {
        return DigestUtils.sha1((String)text);
    }

    public static class Encryptor {
        private Cipher cipher = null;
        private final byte[] key = new byte[16];
        private final byte[] iv = new byte[12];

        private Encryptor(String cipherKey) {
            try {
                this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
                byte[] cipherBytes = cipherKey.getBytes();
                System.arraycopy(cipherBytes, 0, this.key, 0, Math.min(this.key.length, cipherBytes.length));
                System.arraycopy(cipherBytes, 0, this.iv, 0, Math.min(this.iv.length, cipherBytes.length));
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                System.exit(-1);
            }
        }

        public byte[] encrypt(String text) {
            SecretKeySpec keySpec = new SecretKeySpec(this.key, "AES");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, this.iv);
            try {
                this.cipher.init(1, (Key)keySpec, gcmParameterSpec);
                return this.cipher.doFinal(text.getBytes());
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                return null;
            }
        }

        public String decrypt(byte[] cipherText) {
            SecretKeySpec keySpec = new SecretKeySpec(this.key, "AES");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, this.iv);
            try {
                this.cipher.init(2, (Key)keySpec, gcmParameterSpec);
                byte[] decryptedText = this.cipher.doFinal(cipherText);
                return new String(decryptedText);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                return "";
            }
        }
    }
}

