/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.worker;

import com.netflix.config.DynamicProperty;
import java.util.concurrent.ConcurrentHashMap;

public class PropertyFactory {
    private DynamicProperty global;
    private DynamicProperty local;
    private static final String PROPERTY_PREFIX = "conductor.worker";
    private static ConcurrentHashMap<String, PropertyFactory> factories = new ConcurrentHashMap();

    private PropertyFactory(String prefix, String propName, String workerName) {
        this.global = DynamicProperty.getInstance((String)(prefix + "." + propName));
        this.local = DynamicProperty.getInstance((String)(prefix + "." + workerName + "." + propName));
    }

    public Integer getInteger(int defaultValue) {
        Integer value = this.local.getInteger();
        if (value == null) {
            value = this.global.getInteger(Integer.valueOf(defaultValue));
        }
        return value;
    }

    public String getString(String defaultValue) {
        String value = this.local.getString();
        if (value == null) {
            value = this.global.getString(defaultValue);
        }
        return value;
    }

    public Boolean getBoolean(Boolean defaultValue) {
        Boolean value = this.local.getBoolean();
        if (value == null) {
            value = this.global.getBoolean(defaultValue);
        }
        return value;
    }

    public static Integer getInteger(String workerName, String property, Integer defaultValue) {
        return PropertyFactory.getPropertyFactory(workerName, property).getInteger(defaultValue);
    }

    public static Boolean getBoolean(String workerName, String property, Boolean defaultValue) {
        return PropertyFactory.getPropertyFactory(workerName, property).getBoolean(defaultValue);
    }

    public static String getString(String workerName, String property, String defaultValue) {
        return PropertyFactory.getPropertyFactory(workerName, property).getString(defaultValue);
    }

    private static PropertyFactory getPropertyFactory(String workerName, String property) {
        String key = property + "." + workerName;
        return factories.computeIfAbsent(key, t -> new PropertyFactory(PROPERTY_PREFIX, property, workerName));
    }
}

