/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.nacos.adapter;

import com.alibaba.nacos.api.config.listener.Listener;
import com.nepxion.discovery.common.entity.ConfigType;
import com.nepxion.discovery.common.nacos.operation.NacosOperation;
import com.nepxion.discovery.common.nacos.operation.NacosSubscribeCallback;
import com.nepxion.discovery.common.thread.DiscoveryThreadPoolFactory;
import com.nepxion.discovery.plugin.configcenter.adapter.ConfigAdapter;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class NacosConfigAdapter
extends ConfigAdapter {
    private ExecutorService executorService = DiscoveryThreadPoolFactory.getExecutorService((String)"nacos-config");
    @Autowired
    private NacosOperation nacosOperation;
    private Listener partialListener;
    private Listener globalListener;

    public String getConfig(String group, String dataId) throws Exception {
        return this.nacosOperation.getConfig(group, dataId);
    }

    @PostConstruct
    public void subscribeConfig() {
        this.partialListener = this.subscribeConfig(false);
        this.globalListener = this.subscribeConfig(true);
    }

    private Listener subscribeConfig(final boolean globalConfig) {
        String group = this.getGroup();
        String dataId = this.getDataId(globalConfig);
        this.logSubscribeStarted(globalConfig);
        try {
            return this.nacosOperation.subscribeConfig(group, dataId, (Executor)this.executorService, new NacosSubscribeCallback(){

                public void callback(String config) {
                    NacosConfigAdapter.this.callbackConfig(config, globalConfig);
                }
            });
        }
        catch (Exception e) {
            this.logSubscribeFailed(e, globalConfig);
            return null;
        }
    }

    public void unsubscribeConfig() {
        this.unsubscribeConfig(this.partialListener, false);
        this.unsubscribeConfig(this.globalListener, true);
        this.executorService.shutdownNow();
    }

    private void unsubscribeConfig(Listener listener, boolean globalConfig) {
        if (listener == null) {
            return;
        }
        String group = this.getGroup();
        String dataId = this.getDataId(globalConfig);
        this.logUnsubscribeStarted(globalConfig);
        try {
            this.nacosOperation.unsubscribeConfig(group, dataId, listener);
        }
        catch (Exception e) {
            this.logUnsubscribeFailed(e, globalConfig);
        }
    }

    public ConfigType getConfigType() {
        return ConfigType.NACOS;
    }
}

