/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class ResponseUtil {
    public static <T> ResponseEntity<T> getSuccessResponse(T result) {
        return ResponseEntity.ok().body(result);
    }

    public static <T> ResponseEntity<T> getFailureResponse(T result) {
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(result);
    }

    public static ResponseEntity<String> getFailureResponse(Exception e) {
        String message = ResponseUtil.getFailureMessage(e);
        return ResponseUtil.getFailureResponse(message);
    }

    public static String getFailureMessage(Exception e) {
        return ResponseUtil.getFailureMessage(e, false);
    }

    public static String getFailureMessage(Exception e, boolean detailed) {
        String message = null;
        message = detailed ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage();
        return message;
    }
}

