/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.processor;

import com.nepxion.discovery.common.entity.ConfigType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryConfigProcessorLogger {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryConfigProcessorLogger.class);

    public static void logGetStarted(String group, String dataId, String description, ConfigType configType, boolean isConfigSingleKey) {
        LOG.info("Get {} config from {} server, " + DiscoveryConfigProcessorLogger.getLogKey(isConfigSingleKey), new Object[]{description, configType, group, dataId});
    }

    public static void logGetFailed(String group, String dataId, String description, ConfigType configType, boolean isConfigSingleKey, Exception e) {
        LOG.error("Get {} config from {} server failed, " + DiscoveryConfigProcessorLogger.getLogKey(isConfigSingleKey), new Object[]{description, configType, group, dataId, e});
    }

    public static void logNotFound(String description, ConfigType configType) {
        LOG.info("Not found {} config from {} server", (Object)description, (Object)configType);
    }

    public static void logSubscribeStarted(String group, String dataId, String description, ConfigType configType, boolean isConfigSingleKey) {
        LOG.info("Subscribe {} config from {} server, " + DiscoveryConfigProcessorLogger.getLogKey(isConfigSingleKey), new Object[]{description, configType, group, dataId});
    }

    public static void logSubscribeFailed(String group, String dataId, String description, ConfigType configType, boolean isConfigSingleKey, Exception e) {
        LOG.error("Subscribe {} config from {} server failed, " + DiscoveryConfigProcessorLogger.getLogKey(isConfigSingleKey), new Object[]{description, configType, group, dataId, e});
    }

    public static void logUnsubscribeStarted(String group, String dataId, String description, ConfigType configType, boolean isConfigSingleKey) {
        LOG.info("Unsubscribe {} config from {} server, " + DiscoveryConfigProcessorLogger.getLogKey(isConfigSingleKey), new Object[]{description, configType, group, dataId});
    }

    public static void logUnsubscribeFailed(String group, String dataId, String description, ConfigType configType, boolean isConfigSingleKey, Exception e) {
        LOG.error("Unsubscribe {} config from {} server failed, " + DiscoveryConfigProcessorLogger.getLogKey(isConfigSingleKey), new Object[]{description, configType, group, dataId, e});
    }

    public static void logCallbackFailed(String description, Exception e) {
        LOG.error("Callback {} config failed", (Object)description, (Object)e);
    }

    private static String getLogKey(boolean isConfigSingleKey) {
        return isConfigSingleKey ? "key={}-{}" : "group={}, dataId={}";
    }
}

