/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxMap;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.SequenceInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class OnnxSequence
implements OnnxValue {
    private static final Logger logger = Logger.getLogger(OnnxSequence.class.getName());
    final long nativeHandle;
    private final long allocatorHandle;
    private final SequenceInfo info;
    private boolean closed;

    OnnxSequence(long nativeHandle, long allocatorHandle, SequenceInfo info) {
        this.nativeHandle = nativeHandle;
        this.allocatorHandle = allocatorHandle;
        this.info = info;
        this.closed = false;
    }

    @Override
    public OnnxValue.OnnxValueType getType() {
        return OnnxValue.OnnxValueType.ONNX_TYPE_SEQUENCE;
    }

    @Override
    public List<? extends OnnxValue> getValue() throws OrtException {
        this.checkClosed();
        if (this.info.sequenceOfMaps) {
            OnnxMap[] maps = this.getMaps(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
            return Collections.unmodifiableList(Arrays.asList(maps));
        }
        switch (this.info.sequenceType) {
            case STRING: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                OnnxTensor[] tensors = this.getTensors(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                return Collections.unmodifiableList(Arrays.asList(tensors));
            }
        }
        throw new OrtException("Unsupported type in a sequence, found " + (Object)((Object)this.info.sequenceType));
    }

    @Override
    public SequenceInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "OnnxSequence(info=" + this.info.toString() + ")";
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        } else {
            logger.warning("Closing an already closed sequence.");
        }
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Trying to use a closed OnnxValue");
        }
    }

    private native OnnxMap[] getMaps(long var1, long var3, long var5) throws OrtException;

    private native OnnxTensor[] getTensors(long var1, long var3, long var5) throws OrtException;

    private native void close(long var1, long var3);

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }
}

