/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.push.sdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.meizu.push.sdk.exception.InvalidRequestException;
import com.meizu.push.sdk.server.model.HttpResult;
import com.meizu.push.sdk.utils.MD5Util;
import com.meizu.push.sdk.utils.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private static final String JDK_VERSION = System.getProperty("java.version", "UNKNOWN");
    private static final String OS = System.getProperty("os.name").toLowerCase();
    public static final String SIGN = "sign";
    protected final Random random = new Random();
    private static String HOST_NAME;
    private static String LOCAL_IP;
    protected final String appSecret;
    protected final long appId;
    protected final boolean useSSL;

    public HttpClient(String appSecret) {
        this(0L, appSecret);
    }

    public HttpClient(String appSecret, boolean useSSL) {
        this(0L, appSecret, useSSL);
    }

    public HttpClient(long appId, String appSecret) {
        this(appId, appSecret, Boolean.FALSE);
    }

    public HttpClient(long appId, String appSecret, boolean useSSL) {
        HttpClient.nonNull(appSecret);
        this.appId = appId;
        this.appSecret = appSecret;
        this.useSSL = useSSL;
        HttpClient.getLocalHostNameAndIp();
    }

    private static void getLocalHostNameAndIp() {
        try {
            HOST_NAME = InetAddress.getLocalHost().getHostName();
            LOCAL_IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected HttpURLConnection doPost(String url, String body) throws IOException {
        return this.doPost(url, "application/x-www-form-urlencoded;charset=UTF-8", body);
    }

    public HttpURLConnection doGet(String url, String parameter) throws IOException {
        return this.doGet(url, "application/x-www-form-urlencoded;charset=UTF-8", parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection doPost(String url, String contentType, String body) throws IOException {
        if (url == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        try {
            HttpClient.ignoreSsl();
        }
        catch (KeyManagementException e) {
            logger.warn("ignoreSsl error:{}", (Object)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("ignoreSsl error:{}", (Object)e.getMessage());
        }
        StringBuilder signBody = new StringBuilder(body);
        HttpClient.addParameter(signBody, SIGN, HttpClient.getSignature(this.str2Param(body), this.appSecret));
        logger.debug("Sending post to:{} param:{}", (Object)url, (Object)URLDecoder.decode(signBody.toString(), "UTF-8"));
        HttpURLConnection conn = this.getConnection(url);
        this.prepareConnection(conn);
        byte[] bytes = signBody.toString().getBytes();
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        OutputStream out = conn.getOutputStream();
        try {
            out.write(bytes);
        }
        finally {
            HttpClient.close(out);
        }
        return conn;
    }

    private Map<String, String> str2Param(String body) throws UnsupportedEncodingException {
        String[] paramArray;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String param : paramArray = body.split("&")) {
            String[] argArray = param.split("=");
            if (argArray.length == 2) {
                paramMap.put(argArray[0], URLDecoder.decode(argArray[1], "UTF-8"));
                continue;
            }
            if (argArray.length != 1) continue;
            paramMap.put(argArray[0], "");
        }
        return paramMap;
    }

    protected HttpURLConnection doGet(String url, String contentType, String parameter) throws IOException {
        if (url == null || parameter == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        StringBuilder signParameter = new StringBuilder(parameter);
        HttpClient.addParameter(signParameter, SIGN, HttpClient.getSignature(this.str2Param(parameter), this.appSecret));
        logger.debug("Sending get to:{}", (Object)url);
        logger.debug("get parameter:{}", (Object)URLDecoder.decode(signParameter.toString(), "UTF-8"));
        String fullUrl = url + "?" + signParameter;
        HttpURLConnection conn = this.getConnection(fullUrl);
        this.prepareConnection(conn);
        conn.setConnectTimeout(20000);
        conn.setReadTimeout(20000);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", contentType);
        conn.getInputStream();
        return conn;
    }

    protected void prepareConnection(HttpURLConnection conn) {
        conn.setRequestProperty("F-PUSH-SDK-VERSION", "1.2.7.20181106_release");
        conn.setRequestProperty("F-PUSH-JDK-VERSION", JDK_VERSION);
        conn.setRequestProperty("F-PUSH-OS", OS);
        if (HOST_NAME != null) {
            conn.setRequestProperty("F-PUSH-CLIENT-HOST", HOST_NAME);
        }
        if (LOCAL_IP != null) {
            conn.setRequestProperty("F-PUSH-CLIENT-IP", LOCAL_IP);
        }
    }

    protected static StringBuilder newBody(String name, String value) throws UnsupportedEncodingException {
        return new StringBuilder(HttpClient.nonNull(name)).append('=').append(URLEncoder.encode(HttpClient.nonNull(value), "UTF-8"));
    }

    private static void close(Closeable closeable) throws IOException {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.error("IOException closing stream:{}", (Object)e.getMessage());
        }
    }

    protected static StringBuilder newBodyWithArrayParameters(String name, List<String> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            if (i == 0) {
                sb.append(HttpClient.nonNull(name)).append("=").append(URLEncoder.encode(HttpClient.nonNull(parameters.get(i)), "UTF-8"));
                continue;
            }
            HttpClient.nonNull(sb).append('&').append(HttpClient.nonNull(name)).append('=').append(URLEncoder.encode(HttpClient.nonNull(parameters.get(i)), "UTF-8"));
        }
        if (parameters.size() == 0) {
            sb.append(name).append("=").append("");
        }
        return sb;
    }

    protected static void addParameter(StringBuilder body, String name, String value) throws UnsupportedEncodingException {
        HttpClient.nonNull(body).append('&').append(HttpClient.nonNull(name)).append('=').append(URLEncoder.encode(HttpClient.nonNull(value), "UTF-8"));
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }

    protected static String getString(InputStream stream) throws IOException {
        String newLine;
        if (stream == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder content = new StringBuilder();
        do {
            if ((newLine = reader.readLine()) == null) continue;
            content.append(newLine).append('\n');
        } while (newLine != null);
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAndClose(InputStream stream) throws IOException {
        try {
            String str;
            String string = str = HttpClient.getString(stream);
            return string;
        }
        finally {
            if (stream != null) {
                HttpClient.close(stream);
            }
        }
    }

    protected static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static String getSignature(Map<String, String> paramMap, String secret) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(paramMap);
        Set entrys = sortedParams.entrySet();
        StringBuilder basestring = new StringBuilder();
        for (Map.Entry param : entrys) {
            basestring.append((String)param.getKey()).append("=").append((String)param.getValue());
        }
        basestring.append(secret);
        return MD5Util.MD5Encode(basestring.toString(), "UTF-8");
    }

    private static void ignoreSsl() throws KeyManagementException, NoSuchAlgorithmException {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpClient.trustAllHttpsCertificates();
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    protected HttpResult post(boolean useSSL, String url, String body) throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        String bodyParam;
        if (useSSL && url.startsWith("http://")) {
            url = url.replace("http://", "https://");
        }
        if (StringUtils.isNotBlank(bodyParam = body) && bodyParam.charAt(0) == '&') {
            bodyParam = body.toString().substring(1);
        }
        try {
            conn = this.doPost(url, bodyParam);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.warn("IOException posting:{}", (Object)e.getMessage());
            return null;
        }
        if (status / 100 == 5) {
            logger.warn("push service is unavailable (status {})", (Object)status);
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = HttpClient.getAndClose(conn.getErrorStream());
                logger.warn("Plain post error response:{}", (Object)responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.warn("Exception reading response:{}", (Object)e.getMessage());
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = HttpClient.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.warn("Exception reading response:{}", (Object)e.getMessage());
            return null;
        }
        try {
            JSONObject json = JSON.parseObject((String)responseBody);
            return new HttpResult.Builder().fromJson(json);
        }
        catch (Exception e) {
            logger.warn("Exception parsing response:{}", (Throwable)e);
            throw new IOException("Invalid response from push: " + responseBody);
        }
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

