/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfNumberTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStructureBase;
import com.lowagie.text.pdf.PdfStructureElement;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PdfStructureTreeRoot
extends PdfStructureBase {
    private HashMap parentTree = new HashMap();
    private Map pageMCIDs = new HashMap();
    private int nextMark = 0;
    private PdfWriter writer;

    PdfStructureTreeRoot(PdfWriter pdfWriter) {
        super(PdfName.STRUCTTREEROOT);
        if (pdfWriter == null) {
            throw new NullPointerException("PdfWriter param must not be null");
        }
        this.writer = pdfWriter;
        this.setIndRef(pdfWriter.getPdfIndirectReference());
    }

    public void mapRole(PdfName pdfName, PdfName pdfName2) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.ROLEMAP);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
            this.put(PdfName.ROLEMAP, pdfDictionary);
        }
        pdfDictionary.put(pdfName, pdfName2);
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public int getNextMCID() {
        return this.nextMark++;
    }

    public void setPagesMCID(int n, int n2) {
        Integer n3 = new Integer(n);
        if (!this.pageMCIDs.containsKey(n3)) {
            this.pageMCIDs.put(n3, new Integer(n2));
            this.parentTree.put(n3, new PdfArray());
        }
    }

    public int getMCIDForPage(int n) {
        return (Integer)this.pageMCIDs.get(new Integer(n));
    }

    public Integer getMCIDForPage(Integer n) {
        return (Integer)this.pageMCIDs.get(n);
    }

    public int setPageMark(int n, PdfIndirectReference pdfIndirectReference) {
        Integer n2 = (Integer)this.pageMCIDs.get(new Integer(n));
        PdfArray pdfArray = (PdfArray)this.parentTree.get(n2);
        if (pdfArray == null) {
            pdfArray = new PdfArray();
            this.parentTree.put(new Integer(n), pdfArray);
        }
        pdfArray.add(pdfIndirectReference);
        return pdfArray.size() - 1;
    }

    public void setObjMark(int n, PdfIndirectReference pdfIndirectReference) {
        Integer n2 = new Integer(n);
        this.parentTree.put(n2, pdfIndirectReference);
    }

    private void nodeProcess(PdfDictionary pdfDictionary, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.K);
        if (pdfArray != null && !pdfArray.getPdfObject(0).isNumber()) {
            for (int i = 0; i < pdfArray.size(); ++i) {
                PdfStructureElement pdfStructureElement = (PdfStructureElement)pdfArray.getPdfObject(i);
                pdfArray.set(i, pdfStructureElement.getIndRef());
                this.nodeProcess(pdfStructureElement, pdfStructureElement.getIndRef());
            }
        }
        if (pdfIndirectReference != null) {
            this.writer.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
        }
    }

    void buildTree() throws IOException {
        HashMap<Integer, PdfObject> hashMap = new HashMap<Integer, PdfObject>();
        Object object = this.parentTree.keySet().iterator();
        while (object.hasNext()) {
            Integer n = (Integer)object.next();
            PdfObject pdfObject = (PdfObject)this.parentTree.get(n);
            if (pdfObject instanceof PdfIndirectReference) {
                hashMap.put(n, pdfObject);
                continue;
            }
            hashMap.put(n, this.writer.addToBody(pdfObject).getIndirectReference());
        }
        object = PdfNumberTree.writeTree(hashMap, this.writer);
        if (object != null) {
            this.put(PdfName.PARENTTREE, this.writer.addToBody((PdfObject)object).getIndirectReference());
        }
        this.nodeProcess(this, this.getIndRef());
        this.put(PdfName.PARENTTREENEXTKEY, new PdfNumber(this.nextMark));
    }
}

