/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.ext;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.MarketplaceAppAccessTokenReq;
import com.lark.oapi.core.request.MarketplaceTenantAccessTokenReq;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.request.SelfBuiltAppAccessTokenReq;
import com.lark.oapi.core.request.SelfBuiltTenantAccessTokenReq;
import com.lark.oapi.core.response.AppAccessTokenResp;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.response.TenantAccessTokenResp;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.ext.model.AuthenAccessTokenReq;
import com.lark.oapi.service.ext.model.AuthenAccessTokenResp;
import com.lark.oapi.service.ext.model.CreateFileReq;
import com.lark.oapi.service.ext.model.CreateFileResp;
import com.lark.oapi.service.ext.model.GetAuthenUserInfoResp;
import com.lark.oapi.service.ext.model.RefreshAuthenAccessTokenReq;
import com.lark.oapi.service.ext.model.RefreshAuthenAccessTokenResp;

public class ExtService {
    private Config config;

    public ExtService(Config config) {
        this.config = config;
    }

    public CreateFileResp createFile(CreateFileReq req, RequestOptions requestOptions) throws Exception {
        RawResponse resp = Transport.send(this.config, requestOptions, "POST", "/open-apis/drive/explorer/v2/file/:folderToken", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        CreateFileResp createFileResp = UnmarshalRespUtil.unmarshalResp(resp, CreateFileResp.class);
        createFileResp.setRawResponse(resp);
        return createFileResp;
    }

    public CreateFileResp createFile(CreateFileReq req) throws Exception {
        return this.createFile(req, null);
    }

    public AppAccessTokenResp getAppAccessTokenBySelfBuiltApp(SelfBuiltAppAccessTokenReq req) throws Exception {
        RawResponse resp = Transport.send(this.config, new RequestOptions(), "POST", "/open-apis/auth/v3/app_access_token/internal", Sets.newHashSet(AccessTokenType.None), req);
        AppAccessTokenResp appAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, AppAccessTokenResp.class);
        appAccessTokenResp.setRawResponse(resp);
        return appAccessTokenResp;
    }

    public AppAccessTokenResp getAppAccessTokenByMarketplaceApp(MarketplaceAppAccessTokenReq req) throws Exception {
        RawResponse resp = Transport.send(this.config, new RequestOptions(), "POST", "/open-apis/auth/v3/app_access_token", Sets.newHashSet(AccessTokenType.None), req);
        AppAccessTokenResp appAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, AppAccessTokenResp.class);
        appAccessTokenResp.setRawResponse(resp);
        return appAccessTokenResp;
    }

    public TenantAccessTokenResp getTenantAccessTokenBySelfBuiltApp(SelfBuiltTenantAccessTokenReq req) throws Exception {
        RawResponse resp = Transport.send(this.config, new RequestOptions(), "POST", "/open-apis/auth/v3/tenant_access_token/internal", Sets.newHashSet(AccessTokenType.None), req);
        TenantAccessTokenResp tenantAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, TenantAccessTokenResp.class);
        tenantAccessTokenResp.setRawResponse(resp);
        return tenantAccessTokenResp;
    }

    public TenantAccessTokenResp getTenantAccessTokenByMarketplaceApp(MarketplaceTenantAccessTokenReq req) throws Exception {
        RawResponse resp = Transport.send(this.config, new RequestOptions(), "POST", "/open-apis/auth/v3/tenant_access_token", Sets.newHashSet(AccessTokenType.None), req);
        TenantAccessTokenResp tenantAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, TenantAccessTokenResp.class);
        tenantAccessTokenResp.setRawResponse(resp);
        return tenantAccessTokenResp;
    }

    public AuthenAccessTokenResp getAuthenAccessToken(AuthenAccessTokenReq req) throws Exception {
        RawResponse resp = Transport.send(this.config, new RequestOptions(), "POST", "/open-apis/authen/v1/access_token", Sets.newHashSet(AccessTokenType.App), req);
        AuthenAccessTokenResp authenAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, AuthenAccessTokenResp.class);
        authenAccessTokenResp.setRawResponse(resp);
        return authenAccessTokenResp;
    }

    public AuthenAccessTokenResp getAuthenAccessToken(AuthenAccessTokenReq req, RequestOptions requestOptions) throws Exception {
        RawResponse resp = Transport.send(this.config, requestOptions, "POST", "/open-apis/authen/v1/access_token", Sets.newHashSet(AccessTokenType.App), req);
        AuthenAccessTokenResp authenAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, AuthenAccessTokenResp.class);
        authenAccessTokenResp.setRawResponse(resp);
        return authenAccessTokenResp;
    }

    public RefreshAuthenAccessTokenResp refreshAuthenAccessToken(RefreshAuthenAccessTokenReq req, RequestOptions requestOptions) throws Exception {
        RawResponse resp = Transport.send(this.config, requestOptions, "POST", "/open-apis/authen/v1/refresh_access_token", Sets.newHashSet(AccessTokenType.App), req);
        RefreshAuthenAccessTokenResp authenAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, RefreshAuthenAccessTokenResp.class);
        authenAccessTokenResp.setRawResponse(resp);
        return authenAccessTokenResp;
    }

    public RefreshAuthenAccessTokenResp refreshAuthenAccessToken(RefreshAuthenAccessTokenReq req) throws Exception {
        RawResponse resp = Transport.send(this.config, new RequestOptions(), "POST", "/open-apis/authen/v1/refresh_access_token", Sets.newHashSet(AccessTokenType.App), req);
        RefreshAuthenAccessTokenResp authenAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, RefreshAuthenAccessTokenResp.class);
        authenAccessTokenResp.setRawResponse(resp);
        return authenAccessTokenResp;
    }

    public GetAuthenUserInfoResp getAuthenUserInfo(RequestOptions requestOptions) throws Exception {
        RawResponse resp = Transport.send(this.config, requestOptions, "GET", "/open-apis/authen/v1/user_info", Sets.newHashSet(AccessTokenType.User), null);
        GetAuthenUserInfoResp authenAccessTokenResp = UnmarshalRespUtil.unmarshalResp(resp, GetAuthenUserInfoResp.class);
        authenAccessTokenResp.setRawResponse(resp);
        return authenAccessTokenResp;
    }
}

