/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.board.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.board.v1.model.DownloadAsImageWhiteboardReq;
import com.lark.oapi.service.board.v1.model.DownloadAsImageWhiteboardResp;
import com.lark.oapi.service.board.v1.model.ThemeWhiteboardReq;
import com.lark.oapi.service.board.v1.model.ThemeWhiteboardResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Whiteboard {
    private static final Logger log = LoggerFactory.getLogger(Whiteboard.class);
    private final Config config;

    public Whiteboard(Config config) {
        this.config = config;
    }

    public DownloadAsImageWhiteboardResp downloadAsImage(DownloadAsImageWhiteboardReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/board/v1/whiteboards/:whiteboard_id/download_as_image", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        if (httpResponse.getStatusCode() == 200) {
            DownloadAsImageWhiteboardResp resp = new DownloadAsImageWhiteboardResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        DownloadAsImageWhiteboardResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadAsImageWhiteboardResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/board/v1/whiteboards/:whiteboard_id/download_as_image", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public DownloadAsImageWhiteboardResp downloadAsImage(DownloadAsImageWhiteboardReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/board/v1/whiteboards/:whiteboard_id/download_as_image", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        if (httpResponse.getStatusCode() == 200) {
            DownloadAsImageWhiteboardResp resp = new DownloadAsImageWhiteboardResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        DownloadAsImageWhiteboardResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadAsImageWhiteboardResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/board/v1/whiteboards/:whiteboard_id/download_as_image", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ThemeWhiteboardResp theme(ThemeWhiteboardReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        ThemeWhiteboardResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/board/v1/whiteboards/:whiteboard_id/theme", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req), ThemeWhiteboardResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/board/v1/whiteboards/:whiteboard_id/theme", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ThemeWhiteboardResp theme(ThemeWhiteboardReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/board/v1/whiteboards/:whiteboard_id/theme", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
        ThemeWhiteboardResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ThemeWhiteboardResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/board/v1/whiteboards/:whiteboard_id/theme", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

