/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

class Util {
    Util() {
    }

    static <T, M extends T> Optional<M> tryCast(T original, Class<M> too) {
        if (original != null && too.isAssignableFrom(original.getClass())) {
            return Optional.of(original);
        }
        return Optional.empty();
    }

    static Stream<Exception> collectExceptions(Optional<Exception> ... ex) {
        return Stream.of(ex).flatMap(Util::stream);
    }

    static <T> Stream<T> stream(Optional<T> opt) {
        return opt.map(Stream::of).orElseGet(Stream::empty);
    }

    static <T> Optional<Exception> tryDo(T c, ExConsumer<T> consumer) {
        try {
            if (Objects.nonNull(c)) {
                consumer.accept(c);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    @FunctionalInterface
    public static interface ExConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

