/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.stream.Collectors;

public class XRControlChartUtil {
    public static BigDecimal calculateTotalAvgXBar(List<BigDecimal> dataList) {
        if (dataList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return CommonUtil.getAverage(dataList);
    }

    public static BigDecimal calculateRBar(List<List<BigDecimal>> subgroupDataList) {
        if (subgroupDataList == null || subgroupDataList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List subgroupRanges = subgroupDataList.stream().filter(subgroup -> subgroup != null && subgroup.size() >= 2).map(subgroup -> {
            BigDecimal minVal = subgroup.stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            BigDecimal maxVal = subgroup.stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            return maxVal.subtract(minVal);
        }).collect(Collectors.toList());
        if (subgroupRanges.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalRangeSum = subgroupRanges.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalRangeSum.divide(new BigDecimal(subgroupRanges.size()), MathContext.DECIMAL128);
    }

    public static BigDecimal calculateXBarChartUCL(BigDecimal xBarTotalMean, BigDecimal a2, BigDecimal rBar) {
        return xBarTotalMean.add(a2.multiply(rBar));
    }

    public static BigDecimal calculateXBarChartLCL(BigDecimal xBarTotalMean, BigDecimal a2, BigDecimal rBar) {
        BigDecimal lcl = xBarTotalMean.subtract(a2.multiply(rBar));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal calculateRChartUCL(BigDecimal d4, BigDecimal rBar) {
        return d4.multiply(rBar);
    }

    public static BigDecimal calculateRChartLCL(BigDecimal d3, BigDecimal rBar) {
        BigDecimal lcl = d3.multiply(rBar);
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal calculateWithinGroupStdev(BigDecimal rBar, BigDecimal d2) {
        if (d2.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Division by zero: d2 cannot be zero.");
        }
        return rBar.divide(d2, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateRChartRangeStdev(List<BigDecimal> subgroupRangeList) {
        if (subgroupRangeList == null || subgroupRangeList.size() < 2) {
            return BigDecimal.ZERO;
        }
        BigDecimal meanR = subgroupRangeList.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(new BigDecimal(subgroupRangeList.size()), MathContext.DECIMAL128);
        BigDecimal sumOfSquares = subgroupRangeList.stream().map(range -> range.subtract(meanR)).map(diff -> diff.multiply((BigDecimal)diff)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal variance = sumOfSquares.divide(new BigDecimal(subgroupRangeList.size() - 1), MathContext.DECIMAL128);
        return CommonUtil.getSqrt(variance);
    }
}

