/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class IMRControlChartUtil {
    public static Number calculateIndividualTotalAvg(List<Number> individualData) {
        if (individualData.isEmpty()) {
            return 0;
        }
        return individualData.stream().mapToDouble(Number::doubleValue).average().orElse(0.0);
    }

    public static Number calculateMRBar(List<Number> individualData) {
        if (individualData.size() < 2) {
            return 0;
        }
        double sumMR = 0.0;
        for (int i = 1; i < individualData.size(); ++i) {
            sumMR += Math.abs(individualData.get(i).doubleValue() - individualData.get(i - 1).doubleValue());
        }
        return sumMR / (double)(individualData.size() - 1);
    }

    public static BigDecimal calculateIChartUCL(BigDecimal individualTotalAvg, BigDecimal e2, BigDecimal mrBar) {
        return individualTotalAvg.add(e2.multiply(mrBar));
    }

    public static BigDecimal calculateIChartLCL(BigDecimal individualTotalAvg, BigDecimal e2, BigDecimal mrBar) {
        BigDecimal lcl = individualTotalAvg.subtract(e2.multiply(mrBar));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal calculateMRChartUCL(BigDecimal d4, BigDecimal mrBar) {
        return d4.multiply(mrBar);
    }

    public static BigDecimal calculateMRChartLCL(BigDecimal d3, BigDecimal mrBar) {
        BigDecimal lcl = d3.multiply(mrBar);
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal estimateProcessStdevFromMRBar(BigDecimal mrBar, BigDecimal d2) {
        if (d2.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Division by zero: d2 cannot be zero.");
        }
        return mrBar.divide(d2, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateWithinGroupSigma(BigDecimal movingRange) {
        BigDecimal SQRT_2 = new BigDecimal(Math.sqrt(2.0));
        if (movingRange.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return movingRange.divide(SQRT_2, MathContext.DECIMAL128);
    }
}

