/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.counting;

import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class PChartUtils {
    public static BigDecimal calculatePBar(List<Integer> npList, List<Integer> nList) {
        BigDecimal totalNP = npList.stream().map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalInspected = nList.stream().map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalNP.divide(totalInspected, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateSigmaList(BigDecimal pBar, BigDecimal detectNum) {
        BigDecimal oneMinusPBar = BigDecimal.ONE.subtract(pBar);
        BigDecimal variance = pBar.multiply(oneMinusPBar).divide(detectNum, MathContext.DECIMAL128);
        return CommonUtil.sqrt(variance, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateUCLList(BigDecimal cl, BigDecimal sigma) {
        BigDecimal three = BigDecimal.valueOf(3L);
        return cl.add(three.multiply(sigma, MathContext.DECIMAL128));
    }

    public static BigDecimal calculateLCLList(BigDecimal cl, BigDecimal sigma) {
        BigDecimal three = BigDecimal.valueOf(3L);
        BigDecimal lcl = cl.subtract(three.multiply(sigma, MathContext.DECIMAL128));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }
}

