/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.counting;

import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class CChartUtils {
    public static BigDecimal calculateCBar(List<Integer> cList) {
        BigDecimal totalC = cList.stream().map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal groupCount = BigDecimal.valueOf(cList.size());
        return totalC.divide(groupCount, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateSigma(BigDecimal cBar) {
        return CommonUtil.sqrt(cBar, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateUCL(BigDecimal cl, BigDecimal sigma) {
        return cl.add(sigma.multiply(new BigDecimal("3")));
    }

    public static BigDecimal calculateLCL(BigDecimal cl, BigDecimal sigma) {
        BigDecimal lcl = cl.subtract(sigma.multiply(new BigDecimal("3")));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }
}

