/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.common;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class NumberConvertUtil {
    public static BigDecimal stringToBigDecimal(String source, int scale, RoundingMode roundingMode) {
        BigDecimal bigDecimal;
        if (source == null || source.trim().isEmpty()) {
            throw new IllegalArgumentException("\u5f85\u8f6c\u6362\u5b57\u7b26\u4e32\u4e0d\u53ef\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("\u76ee\u6807\u7cbe\u5ea6\uff08scale\uff09\u4e0d\u53ef\u5c0f\u4e8e0\uff0c\u5f53\u524d\u4f20\u5165\uff1a" + scale);
        }
        if (roundingMode == null) {
            throw new IllegalArgumentException("\u820d\u5165\u6a21\u5f0f\uff08roundingMode\uff09\u4e0d\u53ef\u4e3anull");
        }
        try {
            bigDecimal = new BigDecimal(source.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u65e0\u6cd5\u89e3\u6790\u4e3a\u6709\u6548\u6570\u5b57\uff0c\u5f53\u524d\u5b57\u7b26\u4e32\uff1a" + source, e);
        }
        return bigDecimal.setScale(scale, roundingMode);
    }

    public static Number stringToNumber(String source, int scale, RoundingMode roundingMode) {
        return NumberConvertUtil.stringToBigDecimal(source, scale, roundingMode);
    }

    public static BigDecimal stringToBigDecimal(String source, int scale) {
        return NumberConvertUtil.stringToBigDecimal(source, scale, RoundingMode.HALF_UP);
    }

    public static Number stringToNumber(String source, int scale) {
        return NumberConvertUtil.stringToNumber(source, scale, RoundingMode.HALF_UP);
    }
}

