/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.common;

import com.jxdinfo.spc.formula.api.util.aviator.AviatorKit;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

public class CommonUtil {
    public static BigDecimal getAverage(List<BigDecimal> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = dataList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.divide(new BigDecimal(dataList.size()), MathContext.DECIMAL128);
    }

    public static BigDecimal getMax(List<BigDecimal> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            throw new RuntimeException("Data list cannot be empty for max calculation.");
        }
        return (BigDecimal)dataList.stream().max(BigDecimal::compareTo).orElseThrow(() -> new NoSuchElementException("No max value found in non-empty list"));
    }

    public static BigDecimal getMin(List<BigDecimal> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            throw new RuntimeException("Data list cannot be empty for min calculation.");
        }
        return (BigDecimal)dataList.stream().min(BigDecimal::compareTo).orElseThrow(() -> new NoSuchElementException("No min value found in non-empty list"));
    }

    public static Number getStdev(final List<BigDecimal> rangeList) {
        return AviatorKit.execute("STDEV(arg)", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("arg", rangeList);
            }
        });
    }

    public static Number getNormdist(final Number x, final Number mean, final Number sigma, final boolean cumulative) {
        return AviatorKit.execute("NORMDIST(x,mean,sigma,cumulative)", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("x", x);
                this.put("mean", mean);
                this.put("sigma", sigma);
                this.put("cumulative", cumulative);
            }
        });
    }

    public static BigDecimal getRange(List<BigDecimal> batch) {
        if (batch == null || batch.isEmpty()) {
            throw new RuntimeException("Data list cannot be empty for range calculation.");
        }
        if (batch.size() == 1) {
            return BigDecimal.ZERO;
        }
        return CommonUtil.getMax(batch).subtract(CommonUtil.getMin(batch));
    }

    public static BigDecimal getSum(List<BigDecimal> batch) {
        if (batch == null || batch.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return batch.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getAbs(BigDecimal value) {
        return value.abs();
    }

    public static BigDecimal getSqrt(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            throw new RuntimeException("Square root is undefined for negative numbers.");
        }
        return CommonUtil.sqrt(value, MathContext.DECIMAL128);
    }

    public static List<BigDecimal> cleanRawData(List<BigDecimal> rawData) {
        if (rawData == null || rawData.isEmpty()) {
            return new ArrayList<BigDecimal>();
        }
        return rawData.stream().filter(Objects::nonNull).filter(bd -> {
            double val = bd.doubleValue();
            return !Double.isInfinite(val) && !Double.isNaN(val);
        }).collect(Collectors.toList());
    }

    public static BigDecimal calculateChartStdev(BigDecimal ucl, BigDecimal lcl, BigDecimal cl) {
        if (cl == null) {
            return BigDecimal.ZERO;
        }
        if (ucl != null) {
            return ucl.subtract(cl).divide(new BigDecimal("3"), MathContext.DECIMAL128);
        }
        if (lcl != null && cl.compareTo(lcl) > 0) {
            return cl.subtract(lcl).divide(new BigDecimal("3"), MathContext.DECIMAL128);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal sqrt(BigDecimal value, MathContext mc) {
        BigDecimal x1;
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            throw new RuntimeException("Cannot compute square root of a negative number: " + value);
        }
        if (value.compareTo(BigDecimal.ZERO) == 0 || value.compareTo(BigDecimal.ONE) == 0) {
            return value.round(mc);
        }
        BigDecimal x0 = value.divide(new BigDecimal("2"), mc);
        BigDecimal two = BigDecimal.valueOf(2L);
        int maxIterations = 100;
        int iteration = 0;
        while ((x1 = x0.add(value.divide(x0, mc)).divide(two, mc)).compareTo(x0) != 0) {
            x0 = x1;
            if (iteration++ < maxIterations) continue;
        }
        return x1.round(mc);
    }

    public static BigDecimal calculateOverallSigma(List<BigDecimal> allData) {
        BigDecimal grandMean = CommonUtil.getAverage(allData);
        BigDecimal totalCount = new BigDecimal(allData.size());
        BigDecimal sumOfSquares = allData.stream().map(x -> x.subtract(grandMean)).map(diff -> diff.multiply((BigDecimal)diff)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal variance = sumOfSquares.divide(totalCount.subtract(BigDecimal.ONE), MathContext.DECIMAL128);
        return CommonUtil.sqrt(variance, MathContext.DECIMAL128);
    }
}

