/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.uicore.callback.OnClickItemListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class MyFileAdapter
extends BaseAdapter {
    private List<String> items = null;
    private Context mContext;
    private Map<String, String> documentInfo;
    private OnClickItemListener onClickItemListener;

    public MyFileAdapter(Context mContext) {
        this.mContext = mContext;
    }

    public void upData(List<String> items, Map<String, String> docmentInfo) {
        this.items = items;
        this.documentInfo = docmentInfo;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public Object getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView != null) {
            viewHolder = (ViewHolder)convertView.getTag();
        } else {
            viewHolder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.settings_recycle_item_myfile, parent, false);
            viewHolder.imaeView = (ImageView)convertView.findViewById(R.id.avaster);
            viewHolder.name = (TextView)convertView.findViewById(R.id.realname);
            viewHolder.size = (TextView)convertView.findViewById(R.id.content);
            viewHolder.deleteMember = (ImageView)convertView.findViewById(R.id.ima_delete_member);
            convertView.setTag((Object)viewHolder);
        }
        String name = this.items.get(position);
        String path = this.documentInfo.get(name);
        File file = new File(path);
        viewHolder.name.setText((CharSequence)file.getName());
        if (file.isDirectory()) {
            viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_folder);
            viewHolder.deleteMember.setVisibility(8);
            viewHolder.size.setText((CharSequence)"");
        } else {
            viewHolder.deleteMember.setVisibility(8);
            viewHolder.deleteMember.setOnClickListener(null);
            String filename = path.substring(path.lastIndexOf(File.separator) + 1);
            int i = filename.lastIndexOf(".");
            String token = "";
            if (i >= 0) {
                token = filename.substring(i + 1);
            }
            viewHolder.size.setText((CharSequence)this.showLongFileSzie(file.length()));
            viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_file_90x90);
            if (token != null) {
                if (token.contains("doc")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_word_90x90);
                } else if (token.contains("zip") || token.contains("rar") || token.contains("jar") || token.contains("cab") || token.contains("iso") || token.contains("gz")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_zip_90x90);
                } else if (token.contains("avi") || token.contains("rmvb") || token.contains("rm") || token.contains("asf") || token.contains("divx") || token.contains("mpg") || token.contains("mpeg") || token.contains("mpe") || token.contains("wmv") || token.contains("mp4") || token.contains("mkv") || token.contains("vob")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_video_90x90);
                } else if (token.contains("txt")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_text_90x90);
                } else if (token.contains("ppt")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_ppt_90x90);
                } else if (token.contains("pdf")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_pdf_90x90);
                } else if (token.contains("bmp") || token.contains("pcx") || token.contains("png") || token.contains("jpeg") || token.contains("gif") || token.contains("tiff") || token.contains("jpg")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_image_90x90);
                } else if (token.contains("xls") || token.contains("xlsx") || token.contains("xlsm")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_excel_90x90);
                } else if (token.contains("mp3") || token.contains("wav") || token.contains("cda") || token.contains("midi") || token.contains("ogg") || token.contains("amr") || token.contains("aac") || token.contains("m4a")) {
                    viewHolder.imaeView.setImageResource(R.mipmap.mp_uicore_file_audio_90x90);
                }
            }
            viewHolder.deleteMember.setVisibility(8);
            viewHolder.deleteMember.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MyFileAdapter.this.onClickItemListener != null) {
                        MyFileAdapter.this.onClickItemListener.onClickItemListener(position);
                    }
                }
            });
        }
        return convertView;
    }

    public String showLongFileSzie(Long length) {
        if (length >= 0x100000L) {
            float f = (float)length.longValue() / 1048576.0f;
            BigDecimal b = new BigDecimal(f);
            float f1 = b.setScale(2, 4).floatValue();
            return f1 + "MB";
        }
        if (length >= 1024L) {
            float f = (float)length.longValue() / 1024.0f;
            BigDecimal b = new BigDecimal(f);
            float f1 = b.setScale(2, 4).floatValue();
            return f1 + "KB";
        }
        if (length < 1024L) {
            return length + "B";
        }
        return "0KB";
    }

    public void setOnClickItemListener(OnClickItemListener onClickItemListener) {
        this.onClickItemListener = onClickItemListener;
    }

    class ViewHolder {
        ImageView imaeView;
        TextView name;
        TextView size;
        ImageView deleteMember;

        ViewHolder() {
        }
    }
}

