/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import butterknife.BindView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.commonkit.ui.activity.ClearCacheActivity;
import com.jxdinfo.mp.commonkit.ui.activity.CommomBaseActivity;
import com.jxdinfo.mp.commonkit.ui.activity.CompActivity;
import com.jxdinfo.mp.commonkit.ui.activity.DownloadAppActivity;
import com.jxdinfo.mp.commonkit.ui.activity.IconShapeActivity;
import com.jxdinfo.mp.sdk.commonlib.bean.VersionInfo;
import com.jxdinfo.mp.sdk.commonlib.client.CommonClient;
import com.jxdinfo.mp.sdk.core.callback.ResultCallback;
import com.jxdinfo.mp.sdk.core.net.model.ApiResponse;
import com.jxdinfo.mp.sdk.core.utils.AppUtil;
import com.jxdinfo.mp.sdk.core.utils.IntentUtil;
import com.jxdinfo.mp.sdk.push.client.PushClient;
import com.jxdinfo.mp.uicore.base.ToolbarStyle;
import com.jxdinfo.mp.uicore.crossmodule.IIMService;
import com.jxdinfo.mp.uicore.crossmodule.IJqxService;
import com.jxdinfo.mp.uicore.customview.dialog.BaseButtonDialog;
import com.jxdinfo.mp.uicore.customview.dialog.TitleButtonDialog;
import com.jxdinfo.mp.uicore.util.AppDialogUtil;
import com.jxdinfo.mp.uicore.util.Glide.GlideCachUtil;
import com.jxdinfo.mp.uicore.util.ToastUtil;

public class SettingsActivity
extends CommomBaseActivity {
    @BindView(value=2131492994)
    TextView tvDownloadBtn;
    @BindView(value=2131493387)
    TextView tvChangeThemeBtn;
    @BindView(value=2131493385)
    TextView tvChangeCompBtn;
    @BindView(value=2131493120)
    View downLoadLine;
    @BindView(value=2131493348)
    TextView tvClearCacheBtn;
    @BindView(value=2131493407)
    ImageView newVersion;
    @BindView(value=2131493422)
    TextView versionInfo;
    private TitleButtonDialog updateDialog;
    private TitleButtonDialog alertDialog;
    private BaseButtonDialog clearCacheDialog;
    private String downloadUrl;

    protected void onCreate(Bundle savedInstanceState) {
        this.setToolbarStyle(ToolbarStyle.TITLE_MIDDLE);
        super.onCreate(savedInstanceState);
    }

    protected int setupDataView() {
        return R.layout.settings_activity_main;
    }

    private void setCacheSize() {
        String cacheSize = GlideCachUtil.getInstance().getCacheSize((Context)this);
        if (TextUtils.isEmpty((CharSequence)cacheSize)) {
            cacheSize = "0.0B";
        }
        this.tvClearCacheBtn.setText((CharSequence)cacheSize);
    }

    protected boolean onKeyBack() {
        return false;
    }

    protected boolean onKeyMenu() {
        return false;
    }

    protected void getExras() {
    }

    protected void initDataView() {
        this.checkVersion(false);
        boolean suggestDown = false;
        try {
            ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
            if (appInfo != null) {
                suggestDown = appInfo.metaData.getBoolean("DOWNLOAD_SUGGEST");
            }
        }
        catch (Exception ex) {
            ex.getMessage();
        }
        if (suggestDown) {
            this.tvDownloadBtn.setVisibility(0);
            this.downLoadLine.setVisibility(0);
        } else {
            this.tvDownloadBtn.setVisibility(8);
            this.downLoadLine.setVisibility(8);
        }
        if (AppUtil.getMetaDataBoolean((Context)this, (String)"PROBATION", (boolean)false)) {
            this.tvChangeCompBtn.setVisibility(0);
            this.findViewById(R.id.line_abovecomp).setVisibility(0);
        } else {
            this.tvChangeCompBtn.setVisibility(8);
            this.findViewById(R.id.line_abovecomp).setVisibility(8);
        }
        String appVersion = "";
        try {
            appVersion = this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionName + "";
            this.versionInfo.setText((CharSequence)("\u7248\u672c\u4fe1\u606f\uff08" + appVersion + "\uff09"));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.setTitle("\u8bbe\u7f6e");
        this.setCacheSize();
    }

    public void setting(View view) {
        int i = view.getId();
        if (i == R.id.newNotice_set) {
            ARouter.getInstance().build("/im/newsnoticeactivity").navigation();
        } else if (i == R.id.unlogin_set) {
            if (this.alertDialog == null) {
                this.alertDialog = new TitleButtonDialog((Context)this, false);
            }
            this.alertDialog.setTitle("\u7cfb\u7edf\u63d0\u793a");
            this.alertDialog.setText("\u9000\u51fa\u540e\u65e0\u6cd5\u63a5\u6536\u79bb\u7ebf\u901a\u77e5\uff0c\u8981\u9000\u51fa\u5417\uff1f");
            this.alertDialog.setButtonListener(new TitleButtonDialog.OnButtonListener(){

                public void onLeftButtonClick(TitleButtonDialog dialog) {
                    SettingsActivity.this.alertDialog.dismiss();
                }

                public void onRightButtonClick(TitleButtonDialog dialog) {
                    SettingsActivity.this.clearId();
                    SettingsActivity.this.alertDialog.dismiss();
                }
            });
            this.alertDialog.show();
        } else if (i == R.id.download_app) {
            Intent intent = new Intent((Context)this, DownloadAppActivity.class);
            intent.putExtra(DownloadAppActivity.DOWNLOAD_URL, this.downloadUrl);
            this.startActivity(intent);
        } else if (i == R.id.cache_set) {
            Intent intent = new Intent((Context)this, ClearCacheActivity.class);
            this.startActivity(intent);
        } else if (i == R.id.tv_change_theme) {
            ToastUtil.showLongToast((Context)this, (String)"\u6b63\u5728\u5f00\u53d1\u4e2d");
        } else if (i == R.id.ll_version_control) {
            this.checkVersion(true);
        } else if (i == R.id.tv_change_icon_shape) {
            Intent intent = new Intent((Context)this, IconShapeActivity.class);
            this.startActivity(intent);
        } else if (i == R.id.tv_change_comp) {
            Intent intent = new Intent((Context)this, CompActivity.class);
            this.startActivity(intent);
        }
    }

    private void checkVersion(final boolean showDialog) {
        IJqxService iJqxService = (IJqxService)ARouter.getInstance().build("/jqx_service/common_service").navigation();
        String appKeyPublishPlatform = iJqxService.getAppKeyPublishPlatform();
        String appPublishPlatformUrl = iJqxService.getAppPublishPlatformUrl();
        CommonClient.getInstance().getNewVersionInfo(appPublishPlatformUrl, appKeyPublishPlatform, (ResultCallback)new ResultCallback<ApiResponse<VersionInfo>>(){

            public void onStart() {
                if (showDialog) {
                    AppDialogUtil.getInstance((Context)SettingsActivity.this).showProgressDialog("\u68c0\u67e5\u66f4\u65b0\u4e2d");
                }
            }

            public void onSuccess(ApiResponse<VersionInfo> apiResponse) {
                if (apiResponse == null) {
                    return;
                }
                final VersionInfo versionInfo = (VersionInfo)apiResponse.getData();
                if (versionInfo != null) {
                    SettingsActivity.this.downloadUrl = versionInfo.getDownloadUrl();
                    String versionName = "";
                    try {
                        PackageInfo packageInfo = SettingsActivity.this.getPackageManager().getPackageInfo(SettingsActivity.this.getPackageName(), 0);
                        versionName = packageInfo.versionName;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (!TextUtils.equals((CharSequence)versionName, (CharSequence)versionInfo.getVersion())) {
                        SettingsActivity.this.newVersion.setVisibility(0);
                        if (showDialog) {
                            if (SettingsActivity.this.updateDialog == null) {
                                SettingsActivity.this.updateDialog = new TitleButtonDialog((Context)SettingsActivity.this, false);
                            }
                            SettingsActivity.this.updateDialog.setTitle("\u53d1\u73b0\u65b0\u7248\u672c" + versionInfo.getVersion());
                            String versionExplain = versionInfo.getAppDescribe();
                            versionExplain = versionExplain == null ? "" : versionExplain;
                            versionExplain = versionExplain.replace("\\n", "\n");
                            SettingsActivity.this.updateDialog.setText(versionExplain + (TextUtils.isEmpty((CharSequence)versionExplain) ? "" : "\n") + "\u662f\u5426\u73b0\u5728\u5347\u7ea7");
                            SettingsActivity.this.updateDialog.setButtonListener(new TitleButtonDialog.OnButtonListener(){

                                public void onLeftButtonClick(TitleButtonDialog dialog) {
                                    SettingsActivity.this.updateDialog.dismiss();
                                }

                                public void onRightButtonClick(TitleButtonDialog dialog) {
                                    Intent systemBrowser = IntentUtil.getSystemBrowser((String)versionInfo.getDownloadUrl());
                                    SettingsActivity.this.startActivity(systemBrowser);
                                    SettingsActivity.this.updateDialog.dismiss();
                                }
                            });
                            SettingsActivity.this.updateDialog.show();
                        }
                    } else if (showDialog) {
                        ToastUtil.showShortToast((Context)SettingsActivity.this, (String)"\u5df2\u7ecf\u662f\u6700\u65b0\u7248\u672c\u4e86");
                    }
                }
                AppDialogUtil.getInstance((Context)SettingsActivity.this).cancelProgressDialogImmediately();
            }

            public void onError(Exception e) {
                AppDialogUtil.getInstance((Context)SettingsActivity.this).cancelProgressDialog();
                if (showDialog) {
                    ToastUtil.showShortToast((Context)SettingsActivity.this, (String)"\u68c0\u67e5\u66f4\u65b0\u51fa\u9519");
                }
            }
        });
    }

    private void clearId() {
        PushClient.getInstance().clearPushId((ResultCallback)new ResultCallback<Boolean>(){

            public void onStart() {
                AppDialogUtil.getInstance((Context)SettingsActivity.this).showProgressDialog("\u6ce8\u9500\u4e2d...");
            }

            public void onSuccess(Boolean aBoolean) {
                SettingsActivity.this.logout();
            }

            public void onError(Exception e) {
                SettingsActivity.this.logout();
            }
        });
    }

    private void logout() {
        this.alertDialog.dismiss();
        AppDialogUtil.getInstance((Context)this).cancelProgressDialog();
        ARouter.getInstance().build("/login/loginactivity").navigation();
        IIMService iimService = (IIMService)ARouter.getInstance().build("/im_service/recconect_im_service").navigation();
        iimService.logout((Activity)this);
        this.finish();
    }

    private void showClearCache() {
        if (this.clearCacheDialog == null) {
            this.clearCacheDialog = new BaseButtonDialog((Context)this);
            this.clearCacheDialog.setText("\u786e\u5b9a\u6e05\u9664\u7f13\u5b58\u5417?");
            this.clearCacheDialog.setButtonListener(new BaseButtonDialog.OnButtonListener(){

                public void onLeftButtonClick(BaseButtonDialog dialog) {
                    dialog.dismiss();
                }

                public void onRightButtonClick(BaseButtonDialog dialog) {
                    AppDialogUtil.getInstance((Context)SettingsActivity.this).showProgressDialog("\u6b63\u5728\u6e05\u9664...");
                    GlideCachUtil.getInstance().clearImageMemoryCache((Context)SettingsActivity.this);
                    GlideCachUtil.getInstance().clearImageDiskCache((Context)SettingsActivity.this, () -> {
                        AppDialogUtil.getInstance((Context)SettingsActivity.this).cancelProgressDialogImmediately();
                        SettingsActivity.this.setCacheSize();
                        ToastUtil.showShortToast((Context)SettingsActivity.this, (String)"\u7f13\u5b58\u5df2\u6e05\u9664");
                    });
                    dialog.dismiss();
                }
            });
        }
        this.clearCacheDialog.show();
    }
}

