/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.widget.ListAdapter;
import android.widget.ListView;
import butterknife.BindView;
import com.google.android.material.tabs.TabLayout;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.commonkit.ui.activity.CommomBaseActivity;
import com.jxdinfo.mp.commonkit.ui.adapter.MyFileAdapter;
import com.jxdinfo.mp.sdk.core.client.SDKInit;
import com.jxdinfo.mp.sdk.core.net.http.exception.ApiException;
import com.jxdinfo.mp.sdk.core.utils.FileUtil;
import com.jxdinfo.mp.uicore.base.ToolbarStyle;
import com.jxdinfo.mp.uicore.customview.HttpNoticeView;
import com.jxdinfo.mp.uicore.customview.dialog.TitleButtonDialog;
import com.jxdinfo.mp.uicore.util.ToastUtil;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MyFileActivity
extends CommomBaseActivity {
    @BindView(value=2131493335)
    TabLayout tableLayout;
    @BindView(value=2131493128)
    ListView lvFileList;
    @BindView(value=2131493041)
    HttpNoticeView httpNoticeView;
    private List<String> items = null;
    private String rootPath;
    private MyFileAdapter fileAdapter;
    private Map<String, String> documentInfo;
    private String currentType;
    private String currentFilePath;
    private TitleButtonDialog deleteDialog;
    private boolean isfirst = false;

    protected void onCreate(Bundle savedInstanceState) {
        this.setToolbarStyle(ToolbarStyle.TITLE_MIDDLE);
        super.onCreate(savedInstanceState);
    }

    protected int setupDataView() {
        return R.layout.settings_activity_my_file;
    }

    private void initList() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            this.initFile("document");
        }
    }

    private void initListener() {
        this.lvFileList.setOnItemClickListener((parent, view, position, id2) -> {
            block3: {
                String path = this.documentInfo.get(this.items.get(position));
                File file = new File(path);
                if (file == null || !file.exists()) {
                    ToastUtil.showLongToast((Context)this.mContext, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
                    return;
                }
                try {
                    FileUtil.openFile((String)path, (Context)this.mContext);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!(e instanceof ApiException)) break block3;
                    ToastUtil.showLongToast((Context)this.mContext, (String)("" + e.getMessage()));
                }
            }
        });
        this.lvFileList.setOnItemLongClickListener((parent, view, position, id2) -> {
            String path = this.documentInfo.get(this.items.get(position));
            final File file = new File(path);
            if (file != null && file.exists()) {
                if (this.deleteDialog == null) {
                    this.deleteDialog = new TitleButtonDialog((Context)this.mContext, false);
                }
                this.deleteDialog.setTitle("\u63d0\u793a");
                this.deleteDialog.setText("\u786e\u5b9a\u5220\u9664" + file.getName() + "?");
                this.deleteDialog.setButtonListener(new TitleButtonDialog.OnButtonListener(){

                    public void onLeftButtonClick(TitleButtonDialog dialog) {
                        MyFileActivity.this.deleteDialog.dismiss();
                    }

                    public void onRightButtonClick(TitleButtonDialog dialog) {
                        MyFileActivity.this.deleteFile(file);
                        MyFileActivity.this.deleteDialog.dismiss();
                    }
                });
                this.deleteDialog.show();
            } else {
                ToastUtil.showLongToast((Context)this.mContext, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            return true;
        });
        this.tableLayout.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                switch (tab.getPosition()) {
                    case 0: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "document");
                        break;
                    }
                    case 1: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "picture");
                        break;
                    }
                    case 2: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "package");
                        break;
                    }
                    case 3: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "av");
                        break;
                    }
                    default: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "others");
                    }
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
    }

    private void deleteFile(File file) {
        boolean deleted = false;
        if (file.isFile()) {
            deleted = file.delete();
        }
        if (deleted) {
            this.initFile(this.currentType);
        }
    }

    protected boolean onKeyBack() {
        return false;
    }

    protected boolean onKeyMenu() {
        return false;
    }

    protected void getExras() {
    }

    private void initFile(String type) {
        try {
            this.switchListView(this.rootPath, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        this.fileAdapter = new MyFileAdapter((Context)this);
        this.lvFileList.setAdapter((ListAdapter)this.fileAdapter);
    }

    private void initTab() {
        this.tableLayout.setTabMode(1);
        this.tableLayout.addTab(this.tableLayout.newTab().setText((CharSequence)"\u6587\u6863"));
        this.tableLayout.addTab(this.tableLayout.newTab().setText((CharSequence)"\u56fe\u7247"));
        this.tableLayout.addTab(this.tableLayout.newTab().setText((CharSequence)"\u538b\u7f29\u5305"));
        this.tableLayout.addTab(this.tableLayout.newTab().setText((CharSequence)"\u5f71\u97f3"));
        this.tableLayout.addTab(this.tableLayout.newTab().setText((CharSequence)"\u5176\u4ed6"));
    }

    protected void initDataView() {
        if (!this.isfirst) {
            this.initTab();
            this.isfirst = true;
        }
        this.setTitle("\u6211\u7684\u6587\u4ef6");
        this.rootPath = SDKInit.getDiskDownloadPath((Context)this, (String)"file");
        if (this.rootPath.equals(null) || this.rootPath.equals("")) {
            this.httpNoticeView.showNetError(click -> this.initDataView(), "\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff01\u8bf7\u91cd\u8bd5");
            return;
        }
        this.currentFilePath = this.rootPath;
        this.initView();
        this.initList();
        this.initListener();
        this.tableLayout.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                switch (tab.getPosition()) {
                    case 0: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "document");
                        break;
                    }
                    case 1: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "picture");
                        break;
                    }
                    case 2: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "package");
                        break;
                    }
                    case 3: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "av");
                        break;
                    }
                    default: {
                        MyFileActivity.this.switchListView(MyFileActivity.this.rootPath, "others");
                    }
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
    }

    public void switchListView(String filePath, String type) {
        this.items = new ArrayList<String>();
        this.documentInfo = new HashMap<String, String>();
        this.getFileByType(filePath, type);
        if (this.fileAdapter.getCount() > 0) {
            this.lvFileList.setVisibility(0);
            if (this.items != null && this.items.size() > 0) {
                this.lvFileList.setSelection(0);
            }
        } else {
            this.lvFileList.setVisibility(8);
        }
        this.currentType = type;
    }

    public void getFileByType(String filePath, String type) {
        try {
            File root = new File(filePath);
            File[] files = root.listFiles();
            if (files == null) {
                this.httpNoticeView.showNoData();
                return;
            }
            block14: for (File file : files) {
                if (file.isDirectory()) {
                    this.getFileByType(file.getAbsolutePath(), type);
                    continue;
                }
                String filename = file.getName();
                String absolutePath = file.getAbsolutePath();
                int i = filename.lastIndexOf(".");
                String token = "";
                if (i >= 0) {
                    token = filename.substring(i + 1);
                }
                switch (type) {
                    case "av": {
                        if (!token.contains("mp3") && !token.contains("wav") && !token.contains("cda") && !token.contains("midi") && !token.contains("ogg") && !token.contains("amr") && !token.contains("avi") && !token.contains("rmvb") && !token.contains("rm") && !token.contains("asf") && !token.contains("divx") && !token.contains("mpg") && !token.contains("mpeg") && !token.contains("mpe") && !token.contains("wmv") && !token.contains("mp4") && !token.contains("mkv") && !token.contains("vob") && !token.contains("aac") && !token.contains("m4a")) continue block14;
                        this.documentInfo.put(filename, absolutePath);
                        this.items.add(file.getName());
                        continue block14;
                    }
                    case "picture": {
                        if (!token.contains("bmp") && !token.contains("pcx") && !token.contains("png") && !token.contains("jpeg") && !token.contains("gif") && !token.contains("tiff") && !token.contains("jpg")) continue block14;
                        this.documentInfo.put(filename, absolutePath);
                        this.items.add(file.getName());
                        continue block14;
                    }
                    case "document": {
                        if (!token.contains("doc") && !token.contains("xls") && !token.contains("txt") && !token.contains("ppt") && !token.contains("pdf")) continue block14;
                        this.documentInfo.put(filename, absolutePath);
                        this.items.add(file.getName());
                        continue block14;
                    }
                    case "package": {
                        if (!token.contains("zip") && !token.contains("rar") && !token.contains("jar") && !token.contains("cab") && !token.contains("iso") && !token.contains("gz")) continue block14;
                        this.documentInfo.put(filename, absolutePath);
                        this.items.add(file.getName());
                        continue block14;
                    }
                    default: {
                        if (token.contains("mp3") || token.contains("wav") || token.contains("cda") || token.contains("midi") || token.contains("ogg") || token.contains("amr") || token.contains("avi") || token.contains("rmvb") || token.contains("rm") || token.contains("asf") || token.contains("divx") || token.contains("mpg") || token.contains("mpeg") || token.contains("mpe") || token.contains("wmv") || token.contains("mp4") || token.contains("mkv") || token.contains("vob") || token.contains("aac") || token.contains("m4a") || token.contains("bmp") || token.contains("pcx") || token.contains("png") || token.contains("jpeg") || token.contains("gif") || token.contains("tiff") || token.contains("jpg") || token.contains("zip") || token.contains("rar") || token.contains("jar") || token.contains("cab") || token.contains("iso") || token.contains("gz") || token.contains("doc") || token.contains("xls") || token.contains("txt") || token.contains("ppt") || token.contains("pdf")) continue block14;
                        this.documentInfo.put(filename, absolutePath);
                        this.items.add(file.getName());
                    }
                }
            }
            Collections.sort(this.items, Collator.getInstance(Locale.CHINESE));
            if (this.items.size() <= 0) {
                this.httpNoticeView.showNoData();
            } else {
                this.httpNoticeView.set404Visiable(false);
                this.fileAdapter.upData(this.items, this.documentInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

