/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.commonkit.ui.activity.ChangeInfoActivity;
import com.jxdinfo.mp.commonkit.ui.activity.CommomBaseActivity;
import com.jxdinfo.mp.commonkit.ui.activity.PhotoActivity;
import com.jxdinfo.mp.sdk.commonlib.client.CommonClient;
import com.jxdinfo.mp.sdk.core.bean.RosterBean;
import com.jxdinfo.mp.sdk.core.callback.ResultCallback;
import com.jxdinfo.mp.sdk.core.client.SDKInit;
import com.jxdinfo.mp.sdk.core.net.MPHttpClient;
import com.jxdinfo.mp.sdk.core.net.http.callback.ProgressCallback;
import com.jxdinfo.mp.sdk.core.net.model.ApiResponse;
import com.jxdinfo.mp.sdk.core.net.model.MobileUser;
import com.jxdinfo.mp.sdk.core.utils.DateUtil;
import com.jxdinfo.mp.sdk.core.utils.FileUtil;
import com.jxdinfo.mp.sdk.core.utils.PublicTool;
import com.jxdinfo.mp.sdk.core.utils.log.LogUtil;
import com.jxdinfo.mp.uicore.base.ToolbarStyle;
import com.jxdinfo.mp.uicore.comm.UICoreConst;
import com.jxdinfo.mp.uicore.customview.AvatarImageView;
import com.jxdinfo.mp.uicore.customview.dialog.SelectDialog;
import com.jxdinfo.mp.uicore.customview.photo.FileUtils;
import com.jxdinfo.mp.uicore.customview.photo.TakePhoto;
import com.jxdinfo.mp.uicore.customview.photo.TakePhotoImpl;
import com.jxdinfo.mp.uicore.customview.photo.model.CropOptions;
import com.jxdinfo.mp.uicore.customview.photo.model.InvokeParam;
import com.jxdinfo.mp.uicore.customview.photo.model.TContextWrap;
import com.jxdinfo.mp.uicore.customview.photo.model.TResult;
import com.jxdinfo.mp.uicore.customview.photo.permission.InvokeListener;
import com.jxdinfo.mp.uicore.customview.photo.permission.PermissionManager;
import com.jxdinfo.mp.uicore.customview.photo.permission.TakePhotoInvocationHandler;
import com.jxdinfo.mp.uicore.holder.MyInfoHolder;
import com.jxdinfo.mp.uicore.util.AppDialogUtil;
import com.jxdinfo.mp.uicore.util.ToastUtil;
import java.io.File;
import java.lang.reflect.Method;

@Route(path="/common/mineinfoactivity")
public class MineInfoActivity
extends CommomBaseActivity
implements InvokeListener,
TakePhoto.TakeResultListener {
    public static final String ICONDIR = "icon";
    @BindView(value=2131493037)
    AvatarImageView icon;
    @BindView(value=2131493316)
    TextView jobNmu;
    @BindView(value=2131493172)
    TextView name;
    @BindView(value=2131493179)
    TextView org;
    @BindView(value=2131493104)
    TextView job;
    @BindView(value=2131493193)
    TextView phone;
    @BindView(value=2131493452)
    TextView workPhone;
    @BindView(value=2131493007)
    TextView email;
    CropOptions cropOptions = new CropOptions.Builder().setAspectX(200).setAspectY(200).setOutputX(500).setOutputY(500).create();
    private SelectDialog selectDialog;
    private File file = null;
    private InvokeParam invokeParam;
    private TakePhoto takePhoto;

    @RequiresApi(api=19)
    protected void onCreate(Bundle savedInstanceState) {
        this.getTakePhoto().onCreate(savedInstanceState);
        this.setToolbarStyle(ToolbarStyle.TITLE_MIDDLE);
        super.onCreate(savedInstanceState);
    }

    protected int setupDataView() {
        return R.layout.mine_activity_mine_info;
    }

    protected void onSaveInstanceState(Bundle outState) {
        this.getTakePhoto().onSaveInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    protected boolean onKeyBack() {
        return false;
    }

    protected boolean onKeyMenu() {
        return false;
    }

    protected void getExras() {
    }

    protected void initDataView() {
        File file1 = new File(FileUtil.getSDCardDCIM((Context)this.getApplicationContext(), (MobileUser)SDKInit.getUser()) + File.separator + ICONDIR);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        this.file = new File(FileUtil.getSDCardDCIM((Context)this.getApplicationContext(), (MobileUser)SDKInit.getUser()) + File.separator + ICONDIR + File.separator + SDKInit.getUser().getUid() + ".jpg");
        this.setTitle("\u4e2a\u4eba\u4fe1\u606f");
        this.getData();
        this.icon.setOnClickListener(v -> {
            Intent intent = new Intent((Context)this, PhotoActivity.class);
            intent.putExtra("USERID", SDKInit.getUser().getUid());
            intent.putExtra("name", SDKInit.getUser().getName());
            this.startActivity(intent);
        });
    }

    private void getData() {
        CommonClient.getInstance().getLinkManInfo(SDKInit.getUser().getUid(), (ResultCallback)new ResultCallback<RosterBean>(){

            public void onStart() {
            }

            public void onSuccess(RosterBean rosterBean) {
                if (rosterBean != null) {
                    MyInfoHolder.getInstance().setMyRosterBean(rosterBean);
                    MineInfoActivity.this.changeData(rosterBean);
                }
            }

            public void onError(Exception e) {
            }
        });
    }

    private void changeData(RosterBean roster) {
        if (!TextUtils.isEmpty((CharSequence)roster.getPhoneNum())) {
            this.phone.setText((CharSequence)roster.getPhoneNum());
        } else {
            this.phone.setText((CharSequence)"");
        }
        if (!TextUtils.isEmpty((CharSequence)roster.getOfficePhoneNum())) {
            this.workPhone.setText((CharSequence)roster.getOfficePhoneNum());
        } else {
            this.workPhone.setText((CharSequence)"");
        }
        if (!TextUtils.isEmpty((CharSequence)roster.getJobNum())) {
            this.jobNmu.setText((CharSequence)roster.getJobNum());
        } else {
            this.jobNmu.setText((CharSequence)"");
        }
        if (!TextUtils.isEmpty((CharSequence)roster.getUserName())) {
            this.name.setText((CharSequence)roster.getUserName());
        } else {
            this.name.setText((CharSequence)"");
        }
        if (!TextUtils.isEmpty((CharSequence)roster.getPosition())) {
            this.job.setText((CharSequence)roster.getPosition());
        } else {
            this.job.setText((CharSequence)"");
        }
        if (!TextUtils.isEmpty((CharSequence)roster.getEmail())) {
            this.email.setText((CharSequence)roster.getEmail());
        } else {
            this.email.setText((CharSequence)"");
        }
        if (!TextUtils.isEmpty((CharSequence)roster.getOrganiseName())) {
            this.org.setText((CharSequence)roster.getOrganiseName());
        } else {
            this.org.setText((CharSequence)"");
        }
        this.icon.loadImage(roster.getUserID(), Boolean.valueOf(true), null, R.mipmap.uicore_peopicon, roster.getUserName(), false);
    }

    public void changeInfo(View view) {
        int i = view.getId();
        if (i != R.id.mine_name) {
            if (i == R.id.phone_ln) {
                Intent intent1 = new Intent((Context)this, ChangeInfoActivity.class);
                Bundle bundle1 = new Bundle();
                bundle1.putString("title", "\u624b\u673a\u53f7");
                bundle1.putString("include", this.phone.getText().toString());
                bundle1.putInt("state", 1);
                intent1.putExtras(bundle1);
                this.startActivityForResult(intent1, 1);
            } else if (i == R.id.work_phone_ln) {
                Intent intent2 = new Intent((Context)this, ChangeInfoActivity.class);
                Bundle bundle2 = new Bundle();
                bundle2.putString("title", "\u5de5\u4f5c\u7535\u8bdd");
                bundle2.putString("include", this.workPhone.getText().toString());
                bundle2.putInt("state", 2);
                intent2.putExtras(bundle2);
                this.startActivityForResult(intent2, 2);
            } else if (i == R.id.icon_forward) {
                this.toChooseIcon();
            } else if (i == R.id.email_ln) {
                Intent intent3 = new Intent((Context)this, ChangeInfoActivity.class);
                Bundle bundle3 = new Bundle();
                bundle3.putString("title", "\u90ae\u7bb1");
                bundle3.putString("include", this.email.getText().toString());
                bundle3.putInt("state", 3);
                intent3.putExtras(bundle3);
                this.startActivityForResult(intent3, 3);
            }
        }
    }

    private void toChooseIcon() {
        if (this.selectDialog == null) {
            this.selectDialog = new SelectDialog((Context)this, true);
            this.selectDialog.setSelectText1("\u62cd\u7167");
            this.selectDialog.setSelectText2("\u76f8\u518c");
            this.selectDialog.setButtonListener(new SelectDialog.OnButtonListener(){

                public void onOneButtonClick(SelectDialog dialog) {
                    FileUtils.createFileByDeleteOldFile((File)MineInfoActivity.this.file);
                    MineInfoActivity.this.cropOptions.setWithOwnCrop(true);
                    MineInfoActivity.this.getTakePhoto().onPickFromCaptureWithCrop(Uri.fromFile((File)MineInfoActivity.this.file), MineInfoActivity.this.cropOptions);
                    MineInfoActivity.this.selectDialog.cancel();
                }

                public void onSecondButtonClick(SelectDialog dialog) {
                    FileUtils.createFileByDeleteOldFile((File)MineInfoActivity.this.file);
                    MineInfoActivity.this.cropOptions.setWithOwnCrop(true);
                    MineInfoActivity.this.getTakePhoto().onPickFromDocumentsWithCrop(Uri.fromFile((File)MineInfoActivity.this.file), MineInfoActivity.this.cropOptions);
                    MineInfoActivity.this.selectDialog.cancel();
                }
            });
        }
        this.selectDialog.onLyshow();
    }

    public TakePhoto getTakePhoto() {
        if (this.takePhoto == null) {
            this.takePhoto = (TakePhoto)TakePhotoInvocationHandler.of((InvokeListener)this).bind((TakePhoto)new TakePhotoImpl((Activity)this, (TakePhoto.TakeResultListener)this));
        }
        return this.takePhoto;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode > 500) {
            this.getTakePhoto().onActivityResult(requestCode, resultCode, data);
            return;
        }
        if (data == null) {
            return;
        }
        String title = data.getStringExtra("title");
        if (title == null) {
            title = "";
        }
        RosterBean rosterBean = MyInfoHolder.getInstance().getMyRosterBean();
        switch (requestCode) {
            case 0: {
                if (rosterBean != null) {
                    rosterBean.setUserName(title);
                }
                this.name.setText((CharSequence)title);
                break;
            }
            case 1: {
                if (rosterBean != null) {
                    rosterBean.setPhoneNum(title);
                }
                this.phone.setText((CharSequence)title);
                break;
            }
            case 2: {
                if (rosterBean != null) {
                    rosterBean.setOfficePhoneNum(title);
                }
                this.workPhone.setText((CharSequence)title);
                break;
            }
            case 3: {
                if (rosterBean != null) {
                    rosterBean.setEmail(title);
                }
                this.email.setText((CharSequence)title);
                break;
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public PermissionManager.TPermissionType invoke(InvokeParam invokeParam) {
        PermissionManager.TPermissionType type = PermissionManager.checkPermission((TContextWrap)TContextWrap.of((Activity)this), (Method)invokeParam.getMethod());
        if (PermissionManager.TPermissionType.WAIT.equals((Object)type)) {
            this.invokeParam = invokeParam;
        }
        return type;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionManager.TPermissionType type = PermissionManager.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults);
        PermissionManager.handlePermissionsResult((Activity)this, (PermissionManager.TPermissionType)type, (InvokeParam)this.invokeParam, (TakePhoto.TakeResultListener)this);
    }

    public void takeSuccess(TResult result) {
        if (this.file != null && this.file.exists() && this.file.length() > 0L) {
            MPHttpClient.getInstance().uploadFile(SDKInit.getUser().getUid(), this.file, "", "", (ProgressCallback)new ProgressCallback<ApiResponse<String>>(){

                public void onProgress(long l, long l1, float v) {
                }

                public void onStart() {
                    AppDialogUtil.getInstance((Context)MineInfoActivity.this).showProgressDialog("\u5934\u50cf\u4e0a\u4f20\u4e2d...");
                }

                public void onSuccess(ApiResponse<String> stringApiResponse) {
                    AppDialogUtil.getInstance((Context)MineInfoActivity.this).cancelProgressDialog();
                    if (stringApiResponse != null && stringApiResponse.isSuccess()) {
                        ToastUtil.showShortToast((Context)MineInfoActivity.this, (String)"\u4e0a\u4f20\u56fe\u7247\u6210\u529f");
                        String currentTime = DateUtil.getCurrentTime();
                        PublicTool.getSharedPreferences((Context)MineInfoActivity.this, (String)"", (String)UICoreConst.HANDERSPNAME).putStringValue(SDKInit.getUser().getUid(), currentTime);
                        CommonClient.getInstance().updateAvatarSuccess((ResultCallback)new ResultCallback<Boolean>(){

                            public void onStart() {
                            }

                            public void onSuccess(Boolean aBoolean) {
                            }

                            public void onError(Exception e) {
                                LogUtil.e((String)"\u4e0a\u4f20\u56fe\u7247\u51fa\u9519\u4e86");
                            }
                        });
                        MineInfoActivity.this.icon.loadImage(SDKInit.getUser().getUid(), Boolean.valueOf(true), null, R.mipmap.uicore_peopicon, SDKInit.getUser().getName(), false);
                    } else {
                        ToastUtil.showShortToast((Context)MineInfoActivity.this, (String)"\u56fe\u7247\u4e0a\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    }
                }

                public void onError(Exception e) {
                    AppDialogUtil.getInstance((Context)MineInfoActivity.this).cancelProgressDialog();
                    ToastUtil.showShortToast((Context)MineInfoActivity.this, (String)"\u56fe\u7247\u4e0a\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                }
            });
        }
    }

    public void takeFail(TResult result, String msg) {
        ToastUtil.showShortToast((Context)this.getApplicationContext(), (String)"\u88c1\u526a\u5931\u8d25\u8bf7\u91cd\u8bd5");
    }

    public void takeCancel() {
    }

    public void changIcon(View view) {
        this.toChooseIcon();
    }
}

