/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.commonkit.ui.activity.CommomBaseActivity;
import com.jxdinfo.mp.sdk.commonlib.client.CommonClient;
import com.jxdinfo.mp.sdk.core.callback.ResultCallback;
import com.jxdinfo.mp.sdk.core.client.SDKInit;
import com.jxdinfo.mp.sdk.core.net.http.exception.ApiException;
import com.jxdinfo.mp.sdk.core.net.model.MobileUser;
import com.jxdinfo.mp.sdk.core.utils.AppUtil;
import com.jxdinfo.mp.sdk.core.utils.DateUtil;
import com.jxdinfo.mp.sdk.core.utils.PublicTool;
import com.jxdinfo.mp.sdk.core.utils.SharedPreferencesHelper;
import com.jxdinfo.mp.sdk.core.utils.StringUtil;
import com.jxdinfo.mp.sdk.core.utils.encrpty.MD5Util;
import com.jxdinfo.mp.sdk.core.utils.event.MessageEventSDK;
import com.jxdinfo.mp.sdk.im.client.IMClient;
import com.jxdinfo.mp.uicore.comm.UICoreConst;
import com.jxdinfo.mp.uicore.interfaces.INeedNotConnectIMServer;
import com.jxdinfo.mp.uicore.settings.SettingInfoBean;
import com.jxdinfo.mp.uicore.util.AppDialogUtil;
import com.jxdinfo.mp.uicore.util.OFLineUtil;
import com.jxdinfo.mp.uicore.util.ToastUtil;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;

@Route(path="/login/loginactivity")
public class LoginActivity
extends CommomBaseActivity
implements View.OnClickListener,
INeedNotConnectIMServer {
    public TextWatcher loginWatcher;
    SharedPreferencesHelper preferences;
    int hidePasswordFlag;
    @BindView(value=2131493096)
    ImageView ivShowPwd;
    @BindView(value=2131493130)
    LinearLayout platElse;
    @BindView(value=2131493131)
    LinearLayout platWX;
    @BindView(value=2131493098)
    ImageView iv_wxLogin;
    @BindView(value=2131493441)
    View viewLineAccount;
    @BindView(value=2131493442)
    View viewLinePwd;
    @BindView(value=2131493084)
    ImageView ivClearUsername;
    @BindView(value=2131493013)
    EditText etAccount;
    @BindView(value=2131493014)
    EditText etPwd;
    @BindView(value=2131493154)
    TextView tvLoginBtn;
    @BindView(value=2131493383)
    TextView tvTryBtn;
    private boolean isTry = false;
    private boolean isLogining = false;
    private String compId;
    private String wxPwd = "";

    protected void onCreate(Bundle savedInstanceState) {
        this.setNoreconnect(true);
        super.onCreate(savedInstanceState);
    }

    protected int setupDataView() {
        return R.layout.login_activity_main;
    }

    private void initView() {
        this.etAccount.setOnFocusChangeListener((view, hasFocus) -> this.viewLineAccount.setSelected(hasFocus));
        this.etPwd.setOnFocusChangeListener((view, hasFocus) -> this.viewLinePwd.setSelected(hasFocus));
        this.ivClearUsername.setOnClickListener(v -> this.etAccount.setText((CharSequence)""));
        boolean wxlogin = AppUtil.getMetaDataBoolean((Context)this, (String)"WXLOGIN", (boolean)false);
        if (wxlogin) {
            this.platElse.setVisibility(0);
            this.platWX.setVisibility(0);
        } else {
            this.platElse.setVisibility(8);
            this.platWX.setVisibility(8);
        }
    }

    protected boolean onKeyBack() {
        return false;
    }

    protected boolean onKeyMenu() {
        return false;
    }

    protected void getExras() {
    }

    protected void initDataView() {
        this.initView();
        this.preferences = PublicTool.getDefaultSharedPreferences((Context)this);
        String userCodeSave = this.preferences.getStringValue("usercode");
        this.compId = this.preferences.getStringValue("compId");
        if (!TextUtils.isEmpty((CharSequence)userCodeSave)) {
            this.etAccount.setText((CharSequence)userCodeSave);
        }
        if (AppUtil.getMetaDataBoolean((Context)this, (String)"PROBATION", (boolean)false)) {
            this.tvTryBtn.setVisibility(0);
            this.tvTryBtn.setOnClickListener((View.OnClickListener)this);
        } else {
            this.tvTryBtn.setVisibility(8);
        }
        this.setLoginAble();
        this.tvLoginBtn.setOnClickListener((View.OnClickListener)this);
        this.loginWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                LoginActivity.this.setLoginAble();
            }
        };
        this.etAccount.addTextChangedListener(this.loginWatcher);
        this.etPwd.addTextChangedListener(this.loginWatcher);
        this.ivShowPwd.setOnClickListener(v -> this.changeEdit());
        this.iv_wxLogin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoginActivity.this.WXLogin();
            }
        });
    }

    private void tryUser() {
        this.isTry = true;
        boolean permission2 = this.getPermission();
        if (!permission2) {
            return;
        }
        CommonClient.getInstance().loginTryUser((ResultCallback)new ResultCallback<MobileUser>(){

            public void onStart() {
                AppDialogUtil.getInstance((Context)LoginActivity.this).showProgressDialog("\u767b\u5f55\u4e2d");
            }

            public void onSuccess(MobileUser mobileUser) {
                AppDialogUtil.getInstance((Context)LoginActivity.this).cancelProgressDialog();
                LoginActivity.this.wxPwd = mobileUser.getPassword();
                SharedPreferencesHelper headpre = PublicTool.getSharedPreferences((Context)LoginActivity.this, (String)"", (String)UICoreConst.HANDERSPNAME);
                headpre.putStringValue(mobileUser.getUid(), DateUtil.getCurrentTime());
                LoginActivity.this.loginSuccessAndConnectIMServer(mobileUser);
            }

            public void onError(Exception e) {
                ToastUtil.showShortToast((Context)LoginActivity.this, (String)"\u767b\u5f55\u5931\u8d25");
                AppDialogUtil.getInstance((Context)LoginActivity.this).cancelProgressDialog();
            }
        });
    }

    private void changeEdit() {
        if (this.hidePasswordFlag == 0) {
            this.ivShowPwd.setBackground(this.getResources().getDrawable(R.mipmap.login_pwd_visibility_off));
            this.etPwd.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
            this.etPwd.setInputType(1);
            this.etPwd.setSelection(this.etPwd.getText().toString().length());
            this.hidePasswordFlag = 1;
        } else {
            this.ivShowPwd.setBackground(this.getResources().getDrawable(R.mipmap.login_pwd_visibility_on));
            this.etPwd.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            this.etPwd.setInputType(1);
            this.etPwd.setSelection(this.etPwd.getText().toString().length());
            this.hidePasswordFlag = 0;
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.login_button) {
            this.login();
        } else if (id2 == R.id.try_button) {
            this.tryUser();
        }
    }

    public void login() {
        this.isTry = false;
        boolean permission2 = this.getPermission();
        if (!permission2) {
            return;
        }
        String username = this.etAccount.getText().toString();
        String pwd = this.etPwd.getText().toString();
        if (StringUtil.isNull((String)username)) {
            ToastUtil.showShortToast((Context)this.getApplicationContext(), (String)"\u8bf7\u8f93\u5165\u8d26\u53f7");
            return;
        }
        if (StringUtil.isNull((String)pwd)) {
            ToastUtil.showShortToast((Context)this.getApplicationContext(), (String)"\u8bf7\u8f93\u5165\u5bc6\u7801");
            return;
        }
        this.wxPwd = "";
        CommonClient.getInstance().login(username, MD5Util.toMD5((String)pwd), this.compId, (ResultCallback)new ResultCallback<MobileUser>(){

            public void onStart() {
                AppDialogUtil.getInstance((Context)LoginActivity.this).showProgressDialog("\u767b\u5f55\u4e2d");
                LoginActivity.this.isLogining = true;
            }

            public void onSuccess(MobileUser mobileUser) {
                SharedPreferencesHelper headpre = PublicTool.getSharedPreferences((Context)LoginActivity.this, (String)"", (String)UICoreConst.HANDERSPNAME);
                String currentTime = DateUtil.getCurrentTime();
                headpre.putStringValue(mobileUser.getUid(), currentTime);
                LoginActivity.this.loginSuccessAndConnectIMServer(mobileUser);
            }

            public void onError(Exception e) {
                LoginActivity.this.isLogining = false;
                AppDialogUtil.getInstance((Context)LoginActivity.this).cancelProgressDialog();
                Toast.makeText((Context)LoginActivity.this, (CharSequence)(e == null || !(e instanceof ApiException) ? "\u767b\u5f55\u5931\u8d25" : e.getMessage() + ""), (int)0).show();
            }
        });
    }

    private void loginSuccessAndConnectIMServer(MobileUser mobileUser) {
        IMClient.getInstance().connectIMServer(mobileUser, new ResultCallback(){

            public void onStart() {
            }

            public void onSuccess(Object o) {
                ARouter.getInstance().build("/main/mainActivity").navigation();
                AppDialogUtil.getInstance((Context)LoginActivity.this).cancelProgressDialog();
                LoginActivity.this.isLogining = false;
                LoginActivity.this.finish();
            }

            public void onError(Exception e) {
                AppDialogUtil.getInstance((Context)LoginActivity.this).cancelProgressDialog();
                ToastUtil.showShortToast((Context)LoginActivity.this, (String)e.getMessage());
                LoginActivity.this.isLogining = false;
            }
        });
    }

    public String getPassWord() {
        return TextUtils.isEmpty((CharSequence)this.wxPwd) ? (this.isTry ? MD5Util.toMD5((String)MD5Util.toMD5((String)"888888")) : MD5Util.toMD5((String)this.etPwd.getText().toString())) : this.wxPwd;
    }

    public void setLoginAble() {
        if (StringUtil.isNull((String)this.etAccount.getText().toString()) || StringUtil.isNull((String)this.etPwd.getText().toString())) {
            this.tvLoginBtn.setEnabled(false);
            return;
        }
        this.tvLoginBtn.setEnabled(true);
    }

    public boolean getPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            int checkCallPhonePermission = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE");
            if (checkCallPhonePermission != 0) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_PHONE_STATE"}, (int)222);
                return false;
            }
            return true;
        }
        return true;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 222: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    if (this.isTry) break;
                    this.login();
                    break;
                }
                ToastUtil.showLongToast((Context)this, (String)this.getString(R.string.tip_permission_phone_state));
                break;
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    void WXLogin() {
        this.isLogining = true;
        IWXAPI mApi = WXAPIFactory.createWXAPI((Context)this, (String)SettingInfoBean.WXKEY, (boolean)false);
        boolean sucess = mApi.registerApp(SettingInfoBean.WXKEY);
        if (mApi != null && mApi.isWXAppInstalled()) {
            SendAuth.Req req = new SendAuth.Req();
            req.scope = "snsapi_userinfo";
            req.state = LoginActivity.class.getName();
            boolean bl = mApi.sendReq((BaseReq)req);
        } else {
            Toast.makeText((Context)this, (CharSequence)"\u7528\u6237\u672a\u5b89\u88c5\u5fae\u4fe1", (int)0).show();
        }
    }

    protected void onNewIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String platId = intent.getStringExtra("platId");
        if (!TextUtils.isEmpty((CharSequence)platId) && this.isLogining) {
            AppDialogUtil.getInstance((Context)this).showProgressDialog("\u767b\u5f55\u4e2d");
        }
        String platType = intent.getStringExtra("platType");
        String platName = intent.getStringExtra("platName");
        String platHeadUrl = intent.getStringExtra("platHeadUrl");
        if (!TextUtils.isEmpty((CharSequence)platId)) {
            this.platLogin(platId, platType, platName, platHeadUrl);
        } else {
            this.isLogining = false;
            AppDialogUtil.getInstance((Context)this).cancelProgressDialogImmediately();
        }
    }

    public void platLogin(String openId, String platType, String platName, String platHeadUrl) {
        CommonClient.getInstance().loginThirdParty(openId, platType, platName, platHeadUrl, (ResultCallback)new ResultCallback<MobileUser>(){

            public void onStart() {
            }

            public void onSuccess(MobileUser mobileUser) {
                SharedPreferencesHelper headpre = PublicTool.getSharedPreferences((Context)LoginActivity.this, (String)"", (String)UICoreConst.HANDERSPNAME);
                String currentTime = DateUtil.getCurrentTime();
                headpre.putStringValue(mobileUser.getUid(), currentTime);
                LoginActivity.this.wxPwd = mobileUser.getPassword();
                LoginActivity.this.isLogining = false;
                LoginActivity.this.loginSuccessAndConnectIMServer(mobileUser);
            }

            public void onError(Exception error) {
                LoginActivity.this.isLogining = false;
                AppDialogUtil.getInstance((Context)LoginActivity.this).cancelProgressDialog();
                if (error instanceof ApiException) {
                    ApiException serverException = (ApiException)error;
                    String appName = "";
                    try {
                        ApplicationInfo appInfo = LoginActivity.this.getPackageManager().getApplicationInfo(LoginActivity.this.getPackageName(), 128);
                        if (appInfo != null) {
                            appName = appInfo.metaData.getString("APP_NAME");
                        }
                    }
                    catch (Exception e) {
                        e.getMessage();
                    }
                    AppDialogUtil.getInstance((Context)LoginActivity.this).showTextDialog(TextUtils.isEmpty((CharSequence)serverException.getMessage()) ? "\u8be5\u5fae\u4fe1\u53f7\u672a\u7ed1\u5b9a" + appName + "\u8d26\u53f7\uff0c\u8bf7\u767b\u5f55\u540e\u7ed1\u5b9a" : serverException.getMessage());
                } else {
                    ToastUtil.showShortToast((Context)SDKInit.getContext(), (String)"\u767b\u5f55\u5931\u8d25");
                }
            }
        });
    }

    public void failedConnect(String notice, boolean backToLogin) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                OFLineUtil.getInstance().setConnecting(false);
                OFLineUtil.getInstance().setConnectFailed(true);
            }
        });
    }

    protected void receiveEvent(MessageEventSDK event) {
        super.receiveEvent(event);
    }

    protected void onResume() {
        super.onResume();
    }
}

