/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import butterknife.BindView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.commonkit.ui.activity.CommomBaseActivity;
import com.jxdinfo.mp.commonkit.ui.adapter.CompanyAdapter;
import com.jxdinfo.mp.sdk.commonlib.client.CommonClient;
import com.jxdinfo.mp.sdk.core.bean.CompanyBean;
import com.jxdinfo.mp.sdk.core.callback.ResultCallback;
import com.jxdinfo.mp.sdk.core.utils.PublicTool;
import com.jxdinfo.mp.uicore.base.ToolbarStyle;
import com.jxdinfo.mp.uicore.crossmodule.IIMService;
import com.jxdinfo.mp.uicore.customview.dialog.TitleButtonDialog;
import com.jxdinfo.mp.uicore.customview.pulltorefresh.BasePullToRefresh;
import com.jxdinfo.mp.uicore.customview.pulltorefresh.PullToRefreshLayout;
import com.jxdinfo.mp.uicore.util.AppDialogUtil;
import com.jxdinfo.mp.uicore.util.ToastUtil;
import java.util.List;

public class CompActivity
extends CommomBaseActivity {
    @BindView(value=2131493222)
    PullToRefreshLayout pullToRefreshLayout;
    CompanyAdapter companyAdapter;
    @BindView(value=2131493155)
    ListView listView;
    String searchKey;
    @BindView(value=2131492966)
    TextView quit;
    @BindView(value=2131493279)
    EditText editText;
    private String selectID;
    private TitleButtonDialog changCompDialog;

    protected void onCreate(Bundle savedInstanceState) {
        this.setToolbarStyle(ToolbarStyle.TITLE_MIDDLE);
        super.onCreate(savedInstanceState);
        this.setTitle("\u6211\u7684\u4f01\u4e1a");
        this.selectID = PublicTool.getDefaultSharedPreferences((Context)this).getStringValue("compId");
        this.getCompList();
    }

    protected int setupDataView() {
        return R.layout.settings_activity_comp;
    }

    protected boolean onKeyBack() {
        return false;
    }

    protected boolean onKeyMenu() {
        return false;
    }

    protected void getExras() {
    }

    protected void initDataView() {
        this.pullToRefreshLayout.setLoadmoreable(false);
        this.pullToRefreshLayout.setOnStartListener(new BasePullToRefresh.OnStartListener(){

            public void onStartRefresh(BasePullToRefresh var1) {
                CompActivity.this.getCompList();
            }

            public void onStartLoadmore(BasePullToRefresh var1) {
            }
        });
        this.listView.setOnItemClickListener((parent, view, position, id2) -> {
            CompanyBean companyBean = this.companyAdapter.getCompanyBeen().get(position);
            if (companyBean != null && !companyBean.getCompanyId().equals(this.selectID)) {
                this.showChangDialog(companyBean);
            }
        });
        this.quit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CompActivity.this.finish();
            }
        });
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                CompActivity.this.searchKey = s.toString();
                if (TextUtils.isEmpty((CharSequence)CompActivity.this.searchKey)) {
                    if (CompActivity.this.companyAdapter == null) {
                        CompActivity.this.companyAdapter = new CompanyAdapter((Context)CompActivity.this, CompActivity.this.selectID);
                        CompActivity.this.listView.setAdapter((ListAdapter)CompActivity.this.companyAdapter);
                    }
                    CompActivity.this.companyAdapter.setCompanyBeen(null);
                } else {
                    CompActivity.this.getCompList();
                }
            }
        });
    }

    private void showChangDialog(final CompanyBean companyBean) {
        if (this.changCompDialog == null) {
            this.changCompDialog = new TitleButtonDialog((Context)this, false);
            this.changCompDialog.setRightButtonTextColor(R.color.text_color1);
            this.changCompDialog.setTitle("\u8fdb\u5165\u4f01\u4e1a");
        }
        this.changCompDialog.setText(companyBean.getCompanyName());
        this.changCompDialog.setButtonListener(new TitleButtonDialog.OnButtonListener(){

            public void onLeftButtonClick(TitleButtonDialog dialog) {
                dialog.dismiss();
            }

            public void onRightButtonClick(TitleButtonDialog dialog) {
                CompActivity.this.changeCompany(companyBean);
                dialog.dismiss();
            }
        });
        this.changCompDialog.show();
    }

    private void changeCompany(CompanyBean companyBean) {
        this.logout();
        PublicTool.getDefaultSharedPreferences((Context)this).putStringValue("compId", companyBean.getCompanyId());
        IIMService iimService = (IIMService)ARouter.getInstance().build("/im_service/recconect_im_service").navigation();
        iimService.connect(new ResultCallback(){

            public void onStart() {
                AppDialogUtil.getInstance((Context)CompActivity.this.mContext).showProgressDialog("\u6b63\u5728\u5207\u6362\u4f01\u4e1a");
            }

            public void onSuccess(Object o) {
                AppDialogUtil.getInstance((Context)CompActivity.this.mContext).cancelProgressDialogImmediately();
                ARouter.getInstance().build("/main/mainActivity").withBoolean("updateVersion", false).withBoolean("AUTOLOGIN", false).navigation();
                CompActivity.this.finish();
            }

            public void onError(Exception e) {
                AppDialogUtil.getInstance((Context)CompActivity.this.mContext).cancelProgressDialogImmediately();
                ToastUtil.showShortToast((Context)CompActivity.this, (String)"\u5207\u6362\u4f01\u4e1a\u5931\u8d25");
            }
        });
    }

    public void logout() {
        IIMService iimService = (IIMService)ARouter.getInstance().build("/im_service/recconect_im_service").navigation();
        iimService.logout((Activity)this);
    }

    public void getCompList() {
        CommonClient.getInstance().getCompanyList((ResultCallback)new ResultCallback<List<CompanyBean>>(){

            public void onStart() {
            }

            public void onSuccess(List<CompanyBean> companyBeans) {
                if (CompActivity.this.companyAdapter == null) {
                    CompActivity.this.companyAdapter = new CompanyAdapter((Context)CompActivity.this, CompActivity.this.selectID);
                    CompActivity.this.listView.setAdapter((ListAdapter)CompActivity.this.companyAdapter);
                }
                CompActivity.this.companyAdapter.setCompanyBeen(companyBeans);
                CompActivity.this.pullToRefreshLayout.refreshSuccess();
            }

            public void onError(Exception e) {
                CompActivity.this.pullToRefreshLayout.refreshFailed();
            }
        });
    }
}

