/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.activity;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.RelativeLayout;
import android.widget.TextView;
import butterknife.BindView;
import butterknife.OnClick;
import com.alibaba.android.arouter.launcher.ARouter;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.commonkit.ui.activity.CommomBaseActivity;
import com.jxdinfo.mp.sdk.core.client.SDKInit;
import com.jxdinfo.mp.sdk.core.net.http.HttpClient;
import com.jxdinfo.mp.sdk.core.utils.FileUtil;
import com.jxdinfo.mp.sdk.core.utils.event.EventBusUtil;
import com.jxdinfo.mp.sdk.core.utils.event.MessageEventSDK;
import com.jxdinfo.mp.uicore.base.ToolbarStyle;
import com.jxdinfo.mp.uicore.callback.OnRefreshData;
import com.jxdinfo.mp.uicore.crossmodule.IIMService;
import com.jxdinfo.mp.uicore.customview.dialog.BaseButtonDialog;
import com.jxdinfo.mp.uicore.util.AppDialogUtil;
import com.jxdinfo.mp.uicore.util.Glide.GlideCachUtil;
import com.jxdinfo.mp.uicore.util.ToastUtil;
import com.jxdinfo.mp.uicore.util.event.MessageEvent;
import java.io.File;
import java.math.BigDecimal;

public class ClearCacheActivity
extends CommomBaseActivity {
    @BindView(value=2131493247)
    RelativeLayout rlClearFileCache;
    @BindView(value=2131493248)
    RelativeLayout rlClearImageCache;
    @BindView(value=2131493256)
    RelativeLayout rlClearPubPlatFileCache;
    @BindView(value=2131493246)
    RelativeLayout rlClearChatDataCache;
    @BindView(value=2131493395)
    TextView tvFileCacheSize;
    @BindView(value=2131493400)
    TextView tvImageCacheSize;
    @BindView(value=2131493415)
    TextView tvPubPlatCacheSize;
    @BindView(value=2131493389)
    TextView tvChatDataCacheSize;
    private BaseButtonDialog clearCacheDialog;

    protected void onCreate(Bundle savedInstanceState) {
        this.setToolbarStyle(ToolbarStyle.TITLE_MIDDLE);
        super.onCreate(savedInstanceState);
    }

    protected int setupDataView() {
        return R.layout.settings_activity_clear_cache;
    }

    protected boolean onKeyBack() {
        return false;
    }

    protected boolean onKeyMenu() {
        return false;
    }

    protected void getExras() {
    }

    protected void initDataView() {
        this.setTitle("\u6e05\u9664\u7f13\u5b58");
        this.setImageCacheSize();
        this.setFileCacheSize();
        this.setPubPlatCacheSize();
    }

    private void setImageCacheSize() {
        String cacheSize = GlideCachUtil.getInstance().getCacheSize((Context)this);
        if (TextUtils.isEmpty((CharSequence)cacheSize)) {
            cacheSize = "0.0B";
        }
        this.tvImageCacheSize.setText((CharSequence)cacheSize);
    }

    private void setFileCacheSize() {
        String filePath = FileUtil.getSDKDownloadPath((Context)HttpClient.getContext(), (String)SDKInit.getUser().getCompId()) + File.separator + "file";
        long folderSize = ClearCacheActivity.getFolderSize(filePath);
        String formatSize = ClearCacheActivity.getFormatSize(folderSize);
        if (TextUtils.isEmpty((CharSequence)formatSize)) {
            formatSize = "0.0B";
        }
        this.tvFileCacheSize.setText((CharSequence)formatSize);
    }

    private void setPubPlatCacheSize() {
        String hybridAppPath = FileUtil.getSDKDownloadPath((Context)HttpClient.getContext(), (String)SDKInit.getUser().getCompId()) + File.separator + FileUtil.getHybridAppDirName();
        long folderSize = ClearCacheActivity.getFolderSize(hybridAppPath);
        String formatSize = ClearCacheActivity.getFormatSize(folderSize);
        if (TextUtils.isEmpty((CharSequence)formatSize)) {
            formatSize = "0.0B";
        }
        this.tvPubPlatCacheSize.setText((CharSequence)formatSize);
    }

    @OnClick(value={2131493247})
    void clearFileCache() {
        this.clearCacheDialog = new BaseButtonDialog((Context)this);
        this.clearCacheDialog.setText("\u786e\u5b9a\u6e05\u9664\u7f13\u5b58\u5417?");
        this.clearCacheDialog.setButtonListener(new BaseButtonDialog.OnButtonListener(){

            public void onLeftButtonClick(BaseButtonDialog dialog) {
                dialog.dismiss();
            }

            public void onRightButtonClick(BaseButtonDialog dialog) {
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).showProgressDialog("\u6b63\u5728\u6e05\u9664...");
                String filePath = FileUtil.getSDKDownloadPath((Context)HttpClient.getContext(), (String)SDKInit.getUser().getCompId()) + File.separator + "file";
                ClearCacheActivity.this.deleteFolder(filePath);
                ClearCacheActivity.this.tvFileCacheSize.setText((CharSequence)"0.0B");
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).cancelProgressDialogImmediately();
                ToastUtil.showShortToast((Context)ClearCacheActivity.this, (String)"\u7f13\u5b58\u5df2\u6e05\u9664");
                dialog.dismiss();
            }
        });
        this.clearCacheDialog.show();
    }

    @OnClick(value={2131493248})
    void clearImageCache() {
        this.showClearCache();
    }

    private void showClearCache() {
        this.clearCacheDialog = new BaseButtonDialog((Context)this);
        this.clearCacheDialog.setText("\u786e\u5b9a\u6e05\u9664\u7f13\u5b58\u5417?");
        this.clearCacheDialog.setButtonListener(new BaseButtonDialog.OnButtonListener(){

            public void onLeftButtonClick(BaseButtonDialog dialog) {
                dialog.dismiss();
            }

            public void onRightButtonClick(BaseButtonDialog dialog) {
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).showProgressDialog("\u6b63\u5728\u6e05\u9664...");
                GlideCachUtil.getInstance().clearImageAllCache((Context)ClearCacheActivity.this, new OnRefreshData(){

                    public void onRefreshData() {
                    }
                });
                ClearCacheActivity.this.tvImageCacheSize.setText((CharSequence)"0.0B");
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).cancelProgressDialogImmediately();
                ToastUtil.showShortToast((Context)ClearCacheActivity.this, (String)"\u7f13\u5b58\u5df2\u6e05\u9664");
                dialog.dismiss();
            }
        });
        this.clearCacheDialog.show();
    }

    @OnClick(value={2131493256})
    void clearPubplatFileCache() {
        this.clearCacheDialog = new BaseButtonDialog((Context)this);
        this.clearCacheDialog.setText("\u786e\u5b9a\u6e05\u9664\u7f13\u5b58\u5417?");
        this.clearCacheDialog.setButtonListener(new BaseButtonDialog.OnButtonListener(){

            public void onLeftButtonClick(BaseButtonDialog dialog) {
                dialog.dismiss();
            }

            public void onRightButtonClick(BaseButtonDialog dialog) {
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).showProgressDialog("\u6b63\u5728\u6e05\u9664...");
                String hybridAppPath = FileUtil.getSDKDownloadPath((Context)HttpClient.getContext(), (String)SDKInit.getUser().getCompId()) + File.separator + FileUtil.getHybridAppDirName();
                ClearCacheActivity.this.deleteFolder(hybridAppPath);
                EventBusUtil.sendEvent((MessageEventSDK)MessageEvent.getInstance((int)10013, (Object)""));
                ClearCacheActivity.this.setPubPlatCacheSize();
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).cancelProgressDialogImmediately();
                ToastUtil.showShortToast((Context)ClearCacheActivity.this, (String)"\u7f13\u5b58\u5df2\u6e05\u9664");
                dialog.dismiss();
            }
        });
        this.clearCacheDialog.show();
    }

    @OnClick(value={2131493246})
    void clearChatDataCache() {
        IIMService iimService = (IIMService)ARouter.getInstance().build("/im_service/recconect_im_service").navigation();
        iimService.clearChatMessageData((Context)this);
    }

    public boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public boolean deleteDirectory(String filePath) {
        File dirFile;
        boolean flag = false;
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(dirFile = new File(filePath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = this.deleteFile(files[i].getAbsolutePath())) : !(flag = this.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public boolean deleteFolder(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return this.deleteFile(filePath);
        }
        return this.deleteDirectory(filePath);
    }

    private void showClearCache(String filePath) {
        this.clearCacheDialog = new BaseButtonDialog((Context)this);
        this.clearCacheDialog.setText("\u786e\u5b9a\u6e05\u9664\u7f13\u5b58\u5417?");
        this.clearCacheDialog.setButtonListener(new BaseButtonDialog.OnButtonListener(){

            public void onLeftButtonClick(BaseButtonDialog dialog) {
                dialog.dismiss();
            }

            public void onRightButtonClick(BaseButtonDialog dialog) {
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).showProgressDialog("\u6b63\u5728\u6e05\u9664...");
                AppDialogUtil.getInstance((Context)ClearCacheActivity.this).cancelProgressDialogImmediately();
                ToastUtil.showShortToast((Context)ClearCacheActivity.this, (String)"\u7f13\u5b58\u5df2\u6e05\u9664");
                dialog.dismiss();
            }
        });
        this.clearCacheDialog.show();
    }

    private void setCacheSize() {
        String cacheSize = GlideCachUtil.getInstance().getCacheSize((Context)this);
        if (TextUtils.isEmpty((CharSequence)cacheSize)) {
            cacheSize = "0.0B";
        }
    }

    public static long getFolderSize(String path) {
        long size = 0L;
        File file = new File(path);
        try {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += ClearCacheActivity.getFolderSize(fileList[i].getPath());
                    continue;
                }
                size += fileList[i].length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    private static String getFormatSize(double size) {
        double kiloByte = size / 1024.0;
        if (kiloByte < 1.0) {
            return size + "B";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "KB";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "MB";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }
}

