/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.commonkit.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import butterknife.BindView;
import com.jxdinfo.commonkit.R;
import com.jxdinfo.mp.commonkit.ui.activity.CommomBaseActivity;
import com.jxdinfo.mp.sdk.commonlib.client.CommonClient;
import com.jxdinfo.mp.sdk.core.bean.RosterBean;
import com.jxdinfo.mp.sdk.core.callback.ResultCallback;
import com.jxdinfo.mp.sdk.core.client.SDKInit;
import com.jxdinfo.mp.sdk.core.utils.StringUtil;
import com.jxdinfo.mp.uicore.base.ToolbarStyle;
import com.jxdinfo.mp.uicore.util.ToastUtil;
import java.util.regex.Pattern;

public class ChangeInfoActivity
extends CommomBaseActivity
implements View.OnClickListener {
    @BindView(value=2131493002)
    EditText etChangedInfo;
    private String titleString;
    private String editInfo;
    private int state;

    protected void onCreate(Bundle savedInstanceState) {
        this.setToolbarStyle(ToolbarStyle.TITLE_MIDDLE);
        super.onCreate(savedInstanceState);
    }

    protected int setupDataView() {
        return R.layout.mine_activity_change_info;
    }

    private void initData() {
        if (!TextUtils.isEmpty((CharSequence)this.editInfo)) {
            this.etChangedInfo.setText((CharSequence)this.editInfo);
            this.etChangedInfo.setSelection(this.editInfo.length());
        } else {
            this.editInfo = "";
        }
        if (!TextUtils.isEmpty((CharSequence)this.titleString)) {
            this.setTitle("\u4fee\u6539" + this.titleString);
            this.etChangedInfo.setHint((CharSequence)("\u8bf7\u8f93\u5165" + this.titleString));
        }
    }

    protected void getExras() {
        Bundle extras = this.getIntent().getExtras();
        this.titleString = extras.getString("title");
        this.editInfo = extras.getString("include");
        this.state = extras.getInt("state", -1);
    }

    protected void initDataView() {
        this.initData();
        this.showRightTitle(true);
        this.getRightText().setText((CharSequence)"\u786e\u5b9a");
        this.getRightText().setTextColor(this.getResources().getColor(R.color.uicore_white));
        this.getRightText().setOnClickListener((View.OnClickListener)this);
    }

    protected boolean onKeyBack() {
        return false;
    }

    protected boolean onKeyMenu() {
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return super.onOptionsItemSelected(item);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.right_title) {
            if (this.etChangedInfo.getText().toString().equals(this.editInfo)) {
                this.finish();
                return;
            }
            switch (this.state) {
                case 0: {
                    this.changInfo(0);
                    break;
                }
                case 1: {
                    if (TextUtils.isEmpty((CharSequence)this.etChangedInfo.getText().toString())) {
                        this.changInfo(1);
                        break;
                    }
                    if (StringUtil.isMobileNO((String)this.etChangedInfo.getText().toString())) {
                        this.changInfo(1);
                        break;
                    }
                    ToastUtil.showShortToast((Context)this, (String)"\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u7801\u6709\u8bef,\u8bf7\u91cd\u65b0\u6838\u5bf9\u540e\u518d\u8f93\u5165!");
                    break;
                }
                case 2: {
                    if (TextUtils.isEmpty((CharSequence)this.etChangedInfo.getText().toString())) {
                        this.changInfo(2);
                        break;
                    }
                    if (StringUtil.isTelNum((String)this.etChangedInfo.getText().toString())) {
                        this.changInfo(2);
                        break;
                    }
                    ToastUtil.showShortToast((Context)this, (String)"\u60a8\u8f93\u5165\u7684\u53f7\u7801\u6709\u8bef,\u8bf7\u91cd\u65b0\u6838\u5bf9\u540e\u518d\u8f93\u5165!");
                    break;
                }
                case 3: {
                    if (TextUtils.isEmpty((CharSequence)this.etChangedInfo.getText().toString())) {
                        this.changInfo(3);
                        break;
                    }
                    if (ChangeInfoActivity.checkEmail(this.etChangedInfo.getText().toString())) {
                        this.changInfo(3);
                        break;
                    }
                    ToastUtil.showShortToast((Context)this, (String)"\u60a8\u8f93\u5165\u7684\u90ae\u7bb1\u6709\u8bef,\u8bf7\u91cd\u65b0\u6838\u5bf9\u540e\u518d\u8f93\u5165!");
                    break;
                }
            }
        }
    }

    private void changInfo(int type) {
        if (TextUtils.isEmpty((CharSequence)this.etChangedInfo.getText().toString()) && type != 2) {
            ToastUtil.showShortToast((Context)this.getApplicationContext(), (String)("\u8bf7\u8f93\u5165\u8981\u4fee\u6539\u7684" + this.titleString));
            return;
        }
        RosterBean rosterBean = new RosterBean();
        rosterBean.setUserID(SDKInit.getUser().getUid());
        switch (type) {
            case 0: {
                rosterBean.setUserName(this.etChangedInfo.getText().toString());
                break;
            }
            case 1: {
                rosterBean.setPhoneNum(this.etChangedInfo.getText().toString());
                break;
            }
            case 2: {
                rosterBean.setOfficePhoneNum(this.etChangedInfo.getText().toString());
                break;
            }
            case 3: {
                rosterBean.setEmail(this.etChangedInfo.getText().toString());
                break;
            }
        }
        CommonClient.getInstance().updateUserInfo(rosterBean, (ResultCallback)new ResultCallback<Boolean>(){

            public void onStart() {
            }

            public void onSuccess(Boolean result) {
                if (result.booleanValue()) {
                    Intent intent = new Intent();
                    intent.putExtra("title", ChangeInfoActivity.this.etChangedInfo.getText().toString());
                    ChangeInfoActivity.this.setResult(1, intent);
                    ChangeInfoActivity.this.finish();
                } else {
                    ToastUtil.showShortToast((Context)ChangeInfoActivity.this.getApplicationContext(), (String)("\u4fee\u6539" + ChangeInfoActivity.this.titleString + "\u5931\u8d25"));
                }
            }

            public void onError(Exception e) {
            }
        });
    }

    public static boolean checkEmail(String email) {
        String REGEX_EMAIL = "^[A-Z0-9a-z._%+-]+@[A-Za-z0-9-]+\\.[A-Za-z]{2,4}";
        return Pattern.matches(REGEX_EMAIL, email);
    }
}

