/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.dfa;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.dfa.StopChar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WordTree
extends HashMap<Character, WordTree> {
    private static final long serialVersionUID = -4646423269465809276L;
    private Set<Character> endCharacterSet = new HashSet<Character>();

    public void addWords(Collection<String> words) {
        if (!(words instanceof Set)) {
            words = new HashSet<String>(words);
        }
        for (String word : words) {
            this.addWord(word);
        }
    }

    public void addWords(String ... words) {
        HashSet<String> wordsSet = CollectionUtil.newHashSet(words);
        for (String word : wordsSet) {
            this.addWord(word);
        }
    }

    public void addWord(String word) {
        WordTree parent = null;
        WordTree current = this;
        char currentChar = '\u0000';
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            currentChar = word.charAt(i);
            if (StopChar.isStopChar(currentChar)) continue;
            WordTree child = (WordTree)current.get(Character.valueOf(currentChar));
            if (child == null) {
                child = new WordTree();
                current.put(Character.valueOf(currentChar), child);
            }
            parent = current;
            current = child;
        }
        if (null != parent) {
            super.setEnd(Character.valueOf(currentChar));
        }
    }

    public boolean isMatch(String text) {
        if (null == text) {
            return false;
        }
        return null != this.match(text);
    }

    public String match(String text) {
        if (null == text) {
            return null;
        }
        List<String> matchAll = this.matchAll(text, 1);
        if (CollectionUtil.isNotEmpty(matchAll)) {
            return matchAll.get(0);
        }
        return null;
    }

    public List<String> matchAll(String text) {
        return this.matchAll(text, -1);
    }

    public List<String> matchAll(String text, int limit) {
        return this.matchAll(text, limit, false, false);
    }

    public List<String> matchAll(String text, int limit, boolean isDensityMatch, boolean isGreedMatch) {
        if (null == text) {
            return null;
        }
        ArrayList<String> findedWords = new ArrayList<String>();
        WordTree current = this;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            StringBuilder wordBuffer = StrUtil.builder();
            for (int j = i; j < length; ++j) {
                char currentChar = text.charAt(j);
                if (StopChar.isStopChar(currentChar)) {
                    if (wordBuffer.length() > 0) {
                        wordBuffer.append(currentChar);
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (!current.containsKey(Character.valueOf(currentChar))) break;
                wordBuffer.append(currentChar);
                if (current.isEnd(Character.valueOf(currentChar))) {
                    findedWords.add(wordBuffer.toString());
                    if (limit > 0 && findedWords.size() >= limit) {
                        return findedWords;
                    }
                    if (!isDensityMatch) {
                        i = j;
                    }
                    if (!isGreedMatch) break;
                }
                if (null == (current = (WordTree)current.get(Character.valueOf(currentChar)))) break;
            }
            current = this;
        }
        return findedWords;
    }

    private boolean isEnd(Character c) {
        return this.endCharacterSet.contains(c);
    }

    private void setEnd(Character c) {
        if (null != c) {
            this.endCharacterSet.add(c);
        }
    }
}

