/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.aop.interceptor;

import cn.hutool.aop.aspects.Aspect;
import cn.hutool.core.exceptions.UtilException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class CglibInterceptor
implements MethodInterceptor {
    private Object target;
    private Aspect aspect;

    public CglibInterceptor(Object target, Aspect aspect) {
        this.target = target;
        this.aspect = aspect;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = null;
        if (this.aspect.before(this.target, method, args)) {
            try {
                result = proxy.invokeSuper(obj, args);
            }
            catch (UtilException e) {
                Throwable cause = e.getCause();
                if (e.getCause() instanceof InvocationTargetException) {
                    this.aspect.afterException(this.target, method, args, ((InvocationTargetException)cause).getTargetException());
                }
                throw e;
            }
        }
        if (this.aspect.after(this.target, method, args)) {
            return result;
        }
        return null;
    }
}

