/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.start;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.mp.common.model.zone.ZoneVO;
import com.jxdinfo.mp.zone.dao.CompanyMapper;
import com.jxdinfo.mp.zone.service.ZoneService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class ZoneApplicationRunner
implements ApplicationRunner {
    @Resource
    private ZoneService zoneService;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private CompanyMapper companyMapper;

    public void run(ApplicationArguments args) {
        String tenantId = "3093257602898319400";
        String zoneKey = tenantId + ":zone";
        String commentKey = tenantId + ":zoneComment:";
        String praiseKey = tenantId + ":zonePraise:";
        if (this.redisTemplate.opsForHash().size((Object)zoneKey) > 0L) {
            return;
        }
        for (ZoneVO z : this.zoneService.listAllZones()) {
            List praiseUserVOS;
            this.redisTemplate.opsForHash().put((Object)zoneKey, (Object)z.getMsgID(), (Object)z);
            List commentVOS = this.zoneService.listCommentByZoneId(z.getMsgID());
            if (CollUtil.isNotEmpty((Collection)commentVOS)) {
                this.redisTemplate.opsForZSet().add((Object)(commentKey + z.getMsgID()), new HashSet(commentVOS));
            }
            if (!CollUtil.isNotEmpty((Collection)(praiseUserVOS = this.zoneService.listPraiseUserByZoneId(z.getMsgID())))) continue;
            this.redisTemplate.opsForZSet().add((Object)(praiseKey + z.getMsgID()), new HashSet(praiseUserVOS));
        }
    }
}

