/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.start;

import com.jxdinfo.hussar.core.launch.HussarBaseApplication;
import com.jxdinfo.hussar.core.web.HussarWebApplicationServletInitializer;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.MD5CredentialsMatcher;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@EnableFeignClients(basePackages={"com.jxdinfo.**.feign"})
@EnableDiscoveryClient
@SpringBootApplication
@ComponentScan(value={"com.jxdinfo.mp.**", "com.jxdinfo.mp.common.**"})
@MapperScan(basePackages={"com.jxdinfo.mp.**.dao"})
public class ZoneApplication
extends HussarWebApplicationServletInitializer {
    protected static final Logger logger = LoggerFactory.getLogger(ZoneApplication.class);

    protected Class<?> mainApplicationClass() {
        return ZoneApplication.class;
    }

    public static void main(String[] args) {
        HussarBaseApplication.run(ZoneApplication.class, (String[])args);
        logger.info("ZoneServiceApplication is success!");
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.core.encrypt", name={"type"}, havingValue="md5")
    public AbstractCredentialsMatcher md5CredentialsMatcher() {
        return new MD5CredentialsMatcher();
    }
}

